/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.Log;
import hive.org.apache.parquet.hadoop.Footer;
import hive.org.apache.parquet.hadoop.ParquetFileReader;
import hive.org.apache.parquet.hadoop.ParquetFileWriter;
import hive.org.apache.parquet.hadoop.util.ContextUtil;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class ParquetOutputCommitter
extends FileOutputCommitter {
    private static final Log LOG = Log.getLog(ParquetOutputCommitter.class);
    private final Path outputPath;

    public ParquetOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.outputPath = outputPath;
    }

    public void commitJob(JobContext jobContext) throws IOException {
        super.commitJob(jobContext);
        Configuration configuration = ContextUtil.getConfiguration(jobContext);
        ParquetOutputCommitter.writeMetaDataFile(configuration, this.outputPath);
    }

    public static void writeMetaDataFile(Configuration configuration, Path outputPath) {
        if (configuration.getBoolean("parquet.enable.summary-metadata", true)) {
            try {
                FileSystem fileSystem = outputPath.getFileSystem(configuration);
                FileStatus outputStatus = fileSystem.getFileStatus(outputPath);
                List<Footer> footers = ParquetFileReader.readAllFootersInParallel(configuration, outputStatus);
                if (footers.isEmpty()) {
                    return;
                }
                try {
                    ParquetFileWriter.writeMetadataFile(configuration, outputPath, footers);
                }
                catch (Exception e) {
                    LOG.warn("could not write summary file for " + outputPath, e);
                    Path metadataPath = new Path(outputPath, "_metadata");
                    if (fileSystem.exists(metadataPath)) {
                        fileSystem.delete(metadataPath, true);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("could not write summary file for " + outputPath, e);
            }
        }
    }
}

