/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.filter2.compat;

import hive.org.apache.parquet.Log;
import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.filter.UnboundRecordFilter;
import hive.org.apache.parquet.filter2.predicate.FilterPredicate;
import hive.org.apache.parquet.filter2.predicate.LogicalInverseRewriter;

public class FilterCompat {
    private static final Log LOG = Log.getLog(FilterCompat.class);
    public static final Filter NOOP = new NoOpFilter();

    public static Filter get(FilterPredicate filterPredicate) {
        Preconditions.checkNotNull(filterPredicate, "filterPredicate");
        LOG.info("Filtering using predicate: " + filterPredicate);
        FilterPredicate collapsedPredicate = LogicalInverseRewriter.rewrite(filterPredicate);
        if (!filterPredicate.equals(collapsedPredicate)) {
            LOG.info("Predicate has been collapsed to: " + collapsedPredicate);
        }
        return new FilterPredicateCompat(collapsedPredicate);
    }

    public static Filter get(UnboundRecordFilter unboundRecordFilter) {
        return new UnboundRecordFilterCompat(unboundRecordFilter);
    }

    public static Filter get(FilterPredicate filterPredicate, UnboundRecordFilter unboundRecordFilter) {
        Preconditions.checkArgument(filterPredicate == null || unboundRecordFilter == null, "Cannot provide both a FilterPredicate and an UnboundRecordFilter");
        if (filterPredicate != null) {
            return FilterCompat.get(filterPredicate);
        }
        if (unboundRecordFilter != null) {
            return FilterCompat.get(unboundRecordFilter);
        }
        return NOOP;
    }

    public static final class NoOpFilter
    implements Filter {
        private NoOpFilter() {
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class UnboundRecordFilterCompat
    implements Filter {
        private final UnboundRecordFilter unboundRecordFilter;

        private UnboundRecordFilterCompat(UnboundRecordFilter unboundRecordFilter) {
            this.unboundRecordFilter = Preconditions.checkNotNull(unboundRecordFilter, "unboundRecordFilter");
        }

        public UnboundRecordFilter getUnboundRecordFilter() {
            return this.unboundRecordFilter;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class FilterPredicateCompat
    implements Filter {
        private final FilterPredicate filterPredicate;

        private FilterPredicateCompat(FilterPredicate filterPredicate) {
            this.filterPredicate = Preconditions.checkNotNull(filterPredicate, "filterPredicate");
        }

        public FilterPredicate getFilterPredicate() {
            return this.filterPredicate;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface Filter {
        public <R> R accept(Visitor<R> var1);
    }

    public static interface Visitor<T> {
        public T visit(FilterPredicateCompat var1);

        public T visit(UnboundRecordFilterCompat var1);

        public T visit(NoOpFilter var1);
    }
}

