/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.plain;

import hive.org.apache.parquet.Log;
import hive.org.apache.parquet.bytes.BytesUtils;
import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.io.ParquetDecodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;

public class BinaryPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BinaryPlainValuesReader.class);
    private byte[] in;
    private int offset;

    @Override
    public Binary readBytes() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            int start = this.offset + 4;
            this.offset = start + length;
            return Binary.fromConstantByteArray(this.in, start, length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            this.offset += 4 + length;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = in;
        this.offset = offset;
    }
}

