/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.statistics;

import hive.org.apache.parquet.column.UnknownColumnTypeException;
import hive.org.apache.parquet.column.statistics.BinaryStatistics;
import hive.org.apache.parquet.column.statistics.BooleanStatistics;
import hive.org.apache.parquet.column.statistics.DoubleStatistics;
import hive.org.apache.parquet.column.statistics.FloatStatistics;
import hive.org.apache.parquet.column.statistics.IntStatistics;
import hive.org.apache.parquet.column.statistics.LongStatistics;
import hive.org.apache.parquet.column.statistics.StatisticsClassException;
import hive.org.apache.parquet.io.api.Binary;
import hive.org.apache.parquet.schema.PrimitiveType;
import java.util.Arrays;

public abstract class Statistics<T extends Comparable<T>> {
    private boolean hasNonNullValue = false;
    private long num_nulls = 0L;

    public static Statistics getStatsBasedOnType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT32: {
                return new IntStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case BINARY: {
                return new BinaryStatistics();
            }
            case INT96: {
                return new BinaryStatistics();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new BinaryStatistics();
            }
        }
        throw new UnknownColumnTypeException(type);
    }

    public void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Statistics)) {
            return false;
        }
        Statistics stats = (Statistics)other;
        return Arrays.equals(stats.getMaxBytes(), this.getMaxBytes()) && Arrays.equals(stats.getMinBytes(), this.getMinBytes()) && stats.getNumNulls() == this.getNumNulls();
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getMaxBytes()) + 17 * Arrays.hashCode(this.getMinBytes()) + Long.valueOf(this.getNumNulls()).hashCode();
    }

    public void mergeStatistics(Statistics stats) {
        if (stats.isEmpty()) {
            return;
        }
        if (this.getClass() == stats.getClass()) {
            this.incrementNumNulls(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                this.mergeStatisticsMinMax(stats);
                this.markAsNotEmpty();
            }
        } else {
            throw new StatisticsClassException(this.getClass().toString(), stats.getClass().toString());
        }
    }

    protected abstract void mergeStatisticsMinMax(Statistics var1);

    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract T genericGetMin();

    public abstract T genericGetMax();

    public abstract byte[] getMaxBytes();

    public abstract byte[] getMinBytes();

    public abstract String toString();

    public void incrementNumNulls() {
        ++this.num_nulls;
    }

    public void incrementNumNulls(long increment) {
        this.num_nulls += increment;
    }

    public long getNumNulls() {
        return this.num_nulls;
    }

    public void setNumNulls(long nulls) {
        this.num_nulls = nulls;
    }

    public boolean isEmpty() {
        return !this.hasNonNullValue && this.num_nulls == 0L;
    }

    public boolean hasNonNullValue() {
        return this.hasNonNullValue;
    }

    protected void markAsNotEmpty() {
        this.hasNonNullValue = true;
    }
}

