/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.page;

import hive.org.apache.parquet.Ints;
import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.page.Page;
import java.io.IOException;

public class DictionaryPage
extends Page {
    private final BytesInput bytes;
    private final int dictionarySize;
    private final Encoding encoding;

    public DictionaryPage(BytesInput bytes, int dictionarySize, Encoding encoding) {
        this(bytes, (int)bytes.size(), dictionarySize, encoding);
    }

    public DictionaryPage(BytesInput bytes, int uncompressedSize, int dictionarySize, Encoding encoding) {
        super(Ints.checkedCast(bytes.size()), uncompressedSize);
        this.bytes = Preconditions.checkNotNull(bytes, "bytes");
        this.dictionarySize = dictionarySize;
        this.encoding = Preconditions.checkNotNull(encoding, "encoding");
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public DictionaryPage copy() throws IOException {
        return new DictionaryPage(BytesInput.copy(this.bytes), this.getUncompressedSize(), this.dictionarySize, this.encoding);
    }

    public String toString() {
        return "Page [bytes.size=" + this.bytes.size() + ", entryCount=" + this.dictionarySize + ", uncompressedSize=" + this.getUncompressedSize() + ", encoding=" + (Object)((Object)this.encoding) + "]";
    }
}

