/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.page;

import hive.org.apache.parquet.Ints;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.page.DataPage;
import hive.org.apache.parquet.column.statistics.Statistics;

public class DataPageV1
extends DataPage {
    private final BytesInput bytes;
    private final Statistics<?> statistics;
    private final Encoding rlEncoding;
    private final Encoding dlEncoding;
    private final Encoding valuesEncoding;

    public DataPageV1(BytesInput bytes, int valueCount, int uncompressedSize, Statistics<?> stats, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) {
        super(Ints.checkedCast(bytes.size()), uncompressedSize, valueCount);
        this.bytes = bytes;
        this.statistics = stats;
        this.rlEncoding = rlEncoding;
        this.dlEncoding = dlEncoding;
        this.valuesEncoding = valuesEncoding;
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    public Encoding getDlEncoding() {
        return this.dlEncoding;
    }

    public Encoding getRlEncoding() {
        return this.rlEncoding;
    }

    public Encoding getValueEncoding() {
        return this.valuesEncoding;
    }

    public String toString() {
        return "Page [bytes.size=" + this.bytes.size() + ", valueCount=" + this.getValueCount() + ", uncompressedSize=" + this.getUncompressedSize() + "]";
    }

    @Override
    public <T> T accept(DataPage.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

