/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.impl;

import hive.org.apache.parquet.Log;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.ColumnWriter;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.column.page.DictionaryPage;
import hive.org.apache.parquet.column.page.PageWriter;
import hive.org.apache.parquet.column.statistics.Statistics;
import hive.org.apache.parquet.column.values.ValuesWriter;
import hive.org.apache.parquet.io.ParquetEncodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;

final class ColumnWriterV1
implements ColumnWriter {
    private static final Log LOG = Log.getLog(ColumnWriterV1.class);
    private static final boolean DEBUG = Log.DEBUG;
    private static final int INITIAL_COUNT_FOR_SIZE_CHECK = 100;
    private static final int MIN_SLAB_SIZE = 64;
    private final ColumnDescriptor path;
    private final PageWriter pageWriter;
    private final long pageSizeThreshold;
    private ValuesWriter repetitionLevelColumn;
    private ValuesWriter definitionLevelColumn;
    private ValuesWriter dataColumn;
    private int valueCount;
    private int valueCountForNextSizeCheck;
    private Statistics statistics;

    public ColumnWriterV1(ColumnDescriptor path, PageWriter pageWriter, int pageSizeThreshold, int dictionaryPageSizeThreshold, boolean enableDictionary, ParquetProperties.WriterVersion writerVersion) {
        this.path = path;
        this.pageWriter = pageWriter;
        this.pageSizeThreshold = pageSizeThreshold;
        this.valueCountForNextSizeCheck = 100;
        this.resetStatistics();
        ParquetProperties parquetProps = new ParquetProperties(dictionaryPageSizeThreshold, writerVersion, enableDictionary);
        this.repetitionLevelColumn = ParquetProperties.getColumnDescriptorValuesWriter(path.getMaxRepetitionLevel(), 64, pageSizeThreshold);
        this.definitionLevelColumn = ParquetProperties.getColumnDescriptorValuesWriter(path.getMaxDefinitionLevel(), 64, pageSizeThreshold);
        int initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic(64, pageSizeThreshold, 10);
        this.dataColumn = parquetProps.getValuesWriter(path, initialSlabSize, pageSizeThreshold);
    }

    private void log(Object value, int r, int d) {
        LOG.debug(this.path + " " + value + " r:" + r + " d:" + d);
    }

    private void resetStatistics() {
        this.statistics = Statistics.getStatsBasedOnType(this.path.getType());
    }

    private void accountForValueWritten() {
        ++this.valueCount;
        if (this.valueCount > this.valueCountForNextSizeCheck) {
            long memSize = this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize();
            if (memSize > this.pageSizeThreshold) {
                this.valueCountForNextSizeCheck = this.valueCount / 2;
                this.writePage();
            } else {
                this.valueCountForNextSizeCheck = (int)((float)this.valueCount + (float)this.valueCount * (float)this.pageSizeThreshold / (float)memSize) / 2 + 1;
            }
        }
    }

    private void updateStatisticsNumNulls() {
        this.statistics.incrementNumNulls();
    }

    private void updateStatistics(int value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(long value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(float value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(double value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(Binary value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(boolean value) {
        this.statistics.updateStats(value);
    }

    private void writePage() {
        if (DEBUG) {
            LOG.debug("write page");
        }
        try {
            this.pageWriter.writePage(BytesInput.concat(this.repetitionLevelColumn.getBytes(), this.definitionLevelColumn.getBytes(), this.dataColumn.getBytes()), this.valueCount, this.statistics, this.repetitionLevelColumn.getEncoding(), this.definitionLevelColumn.getEncoding(), this.dataColumn.getEncoding());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page for " + this.path, e);
        }
        this.repetitionLevelColumn.reset();
        this.definitionLevelColumn.reset();
        this.dataColumn.reset();
        this.valueCount = 0;
        this.resetStatistics();
    }

    @Override
    public void writeNull(int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(null, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.updateStatisticsNumNulls();
        this.accountForValueWritten();
    }

    @Override
    public void write(double value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeDouble(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(float value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(Float.valueOf(value), repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeFloat(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(Binary value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBytes(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(boolean value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBoolean(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(int value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeInteger(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(long value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeLong(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    public void flush() {
        DictionaryPage dictionaryPage;
        if (this.valueCount > 0) {
            this.writePage();
        }
        if ((dictionaryPage = this.dataColumn.createDictionaryPage()) != null) {
            if (DEBUG) {
                LOG.debug("write dictionary");
            }
            try {
                this.pageWriter.writeDictionaryPage(dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not write dictionary page for " + this.path, e);
            }
            this.dataColumn.resetDictionary();
        }
    }

    public long getBufferedSizeInMemory() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    public long allocatedSize() {
        return this.repetitionLevelColumn.getAllocatedSize() + this.definitionLevelColumn.getAllocatedSize() + this.dataColumn.getAllocatedSize() + this.pageWriter.allocatedSize();
    }

    public String memUsageString(String indent) {
        StringBuilder b = new StringBuilder(indent).append(this.path).append(" {\n");
        b.append(this.repetitionLevelColumn.memUsageString(indent + "  r:")).append("\n");
        b.append(this.definitionLevelColumn.memUsageString(indent + "  d:")).append("\n");
        b.append(this.dataColumn.memUsageString(indent + "  data:")).append("\n");
        b.append(this.pageWriter.memUsageString(indent + "  pages:")).append("\n");
        b.append(indent).append(String.format("  total: %,d/%,d", this.getBufferedSizeInMemory(), this.allocatedSize())).append("\n");
        b.append(indent).append("}\n");
        return b.toString();
    }
}

