/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.impl;

import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.ColumnWriteStore;
import hive.org.apache.parquet.column.ColumnWriter;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.column.impl.ColumnWriterV1;
import hive.org.apache.parquet.column.page.PageWriteStore;
import hive.org.apache.parquet.column.page.PageWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ColumnWriteStoreV1
implements ColumnWriteStore {
    private final Map<ColumnDescriptor, ColumnWriterV1> columns = new TreeMap<ColumnDescriptor, ColumnWriterV1>();
    private final PageWriteStore pageWriteStore;
    private final int pageSizeThreshold;
    private final int dictionaryPageSizeThreshold;
    private final boolean enableDictionary;
    private final ParquetProperties.WriterVersion writerVersion;

    public ColumnWriteStoreV1(PageWriteStore pageWriteStore, int pageSizeThreshold, int dictionaryPageSizeThreshold, boolean enableDictionary, ParquetProperties.WriterVersion writerVersion) {
        this.pageWriteStore = pageWriteStore;
        this.pageSizeThreshold = pageSizeThreshold;
        this.dictionaryPageSizeThreshold = dictionaryPageSizeThreshold;
        this.enableDictionary = enableDictionary;
        this.writerVersion = writerVersion;
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        ColumnWriterV1 column = this.columns.get(path);
        if (column == null) {
            column = this.newMemColumn(path);
            this.columns.put(path, column);
        }
        return column;
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    private ColumnWriterV1 newMemColumn(ColumnDescriptor path) {
        PageWriter pageWriter = this.pageWriteStore.getPageWriter(path);
        return new ColumnWriterV1(path, pageWriter, this.pageSizeThreshold, this.dictionaryPageSizeThreshold, this.enableDictionary, this.writerVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterV1> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getBufferedSizeInMemory()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterV1 memColumn : values) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    @Override
    public long getBufferedSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterV1 memColumn : values) {
            total += memColumn.getBufferedSizeInMemory();
        }
        return total;
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        Collection<ColumnWriterV1> values = this.columns.values();
        for (ColumnWriterV1 memColumn : values) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    public long maxColMemSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long max = 0L;
        for (ColumnWriterV1 memColumn : values) {
            max = Math.max(max, memColumn.getBufferedSizeInMemory());
        }
        return max;
    }

    @Override
    public void flush() {
        Collection<ColumnWriterV1> values = this.columns.values();
        for (ColumnWriterV1 memColumn : values) {
            memColumn.flush();
        }
    }

    @Override
    public void endRecord() {
    }
}

