/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred.tether;

import hive.org.apache.avro.mapred.AvroJob;
import hive.org.apache.avro.mapred.tether.TaskType;
import hive.org.apache.avro.mapred.tether.TetherData;
import hive.org.apache.avro.mapred.tether.TetheredProcess;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

class TetherReducer
implements Reducer<TetherData, NullWritable, TetherData, NullWritable> {
    private JobConf job;
    private TetheredProcess process;
    private boolean error;

    TetherReducer() {
    }

    public void configure(JobConf job) {
        this.job = job;
    }

    public void reduce(TetherData datum, Iterator<NullWritable> ignore, OutputCollector<TetherData, NullWritable> collector, Reporter reporter) throws IOException {
        try {
            if (this.process == null) {
                this.process = new TetheredProcess(this.job, collector, reporter);
                this.process.inputClient.configure(TaskType.REDUCE, AvroJob.getMapOutputSchema((Configuration)this.job).toString(), AvroJob.getOutputSchema((Configuration)this.job).toString());
            }
            this.process.inputClient.input(datum.buffer(), datum.count());
        }
        catch (IOException e) {
            this.error = true;
            throw e;
        }
        catch (Exception e) {
            this.error = true;
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        if (this.process == null) {
            return;
        }
        try {
            if (this.error) {
                this.process.inputClient.abort();
            } else {
                this.process.inputClient.complete();
            }
            this.process.outputService.waitForFinish();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.process.close();
        }
    }
}

