/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.ConvertExpression;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

public class MongoCompareFunctionProcessor
extends AbstractExprVisitor<Boolean, LogicalExpression, RuntimeException> {
    private Object value;
    private boolean success = false;
    private boolean isEqualityFn;
    private SchemaPath path;
    private String functionName;
    private static final ImmutableSet<Class<? extends LogicalExpression>> VALUE_EXPRESSION_CLASSES;
    private static final ImmutableMap<String, String> COMPARE_FUNCTIONS_TRANSPOSE_MAP;

    public static boolean isCompareFunction(String functionName) {
        return COMPARE_FUNCTIONS_TRANSPOSE_MAP.keySet().contains((Object)functionName);
    }

    public static MongoCompareFunctionProcessor process(FunctionCall call) {
        String functionName = call.getName();
        LogicalExpression nameArg = (LogicalExpression)call.args.get(0);
        LogicalExpression valueArg = call.args.size() == 2 ? (LogicalExpression)call.args.get(1) : null;
        MongoCompareFunctionProcessor evaluator = new MongoCompareFunctionProcessor(functionName);
        if (valueArg != null) {
            if (VALUE_EXPRESSION_CLASSES.contains(nameArg.getClass())) {
                LogicalExpression swapArg = valueArg;
                valueArg = nameArg;
                nameArg = swapArg;
                evaluator.functionName = (String)COMPARE_FUNCTIONS_TRANSPOSE_MAP.get((Object)functionName);
            }
            evaluator.success = (Boolean)nameArg.accept((ExprVisitor)evaluator, (Object)valueArg);
        } else if (call.args.get(0) instanceof SchemaPath) {
            evaluator.success = true;
            evaluator.path = (SchemaPath)nameArg;
        }
        return evaluator;
    }

    public MongoCompareFunctionProcessor(String functionName) {
        this.functionName = functionName;
        this.isEqualityFn = COMPARE_FUNCTIONS_TRANSPOSE_MAP.containsKey((Object)functionName) && ((String)COMPARE_FUNCTIONS_TRANSPOSE_MAP.get((Object)functionName)).equals(functionName);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Boolean visitCastExpression(CastExpression e, LogicalExpression valueArg) throws RuntimeException {
        if (e.getInput() instanceof CastExpression || e.getInput() instanceof SchemaPath) {
            return (Boolean)e.getInput().accept((ExprVisitor)this, (Object)valueArg);
        }
        return false;
    }

    public Boolean visitConvertExpression(ConvertExpression e, LogicalExpression valueArg) throws RuntimeException {
        if ("convert_from".equals(e.getConvertFunction()) && e.getInput() instanceof SchemaPath) {
            String encodingType;
            switch (encodingType = e.getEncodingType()) {
                case "INT_BE": 
                case "INT": 
                case "UINT_BE": 
                case "UINT": 
                case "UINT4_BE": 
                case "UINT4": {
                    if (!(valueArg instanceof ValueExpressions.IntExpression) || !this.isEqualityFn && !encodingType.startsWith("U")) break;
                    this.value = ((ValueExpressions.IntExpression)valueArg).getInt();
                    break;
                }
                case "BIGINT_BE": 
                case "BIGINT": 
                case "UINT8_BE": 
                case "UINT8": {
                    if (!(valueArg instanceof ValueExpressions.LongExpression) || !this.isEqualityFn && !encodingType.startsWith("U")) break;
                    this.value = ((ValueExpressions.LongExpression)valueArg).getLong();
                    break;
                }
                case "FLOAT": {
                    if (!(valueArg instanceof ValueExpressions.FloatExpression) || !this.isEqualityFn) break;
                    this.value = Float.valueOf(((ValueExpressions.FloatExpression)valueArg).getFloat());
                    break;
                }
                case "DOUBLE": {
                    if (!(valueArg instanceof ValueExpressions.DoubleExpression) || !this.isEqualityFn) break;
                    this.value = ((ValueExpressions.DoubleExpression)valueArg).getDouble();
                    break;
                }
                case "TIME_EPOCH": 
                case "TIME_EPOCH_BE": {
                    if (!(valueArg instanceof ValueExpressions.TimeExpression)) break;
                    this.value = ((ValueExpressions.TimeExpression)valueArg).getTime();
                    break;
                }
                case "DATE_EPOCH": 
                case "DATE_EPOCH_BE": {
                    if (!(valueArg instanceof ValueExpressions.DateExpression)) break;
                    this.value = ((ValueExpressions.DateExpression)valueArg).getDate();
                    break;
                }
                case "BOOLEAN_BYTE": {
                    if (!(valueArg instanceof ValueExpressions.BooleanExpression)) break;
                    this.value = ((ValueExpressions.BooleanExpression)valueArg).getBoolean();
                    break;
                }
                case "UTF8": {
                    return (Boolean)e.getInput().accept((ExprVisitor)this, (Object)valueArg);
                }
            }
            if (this.value != null) {
                this.path = (SchemaPath)e.getInput();
                return true;
            }
        }
        return false;
    }

    public Boolean visitUnknown(LogicalExpression e, LogicalExpression valueArg) throws RuntimeException {
        return false;
    }

    public Boolean visitSchemaPath(SchemaPath path, LogicalExpression valueArg) throws RuntimeException {
        if (valueArg instanceof ValueExpressions.QuotedString) {
            this.value = ((ValueExpressions.QuotedString)valueArg).value;
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.IntExpression) {
            this.value = ((ValueExpressions.IntExpression)valueArg).getInt();
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.LongExpression) {
            this.value = ((ValueExpressions.LongExpression)valueArg).getLong();
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.FloatExpression) {
            this.value = Float.valueOf(((ValueExpressions.FloatExpression)valueArg).getFloat());
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.DoubleExpression) {
            this.value = ((ValueExpressions.DoubleExpression)valueArg).getDouble();
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.BooleanExpression) {
            this.value = ((ValueExpressions.BooleanExpression)valueArg).getBoolean();
            this.path = path;
            return true;
        }
        if (valueArg instanceof ValueExpressions.VarDecimalExpression) {
            this.value = ((ValueExpressions.VarDecimalExpression)valueArg).getBigDecimal().doubleValue();
            this.path = path;
            return true;
        }
        return false;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        VALUE_EXPRESSION_CLASSES = builder.add(ValueExpressions.BooleanExpression.class).add(ValueExpressions.DateExpression.class).add(ValueExpressions.DoubleExpression.class).add(ValueExpressions.FloatExpression.class).add(ValueExpressions.IntExpression.class).add(ValueExpressions.LongExpression.class).add(ValueExpressions.QuotedString.class).add(ValueExpressions.TimeExpression.class).add(ValueExpressions.VarDecimalExpression.class).build();
        builder = ImmutableMap.builder();
        COMPARE_FUNCTIONS_TRANSPOSE_MAP = builder.put((Object)"isnotnull", (Object)"isnotnull").put((Object)"isNotNull", (Object)"isNotNull").put((Object)"is not null", (Object)"is not null").put((Object)"isnull", (Object)"isnull").put((Object)"isNull", (Object)"isNull").put((Object)"is null", (Object)"is null").put((Object)"equal", (Object)"equal").put((Object)"not_equal", (Object)"not_equal").put((Object)"greater_than_or_equal_to", (Object)"less_than_or_equal_to").put((Object)"greater_than", (Object)"less_than").put((Object)"less_than_or_equal_to", (Object)"greater_than_or_equal_to").put((Object)"less_than", (Object)"greater_than").build();
    }
}

