/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.output;

import com.mapr.db.mapreduce.TableOutputFormat;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.maprdb.json.shims.RecordWriterWrapper;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMapRDBJsonOutputFormat
extends TableOutputFormat
implements HiveOutputFormat<NullWritable, DocumentWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMapRDBJsonOutputFormat.class);

    public RecordWriter<NullWritable, DocumentWritable> getRecordWriter(FileSystem ignored, JobConf jobConf, String name, Progressable progress) throws IOException {
        return this.getRecordWriterWrapper(jobConf, progress);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf jobConf) throws IOException {
        Job job = new Job((Configuration)jobConf);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        try {
            this.checkOutputSpecs(jobContext);
        }
        catch (InterruptedException e) {
            throw new IOException("Error validating output specification for the job", e);
        }
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        return this.getRecordWriterWrapper(jc, progress);
    }

    private RecordWriterWrapper getRecordWriterWrapper(JobConf jobConf, Progressable progress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("maprdb.mapred.outputtable = {}", (Object)jobConf.get("maprdb.table.name"));
        }
        jobConf.set("maprdb.mapred.outputtable", jobConf.get("maprdb.table.name"));
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext((Configuration)jobConf, progress);
        try {
            org.apache.hadoop.mapreduce.RecordWriter recordWriter = this.getRecordWriter(tac);
            return new RecordWriterWrapper((org.apache.hadoop.mapreduce.RecordWriter<Value, Document>)recordWriter, tac);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to initialize RecordWriter", e);
        }
    }
}

