/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final String CLASS = ".class";
    private static final String FILE = "file:";
    private static final String JAR = "jar";

    private Utils() {
    }

    static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = Utils.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn("Could not validate jar file " + path + " for class " + clazz);
                continue;
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    private static Path findOrCreateJar(Class<?> myClass, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = Utils.findContainingJar(myClass, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = Utils.getJar(myClass);
            Utils.updateMap(jar, packagedClasses);
        }
        if (null == jar || jar.isEmpty()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("For class %s, using jar %s", myClass.getName(), jar));
        }
        return new Path(jar).makeQualified(fs);
    }

    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (null == jar || jar.isEmpty()) {
            return;
        }
        try (ZipFile zip = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
    }

    private static String findContainingJar(Class<?> myClass, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = myClass.getClassLoader();
        String class_file = myClass.getName().replaceAll("\\.", "/") + CLASS;
        Enumeration<URL> itr = loader.getResources(class_file);
        while (itr.hasMoreElements()) {
            URL url = itr.nextElement();
            if (!JAR.equals(url.getProtocol())) continue;
            String toReturn = url.getPath();
            if (toReturn.startsWith(FILE)) {
                toReturn = toReturn.substring(FILE.length());
            }
            toReturn = toReturn.replaceAll("\\+", "%2B");
            toReturn = URLDecoder.decode(toReturn, Charsets.UTF_8.name());
            return toReturn.replaceAll("!.*$", "");
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> myClass) {
        String ret = null;
        String hadoopJarFinder = "org.apache.hadoop.util.JarFinder";
        Class jarFinder = null;
        try {
            LOG.debug("Looking for " + hadoopJarFinder + ".");
            jarFinder = JavaUtils.loadClass((String)hadoopJarFinder);
            LOG.debug(hadoopJarFinder + " found.");
            Method getJar = jarFinder.getMethod("getJar", Class.class);
            ret = (String)getJar.invoke(null, myClass);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Using backported JarFinder.");
            ret = Utils.jarFinderGetJar(myClass);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("getJar invocation failed.", e);
        }
        return ret;
    }

    public static String jarFinderGetJar(Class clazz) {
        Preconditions.checkNotNull((Object)clazz, (Object)"clazz");
        ClassLoader loader = clazz.getClassLoader();
        if (loader != null) {
            String classFile = clazz.getName().replaceAll("\\.", "/") + CLASS;
            try {
                Enumeration<URL> itr = loader.getResources(classFile);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith(FILE)) {
                        path = path.substring(FILE.length());
                    }
                    path = URLDecoder.decode(path, Charsets.UTF_8.name());
                    if (JAR.equals(url.getProtocol())) {
                        path = URLDecoder.decode(path, Charsets.UTF_8.name());
                        return path.replaceAll("!.*$", "");
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    String klassName = clazz.getName();
                    klassName = klassName.replace(".", "/") + CLASS;
                    path = path.substring(0, path.length() - klassName.length());
                    File baseDir = new File(path);
                    File testDir = new File(System.getProperty("test.build.dir", "target/test-dir"));
                    if (!(testDir = testDir.getAbsoluteFile()).exists()) {
                        testDir.mkdirs();
                    }
                    File tempJar = File.createTempFile("hadoop-", "", testDir);
                    tempJar = new File(tempJar.getAbsolutePath() + ".jar");
                    Utils.createJar(baseDir, tempJar);
                    return tempJar.getAbsolutePath();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static void copyToZipStream(InputStream is, ZipEntry entry, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(entry);
        byte[] arr = new byte[4096];
        int read = is.read(arr);
        while (read > -1) {
            zos.write(arr, 0, read);
            read = is.read(arr);
        }
        is.close();
        zos.closeEntry();
    }

    public static void jarDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        Preconditions.checkNotNull((Object)relativePath, (Object)"relativePath");
        Preconditions.checkNotNull((Object)zos, (Object)"zos");
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            zos.putNextEntry(manifestEntry);
            new Manifest().write(new BufferedOutputStream(zos));
            zos.closeEntry();
        } else {
            FileInputStream is = new FileInputStream(manifestFile);
            Utils.copyToZipStream(is, manifestEntry, zos);
        }
        zos.closeEntry();
        Utils.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList;
        for (String aDirList : dirList = dir.list()) {
            File f = new File(dir, aDirList);
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!start) {
                    ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                    zos.putNextEntry(dirEntry);
                    zos.closeEntry();
                }
                String filePath = f.getPath();
                File file = new File(filePath);
                Utils.zipDir(file, relativePath + f.getName() + "/", zos, false);
                continue;
            }
            String path = relativePath + f.getName();
            if (path.equals("META-INF/MANIFEST.MF")) continue;
            ZipEntry anEntry = new ZipEntry(path);
            FileInputStream is = new FileInputStream(f);
            Utils.copyToZipStream(is, anEntry, zos);
        }
    }

    private static void createJar(File dir, File jarFile) throws IOException {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        Preconditions.checkNotNull((Object)jarFile, (Object)"jarFile");
        File jarDir = jarFile.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(MessageFormat.format("could not create dir [{0}]", jarDir));
        }
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(jarFile));
        Utils.jarDir(dir, "", zos);
    }
}

