/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class Wagner3Projection
extends PseudoCylindricalProjection {
    private static final double TWOTHIRD = 0.6666666666666666;
    private double C_x;

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        xy.x = this.C_x * lplam * Math.cos(0.6666666666666666 * lpphi);
        xy.y = lpphi;
        return xy;
    }

    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        lp.y = y;
        lp.x = x / (this.C_x * Math.cos(0.6666666666666666 * lp.y));
        return lp;
    }

    public void initialize() {
        super.initialize();
        this.C_x = Math.cos(this.trueScaleLatitude) / Math.cos(2.0 * this.trueScaleLatitude / 3.0);
        this.es = 0.0;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Wagner III";
    }
}

