/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.argumentMatching.AlwaysTrueMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.CaptureMatcher;
import mockit.internal.expectations.argumentMatching.ClassMatcher;
import mockit.internal.expectations.argumentMatching.HamcrestAdapter;
import mockit.internal.expectations.argumentMatching.InequalityMatcher;
import mockit.internal.expectations.argumentMatching.LenientEqualityMatcher;
import mockit.internal.expectations.argumentMatching.NonNullityMatcher;
import mockit.internal.expectations.argumentMatching.NullityMatcher;
import mockit.internal.expectations.argumentMatching.NumericEqualityMatcher;
import mockit.internal.expectations.argumentMatching.PatternMatcher;
import mockit.internal.expectations.argumentMatching.ReflectiveMatcher;
import mockit.internal.expectations.argumentMatching.SamenessMatcher;
import mockit.internal.expectations.argumentMatching.StringContainmentMatcher;
import mockit.internal.expectations.argumentMatching.StringPrefixMatcher;
import mockit.internal.expectations.argumentMatching.StringSuffixMatcher;
import mockit.internal.startup.Startup;
import mockit.internal.util.DefaultValues;
import org.hamcrest.Matcher;

abstract class Invocations {
    @Nullable
    protected final Object any = null;
    @Nonnull
    protected final String anyString = new String();
    @Nonnull
    protected final Long anyLong = 0L;
    @Nonnull
    protected final Integer anyInt = 0;
    @Nonnull
    protected final Short anyShort = 0;
    @Nonnull
    protected final Byte anyByte = 0;
    @Nonnull
    protected final Boolean anyBoolean = false;
    @Nonnull
    protected final Character anyChar = Character.valueOf('\u0000');
    @Nonnull
    protected final Double anyDouble = 0.0;
    @Nonnull
    protected final Float anyFloat = Float.valueOf(0.0f);
    @Nonnegative
    protected int times;
    protected int minTimes;
    protected int maxTimes;

    Invocations() {
    }

    @Nullable
    abstract TestOnlyPhase getCurrentPhase();

    @Nullable
    @Deprecated
    protected final <T> T withArgThat(@Nonnull Matcher<? super T> argumentMatcher) {
        HamcrestAdapter matcher = new HamcrestAdapter(argumentMatcher);
        this.addMatcher(matcher);
        Object argValue = matcher.getInnerValue();
        return (T)argValue;
    }

    @Nullable
    protected final <T> T with(@Nonnull Delegate<? super T> objectWithDelegateMethod) {
        Class<?> delegateClass = objectWithDelegateMethod.getClass();
        Type[] genericInterfaces = delegateClass.getGenericInterfaces();
        while (genericInterfaces.length == 0) {
            delegateClass = delegateClass.getSuperclass();
            genericInterfaces = delegateClass.getGenericInterfaces();
        }
        if (!(genericInterfaces[0] instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Delegate class lacks the parameter type");
        }
        ParameterizedType type = (ParameterizedType)genericInterfaces[0];
        Type parameterType = type.getActualTypeArguments()[0];
        this.addMatcher(new ReflectiveMatcher(objectWithDelegateMethod));
        return DefaultValues.computeForWrapperType(parameterType);
    }

    private void addMatcher(@Nonnull ArgumentMatcher<?> matcher) {
        TestOnlyPhase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            currentPhase.addArgMatcher(matcher);
        }
    }

    @Nonnull
    protected final <T> T withAny(@Nonnull T arg) {
        ArgumentMatcher<?> matcher = arg instanceof String ? AlwaysTrueMatcher.ANY_STRING : (arg instanceof Integer ? AlwaysTrueMatcher.ANY_INT : (arg instanceof Boolean ? AlwaysTrueMatcher.ANY_BOOLEAN : (arg instanceof Character ? AlwaysTrueMatcher.ANY_CHAR : (arg instanceof Double ? AlwaysTrueMatcher.ANY_DOUBLE : (arg instanceof Float ? AlwaysTrueMatcher.ANY_FLOAT : (arg instanceof Long ? AlwaysTrueMatcher.ANY_LONG : (arg instanceof Byte ? AlwaysTrueMatcher.ANY_BYTE : (arg instanceof Short ? AlwaysTrueMatcher.ANY_SHORT : AlwaysTrueMatcher.ANY_VALUE))))))));
        this.addMatcher(matcher);
        return arg;
    }

    @Nullable
    protected final <T> T withCapture(@Nonnull List<T> valueHolderForMultipleInvocations) {
        this.addMatcher(new CaptureMatcher<T>(valueHolderForMultipleInvocations));
        return null;
    }

    @Nonnull
    protected final <T> T withEqual(@Nonnull T arg) {
        TestOnlyPhase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            Map<Object, Object> instanceMap = currentPhase.getInstanceMap();
            this.addMatcher(new LenientEqualityMatcher(arg, instanceMap));
        }
        return arg;
    }

    protected final double withEqual(double value, double delta) {
        this.addMatcher(new NumericEqualityMatcher(value, delta));
        return value;
    }

    protected final float withEqual(float value, double delta) {
        this.addMatcher(new NumericEqualityMatcher(value, delta));
        return value;
    }

    @Nonnull
    protected final <T> T withInstanceLike(@Nonnull T object) {
        this.addMatcher(ClassMatcher.create(object.getClass()));
        return object;
    }

    @Nullable
    protected final <T> T withInstanceOf(@Nonnull Class<T> argClass) {
        this.addMatcher(ClassMatcher.create(argClass));
        return null;
    }

    @Nonnull
    protected final <T> T withNotEqual(@Nonnull T arg) {
        this.addMatcher(new InequalityMatcher(arg));
        return arg;
    }

    @Nullable
    protected final <T> T withNull() {
        this.addMatcher(NullityMatcher.INSTANCE);
        return null;
    }

    @Nullable
    protected final <T> T withNotNull() {
        this.addMatcher(NonNullityMatcher.INSTANCE);
        return null;
    }

    @Nonnull
    protected final <T> T withSameInstance(@Nonnull T object) {
        this.addMatcher(new SamenessMatcher(object));
        return object;
    }

    @Nonnull
    protected final <T extends CharSequence> T withSubstring(@Nonnull T text) {
        this.addMatcher(new StringContainmentMatcher(text));
        return text;
    }

    @Nonnull
    protected final <T extends CharSequence> T withPrefix(@Nonnull T text) {
        this.addMatcher(new StringPrefixMatcher(text));
        return text;
    }

    @Nonnull
    protected final <T extends CharSequence> T withSuffix(@Nonnull T text) {
        this.addMatcher(new StringSuffixMatcher(text));
        return text;
    }

    @Nonnull
    protected final <T extends CharSequence> T withMatch(@Nonnull T regex) {
        this.addMatcher(new PatternMatcher(regex.toString()));
        return regex;
    }

    static {
        Startup.verifyInitialization();
    }
}

