/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class DiskBasedDominantResourceCalculator
extends DominantResourceCalculator {
    private static final Log LOG = LogFactory.getLog(DiskBasedDominantResourceCalculator.class);
    private static final double ZERO_LIMIT = 0.0099999999999999;

    private static boolean isZero(double a) {
        return !(Math.abs(a) > 0.0099999999999999);
    }

    public static double divideAndCeilDouble(double a, double b) {
        if (DiskBasedDominantResourceCalculator.isZero(b)) {
            LOG.info((Object)("divideAndCeilDouble called with a=" + a + " b=" + b));
            return 0.0;
        }
        return Math.ceil(a / b);
    }

    public static double roundUpDisk(double a, double b) {
        return DiskBasedDominantResourceCalculator.isZero(b) ? a : DiskBasedDominantResourceCalculator.divideAndCeilDouble(a, b) * b;
    }

    public static double divideAndFloorDouble(double a, double b) {
        if (DiskBasedDominantResourceCalculator.isZero(b)) {
            LOG.info((Object)("divideAndFloorDouble called with a=" + a + " b=" + b));
            return 0.0;
        }
        return Math.floor(a / b);
    }

    public static double roundDownDisk(double a, double b) {
        return DiskBasedDominantResourceCalculator.isZero(b) ? a : DiskBasedDominantResourceCalculator.divideAndFloorDouble(a, b) * b;
    }

    @Override
    protected float getResourceAsValue(Resource clusterResource, Resource resource, boolean dominant) {
        return dominant ? Math.max(Math.max((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()), (float)(resource.getDisks() / clusterResource.getDisks())) : Math.min(Math.min((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()), (float)(resource.getDisks() / clusterResource.getDisks()));
    }

    @Override
    public int computeAvailableContainers(Resource available, Resource required) {
        int min = Math.min(available.getMemory() / required.getMemory(), available.getVirtualCores() / required.getVirtualCores());
        if (!DiskBasedDominantResourceCalculator.isZero(required.getDisks())) {
            min = Math.min(min, (int)(available.getDisks() / required.getDisks()));
        }
        return min;
    }

    @Override
    public float ratio(Resource a, Resource b) {
        float max = Math.max((float)a.getMemory() / (float)b.getMemory(), (float)a.getVirtualCores() / (float)b.getVirtualCores());
        if (!DiskBasedDominantResourceCalculator.isZero(b.getDisks())) {
            max = Math.max(max, (float)(a.getDisks() / b.getDisks()));
        }
        return max;
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DiskBasedDominantResourceCalculator.divideAndCeil(numerator.getMemory(), denominator), DiskBasedDominantResourceCalculator.divideAndCeil(numerator.getVirtualCores(), denominator), DiskBasedDominantResourceCalculator.divideAndCeilDouble(numerator.getDisks(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DiskBasedDominantResourceCalculator.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), stepFactor.getMemory()), maximumResource.getMemory());
        int normalizedCores = Math.min(DiskBasedDominantResourceCalculator.roundUp(Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        double normalizedDisk = Math.min(DiskBasedDominantResourceCalculator.roundUpDisk(Math.max(r.getDisks(), minimumResource.getDisks()), stepFactor.getDisks()), maximumResource.getDisks());
        return Resources.createResource(normalizedMemory, normalizedCores, normalizedDisk);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DiskBasedDominantResourceCalculator.roundUp(r.getMemory(), stepFactor.getMemory()), DiskBasedDominantResourceCalculator.roundUp(r.getVirtualCores(), stepFactor.getVirtualCores()), DiskBasedDominantResourceCalculator.roundUpDisk(r.getDisks(), stepFactor.getDisks()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DiskBasedDominantResourceCalculator.roundDown(r.getMemory(), stepFactor.getMemory()), DiskBasedDominantResourceCalculator.roundDown(r.getVirtualCores(), stepFactor.getVirtualCores()), DiskBasedDominantResourceCalculator.roundDownDisk(r.getDisks(), stepFactor.getDisks()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DiskBasedDominantResourceCalculator.roundUp((int)Math.ceil((double)r.getMemory() * by), stepFactor.getMemory()), DiskBasedDominantResourceCalculator.roundUp((int)Math.ceil((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()), DiskBasedDominantResourceCalculator.roundUpDisk(r.getDisks() * by, stepFactor.getDisks()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DiskBasedDominantResourceCalculator.roundDown((int)((double)r.getMemory() * by), stepFactor.getMemory()), DiskBasedDominantResourceCalculator.roundDown((int)((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()), DiskBasedDominantResourceCalculator.roundDownDisk(r.getDisks() * by, stepFactor.getDisks()));
    }
}

