/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryCopyService;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.JobEndNotifier;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobStartEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherImpl;
import org.apache.hadoop.mapreduce.v2.app.local.LocalContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.speculate.DefaultSpeculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.Speculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.log4j.LogManager;

public class MRAppMaster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MRAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private Clock clock;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    protected final MRAppMetrics metrics;
    private Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private List<AMInfo> amInfos;
    private AppContext context;
    private Dispatcher dispatcher;
    private ClientService clientService;
    private ContainerAllocator containerAllocator;
    private ContainerLauncher containerLauncher;
    private EventHandler<CommitterEvent> committerEventHandler;
    private Speculator speculator;
    private TaskAttemptListener taskAttemptListener;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private JobId jobId;
    private boolean newApiCommitter;
    private ClassLoader jobClassLoader;
    private OutputCommitter committer;
    private JobEventDispatcher jobEventDispatcher;
    private JobHistoryEventHandler jobHistoryEventHandler;
    private SpeculatorEventDispatcher speculatorEventDispatcher;
    private Job job;
    private Credentials jobCredentials = new Credentials();
    protected UserGroupInformation currentUser;
    @VisibleForTesting
    protected volatile boolean isLastAMRetry = false;
    boolean errorHappenedShutDown = false;
    private String shutDownMessage = null;
    JobStateInternal forcedState = null;
    private final ScheduledExecutorService logSyncer;
    private long recoveredJobStartTime = 0L;
    @VisibleForTesting
    protected AtomicBoolean successfullyUnregistered = new AtomicBoolean(false);

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime) {
        this(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, (Clock)new SystemClock(), appSubmitTime);
    }

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime) {
        super(MRAppMaster.class.getName());
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.metrics = MRAppMetrics.create();
        this.logSyncer = TaskLog.createLogSyncer();
        LOG.info((Object)("Created MRAppMaster for application " + applicationAttemptId));
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.createJobClassLoader(conf);
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.initJobCredentialsAndUGI(conf);
        this.context = new RunningAppContext(conf);
        this.appName = conf.get("mapreduce.job.name", "<missing app name>");
        conf.setInt("mapreduce.job.application.attempt.id", this.appAttemptID.getAttemptId());
        this.newApiCommitter = false;
        this.jobId = MRBuilderUtils.newJobId((ApplicationId)this.appAttemptID.getApplicationId(), (int)this.appAttemptID.getApplicationId().getId());
        int numReduceTasks = conf.getInt("mapreduce.job.reduces", 0);
        if (numReduceTasks > 0 && conf.getBoolean("mapred.reducer.new-api", false) || numReduceTasks == 0 && conf.getBoolean("mapred.mapper.new-api", false)) {
            this.newApiCommitter = true;
            LOG.info((Object)"Using mapred newApiCommitter.");
        }
        boolean copyHistory = false;
        this.committer = this.createOutputCommitter(conf);
        try {
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path stagingDir = MRApps.getStagingAreaDir((Configuration)conf, (String)user);
            FileSystem fs = this.getFileSystem(conf);
            boolean stagingExists = fs.exists(stagingDir);
            Path startCommitFile = MRApps.getStartJobCommitFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitStarted = fs.exists(startCommitFile);
            Path endCommitSuccessFile = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitSuccess = fs.exists(endCommitSuccessFile);
            Path endCommitFailureFile = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitFailure = fs.exists(endCommitFailureFile);
            if (!stagingExists) {
                this.isLastAMRetry = true;
                LOG.info((Object)("Attempt num: " + this.appAttemptID.getAttemptId() + " is last retry: " + this.isLastAMRetry + " because the staging dir doesn't exist."));
                this.errorHappenedShutDown = true;
                this.forcedState = JobStateInternal.ERROR;
                this.shutDownMessage = "Staging dir does not exist " + stagingDir;
                LOG.fatal((Object)this.shutDownMessage);
            } else if (commitStarted) {
                this.errorHappenedShutDown = true;
                this.isLastAMRetry = true;
                LOG.info((Object)("Attempt num: " + this.appAttemptID.getAttemptId() + " is last retry: " + this.isLastAMRetry + " because a commit was started."));
                copyHistory = true;
                if (commitSuccess) {
                    this.shutDownMessage = "We crashed after successfully committing. Recovering.";
                    this.forcedState = JobStateInternal.SUCCEEDED;
                } else if (commitFailure) {
                    this.shutDownMessage = "We crashed after a commit failure.";
                    this.forcedState = JobStateInternal.FAILED;
                } else if (this.isCommitJobRepeatable()) {
                    this.errorHappenedShutDown = false;
                    this.cleanupInterruptedCommit(conf, fs, startCommitFile);
                } else {
                    this.shutDownMessage = "We crashed durring a commit";
                    this.forcedState = JobStateInternal.ERROR;
                }
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Error while initializing", (Throwable)e);
        }
        if (this.errorHappenedShutDown) {
            this.dispatcher = this.createDispatcher();
            this.addIfService(this.dispatcher);
            NoopEventHandler eater = new NoopEventHandler();
            this.dispatcher.register(JobEventType.class, (EventHandler)eater);
            EventHandler<JobHistoryEvent> historyService = null;
            if (copyHistory) {
                historyService = this.createJobHistoryHandler(this.context);
                this.dispatcher.register(EventType.class, historyService);
            } else {
                this.dispatcher.register(EventType.class, (EventHandler)eater);
            }
            if (copyHistory) {
                this.addService((Service)this.createStagingDirCleaningService());
            }
            this.containerAllocator = this.createContainerAllocator(null, this.context);
            this.addIfService(this.containerAllocator);
            this.dispatcher.register(ContainerAllocator.EventType.class, (EventHandler)this.containerAllocator);
            if (copyHistory) {
                this.addIfService(historyService);
                JobHistoryCopyService cpHist = new JobHistoryCopyService(this.appAttemptID, this.dispatcher.getEventHandler());
                this.addIfService((Object)cpHist);
            }
        } else {
            this.dispatcher = this.createDispatcher();
            this.addIfService(this.dispatcher);
            this.clientService = this.createClientService(this.context);
            this.clientService.init(conf);
            this.containerAllocator = this.createContainerAllocator(this.clientService, this.context);
            this.committerEventHandler = this.createCommitterEventHandler(this.context, this.committer);
            this.addIfService(this.committerEventHandler);
            this.taskAttemptListener = this.createTaskAttemptListener(this.context);
            this.addIfService(this.taskAttemptListener);
            EventHandler<JobHistoryEvent> historyService = this.createJobHistoryHandler(this.context);
            this.dispatcher.register(EventType.class, historyService);
            this.jobEventDispatcher = new JobEventDispatcher();
            this.dispatcher.register(JobEventType.class, (EventHandler)this.jobEventDispatcher);
            this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher());
            this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher());
            this.dispatcher.register(CommitterEventType.class, this.committerEventHandler);
            if (conf.getBoolean("mapreduce.map.speculative", false) || conf.getBoolean("mapreduce.reduce.speculative", false)) {
                this.speculator = this.createSpeculator(conf, this.context);
                this.addIfService(this.speculator);
            }
            this.speculatorEventDispatcher = new SpeculatorEventDispatcher(conf);
            this.dispatcher.register(Speculator.EventType.class, (EventHandler)this.speculatorEventDispatcher);
            this.addService((Service)this.createStagingDirCleaningService());
            this.addIfService(this.containerAllocator);
            this.dispatcher.register(ContainerAllocator.EventType.class, (EventHandler)this.containerAllocator);
            this.containerLauncher = this.createContainerLauncher(this.context);
            this.addIfService(this.containerLauncher);
            this.dispatcher.register(ContainerLauncher.EventType.class, (EventHandler)this.containerLauncher);
            this.addIfService(historyService);
        }
        super.serviceInit(conf);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    private boolean isCommitJobRepeatable() throws IOException {
        boolean isRepeatable = false;
        Configuration conf = this.getConfig();
        if (this.committer != null) {
            final JobContext jobContext = this.getJobContextFromConf(conf);
            isRepeatable = this.callWithJobClassLoader(conf, new ExceptionAction<Boolean>(){

                @Override
                public Boolean call(Configuration conf) throws IOException {
                    return MRAppMaster.this.committer.isCommitJobRepeatable(jobContext);
                }
            });
        }
        return isRepeatable;
    }

    private JobContext getJobContextFromConf(Configuration conf) {
        if (this.newApiCommitter) {
            return new org.apache.hadoop.mapreduce.task.JobContextImpl(conf, (JobID)TypeConverter.fromYarn((JobId)this.getJobId()));
        }
        return new JobContextImpl(new JobConf(conf), (JobID)TypeConverter.fromYarn((JobId)this.getJobId()));
    }

    private void cleanupInterruptedCommit(Configuration conf, FileSystem fs, Path startCommitFile) throws IOException {
        LOG.info((Object)"Delete startJobCommitFile in case commit is not finished as successful or failed.");
        fs.delete(startCommitFile, false);
    }

    private OutputCommitter createOutputCommitter(Configuration conf) {
        return this.callWithJobClassLoader(conf, new Action<OutputCommitter>(){

            @Override
            public OutputCommitter call(Configuration conf) {
                OutputCommitter committer = null;
                LOG.info((Object)("OutputCommitter set in config " + conf.get("mapred.output.committer.class")));
                if (MRAppMaster.this.newApiCommitter) {
                    TaskId taskID = MRBuilderUtils.newTaskId((JobId)MRAppMaster.this.jobId, (int)0, (TaskType)TaskType.MAP);
                    TaskAttemptId attemptID = MRBuilderUtils.newTaskAttemptId((TaskId)taskID, (int)0);
                    TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)attemptID));
                    try {
                        OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)conf);
                        committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
                    }
                    catch (Exception e) {
                        throw new YarnRuntimeException((Throwable)e);
                    }
                } else {
                    committer = (OutputCommitter)ReflectionUtils.newInstance((Class)conf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)conf);
                }
                LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
                return committer;
            }
        });
    }

    protected boolean keepJobFiles(JobConf conf) {
        return conf.getKeepTaskFilesPattern() != null || conf.getKeepFailedTaskFiles();
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    protected Credentials getCredentials() {
        return this.jobCredentials;
    }

    public void cleanupStagingDir() throws IOException {
        String jobTempDir = null;
        FileSystem fs = this.getFileSystem(this.getConfig());
        try {
            if (!this.keepJobFiles(new JobConf(this.getConfig()))) {
                jobTempDir = this.getConfig().get("mapreduce.job.dir");
                if (jobTempDir == null) {
                    LOG.warn((Object)"Job Staging directory is null");
                    return;
                }
                Path jobTempDirPath = new Path(jobTempDir);
                LOG.info((Object)("Deleting staging directory " + FileSystem.getDefaultUri((Configuration)this.getConfig()) + " " + jobTempDir));
                fs.delete(jobTempDirPath, true);
            }
        }
        catch (IOException io) {
            LOG.error((Object)("Failed to cleanup staging dir " + jobTempDir), (Throwable)io);
        }
    }

    protected void sysexit() {
        System.exit(0);
    }

    @VisibleForTesting
    public void shutDownJob() {
        try {
            if (!this.isLastAMRetry && ((JobImpl)this.job).getInternalState() != JobStateInternal.REBOOT) {
                LOG.info((Object)"We are finishing cleanly so this is the last retry");
                this.isLastAMRetry = true;
            }
            this.notifyIsLastAMRetry(this.isLastAMRetry);
            LOG.info((Object)"Calling stop for all the services");
            this.stop();
            if (this.isLastAMRetry && this.getConfig().get("mapreduce.job.end-notification.url") != null) {
                try {
                    LOG.info((Object)("Job end notification started for jobID : " + this.job.getReport().getJobId()));
                    JobEndNotifier notifier = new JobEndNotifier();
                    notifier.setConf(this.getConfig());
                    JobReport report = this.job.getReport();
                    if (!this.context.hasSuccessfullyUnregistered()) {
                        report.setJobState(JobState.FAILED);
                    }
                    notifier.notify(report);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Job end notification interrupted for jobID : " + this.job.getReport().getJobId()), (Throwable)ie);
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.clientService.stop();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Graceful stop failed. Exiting.. ", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    protected EventHandler<JobFinishEvent> createJobFinishEventHandler() {
        return new JobFinishEventHandler();
    }

    protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
        JobImpl newJob = new JobImpl(this.jobId, this.appAttemptID, conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.jobTokenSecretManager, this.jobCredentials, this.clock, this.completedTasksFromPreviousRun, this.metrics, this.committer, this.newApiCommitter, this.currentUser.getUserName(), this.appSubmitTime, this.amInfos, this.context, forcedState, diagnostic);
        ((RunningAppContext)this.context).jobs.put(newJob.getID(), newJob);
        this.dispatcher.register(JobFinishEvent.Type.class, this.createJobFinishEventHandler());
        return newJob;
    }

    protected void initJobCredentialsAndUGI(Configuration conf) {
        try {
            this.currentUser = UserGroupInformation.getCurrentUser();
            this.jobCredentials = ((JobConf)conf).getCredentials();
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        this.jobHistoryEventHandler = new JobHistoryEventHandler(context, this.getStartCount());
        return this.jobHistoryEventHandler;
    }

    protected AbstractService createStagingDirCleaningService() {
        return new StagingDirCleaningService();
    }

    protected Speculator createSpeculator(Configuration conf, final AppContext context) {
        return this.callWithJobClassLoader(conf, new Action<Speculator>(){

            @Override
            public Speculator call(Configuration conf) {
                try {
                    Class speculatorClass = conf.getClass("yarn.app.mapreduce.am.job.speculator.class", DefaultSpeculator.class, Speculator.class);
                    Constructor speculatorConstructor = speculatorClass.getConstructor(Configuration.class, AppContext.class);
                    Speculator result = (Speculator)speculatorConstructor.newInstance(conf, context);
                    return result;
                }
                catch (InstantiationException ex) {
                    LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
                    throw new YarnRuntimeException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
                    throw new YarnRuntimeException((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
                    throw new YarnRuntimeException((Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
                    throw new YarnRuntimeException((Throwable)ex);
                }
            }
        });
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context) {
        TaskAttemptListenerImpl lis = new TaskAttemptListenerImpl(context, this.jobTokenSecretManager, this.getRMHeartbeatHandler());
        return lis;
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        return new CommitterEventHandler(context, committer, this.getRMHeartbeatHandler(), this.jobClassLoader);
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return new ContainerAllocatorRouter(clientService, context);
    }

    protected RMHeartbeatHandler getRMHeartbeatHandler() {
        return (RMHeartbeatHandler)((Object)this.containerAllocator);
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new ContainerLauncherRouter(context);
    }

    protected ClientService createClientService(AppContext context) {
        return new MRClientService(context);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public OutputCommitter getCommitter() {
        return this.committer;
    }

    public boolean isNewApiCommitter() {
        return this.newApiCommitter;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Map<TaskId, JobHistoryParser.TaskInfo> getCompletedTaskFromPreviousRun() {
        return this.completedTasksFromPreviousRun;
    }

    public List<AMInfo> getAllAMInfos() {
        return this.amInfos;
    }

    public ContainerAllocator getContainerAllocator() {
        return this.containerAllocator;
    }

    public ContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public TaskAttemptListener getTaskAttemptListener() {
        return this.taskAttemptListener;
    }

    public Boolean isLastAMRetry() {
        return this.isLastAMRetry;
    }

    protected void serviceStart() throws Exception {
        this.amInfos = new LinkedList<AMInfo>();
        this.completedTasksFromPreviousRun = new HashMap<TaskId, JobHistoryParser.TaskInfo>();
        this.processRecovery();
        AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)this.appAttemptID, (long)this.startTime, (ContainerId)this.containerID, (String)this.nmHost, (int)this.nmPort, (int)this.nmHttpPort);
        this.job = this.createJob(this.getConfig(), this.forcedState, this.shutDownMessage);
        for (AMInfo info : this.amInfos) {
            this.dispatcher.getEventHandler().handle((Event)new JobHistoryEvent(this.job.getID(), (HistoryEvent)new AMStartedEvent(info.getAppAttemptId(), info.getStartTime(), info.getContainerId(), info.getNodeManagerHost(), info.getNodeManagerPort(), info.getNodeManagerHttpPort())));
        }
        this.dispatcher.getEventHandler().handle((Event)new JobHistoryEvent(this.job.getID(), (HistoryEvent)new AMStartedEvent(amInfo.getAppAttemptId(), amInfo.getStartTime(), amInfo.getContainerId(), amInfo.getNodeManagerHost(), amInfo.getNodeManagerPort(), amInfo.getNodeManagerHttpPort(), this.forcedState == null ? null : this.forcedState.toString())));
        this.amInfos.add(amInfo);
        DefaultMetricsSystem.initialize((String)"MRAppMaster");
        boolean initFailed = false;
        if (!this.errorHappenedShutDown) {
            JobEvent initJobEvent = new JobEvent(this.job.getID(), JobEventType.JOB_INIT);
            this.jobEventDispatcher.handle(initJobEvent);
            boolean bl = initFailed = ((JobImpl)this.job).getInternalState() != JobStateInternal.INITED;
            if (this.job.isUber()) {
                this.speculatorEventDispatcher.disableSpeculation();
                LOG.info((Object)("MRAppMaster uberizing job " + this.job.getID() + " in local container (\"uber-AM\") on node " + this.nmHost + ":" + this.nmPort + "."));
            } else {
                this.dispatcher.getEventHandler().handle((Event)new SpeculatorEvent(this.job.getID(), this.clock.getTime()));
                LOG.info((Object)("MRAppMaster launching normal, non-uberized, multi-container job " + this.job.getID() + "."));
            }
            this.clientService.start();
        }
        super.serviceStart();
        MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)this.getConfig());
        if (initFailed) {
            JobEvent initFailedEvent = new JobEvent(this.job.getID(), JobEventType.JOB_INIT_FAILED);
            this.jobEventDispatcher.handle(initFailedEvent);
        } else {
            this.startJobs();
        }
    }

    public void stop() {
        super.stop();
        TaskLog.syncLogsShutdown((ScheduledExecutorService)this.logSyncer);
    }

    private boolean isRecoverySupported() throws IOException {
        boolean isSupported = false;
        Configuration conf = this.getConfig();
        if (this.committer != null) {
            final JobContext _jobContext = this.getJobContextFromConf(conf);
            isSupported = this.callWithJobClassLoader(conf, new ExceptionAction<Boolean>(){

                @Override
                public Boolean call(Configuration conf) throws IOException {
                    return MRAppMaster.this.committer.isRecoverySupported(_jobContext);
                }
            });
        }
        return isSupported;
    }

    private void processRecovery() throws IOException {
        boolean shuffleKeyValidForRecovery;
        if (this.appAttemptID.getAttemptId() == 1) {
            return;
        }
        boolean recoveryEnabled = this.getConfig().getBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        boolean recoverySupportedByCommitter = this.isRecoverySupported();
        int numReduceTasks = this.getConfig().getInt("mapreduce.job.reduces", 0);
        boolean bl = shuffleKeyValidForRecovery = TokenCache.getShuffleSecretKey((Credentials)this.jobCredentials) != null;
        if (recoveryEnabled && recoverySupportedByCommitter && (numReduceTasks <= 0 || shuffleKeyValidForRecovery)) {
            LOG.info((Object)"Recovery is enabled. Will try to recover from previous life on best effort basis.");
            try {
                this.parsePreviousJobHistory();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to parse prior job history, aborting recovery", (Throwable)e);
                this.amInfos.addAll(this.readJustAMInfos());
            }
        } else {
            LOG.info((Object)("Will not try to recover. recoveryEnabled: " + recoveryEnabled + " recoverySupportedByCommitter: " + recoverySupportedByCommitter + " numReduceTasks: " + numReduceTasks + " shuffleKeyValidForRecovery: " + shuffleKeyValidForRecovery + " ApplicationAttemptID: " + this.appAttemptID.getAttemptId()));
            this.amInfos.addAll(this.readJustAMInfos());
        }
    }

    private static FSDataInputStream getPreviousJobHistoryStream(Configuration conf, ApplicationAttemptId appAttemptId) throws IOException {
        Path historyFile = JobHistoryUtils.getPreviousJobHistoryPath((Configuration)conf, (ApplicationAttemptId)appAttemptId);
        LOG.info((Object)("Previous history file is at " + historyFile));
        return historyFile.getFileSystem(conf).open(historyFile);
    }

    private void parsePreviousJobHistory() throws IOException {
        FSDataInputStream in = MRAppMaster.getPreviousJobHistoryStream(this.getConfig(), this.appAttemptID);
        JobHistoryParser parser = new JobHistoryParser(in);
        JobHistoryParser.JobInfo jobInfo = parser.parse();
        IOException parseException = parser.getParseException();
        if (parseException != null) {
            LOG.info((Object)"Got an error parsing job-history file, ignoring incomplete events.", (Throwable)parseException);
        }
        Map taskInfos = jobInfo.getAllTasks();
        for (JobHistoryParser.TaskInfo taskInfo : taskInfos.values()) {
            if (!TaskState.SUCCEEDED.toString().equals(taskInfo.getTaskStatus())) continue;
            Iterator taskAttemptIterator = taskInfo.getAllTaskAttempts().entrySet().iterator();
            while (taskAttemptIterator.hasNext()) {
                Map.Entry currentEntry = taskAttemptIterator.next();
                if (jobInfo.getAllCompletedTaskAttempts().containsKey(currentEntry.getKey())) continue;
                taskAttemptIterator.remove();
            }
            this.completedTasksFromPreviousRun.put(TypeConverter.toYarn((TaskID)taskInfo.getTaskId()), taskInfo);
            LOG.info((Object)("Read from history task " + TypeConverter.toYarn((TaskID)taskInfo.getTaskId())));
        }
        LOG.info((Object)("Read completed tasks from history " + this.completedTasksFromPreviousRun.size()));
        this.recoveredJobStartTime = jobInfo.getLaunchTime();
        List jhAmInfoList = jobInfo.getAMInfos();
        if (jhAmInfoList != null) {
            for (JobHistoryParser.AMInfo jhAmInfo : jhAmInfoList) {
                AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)jhAmInfo.getAppAttemptId(), (long)jhAmInfo.getStartTime(), (ContainerId)jhAmInfo.getContainerId(), (String)jhAmInfo.getNodeManagerHost(), (int)jhAmInfo.getNodeManagerPort(), (int)jhAmInfo.getNodeManagerHttpPort());
                this.amInfos.add(amInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AMInfo> readJustAMInfos() {
        ArrayList<AMInfo> amInfos = new ArrayList<AMInfo>();
        FSDataInputStream inputStream = null;
        try {
            HistoryEvent event;
            inputStream = MRAppMaster.getPreviousJobHistoryStream(this.getConfig(), this.appAttemptID);
            EventReader jobHistoryEventReader = new EventReader((DataInputStream)inputStream);
            boolean amStartedEventsBegan = false;
            while ((event = jobHistoryEventReader.getNextEvent()) != null) {
                if (event.getEventType() == EventType.AM_STARTED) {
                    if (!amStartedEventsBegan) {
                        amStartedEventsBegan = true;
                    }
                    AMStartedEvent amStartedEvent = (AMStartedEvent)event;
                    amInfos.add(MRBuilderUtils.newAMInfo((ApplicationAttemptId)amStartedEvent.getAppAttemptId(), (long)amStartedEvent.getStartTime(), (ContainerId)amStartedEvent.getContainerId(), (String)StringInterner.weakIntern((String)amStartedEvent.getNodeManagerHost()), (int)amStartedEvent.getNodeManagerPort(), (int)amStartedEvent.getNodeManagerHttpPort()));
                    continue;
                }
                if (!amStartedEventsBegan) continue;
                break;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not parse the old history file. Will not have old AMinfos ", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return amInfos;
    }

    protected void startJobs() {
        JobStartEvent startJobEvent = new JobStartEvent(this.job.getID(), this.recoveredJobStartTime);
        this.dispatcher.getEventHandler().handle((Event)startJobEvent);
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public static void main(String[] args) {
        try {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            MRAppMaster.validateInputParam(containerIdStr, ApplicationConstants.Environment.CONTAINER_ID.name());
            MRAppMaster.validateInputParam(nodeHostString, ApplicationConstants.Environment.NM_HOST.name());
            MRAppMaster.validateInputParam(nodePortString, ApplicationConstants.Environment.NM_PORT.name());
            MRAppMaster.validateInputParam(nodeHttpPortString, ApplicationConstants.Environment.NM_HTTP_PORT.name());
            MRAppMaster.validateInputParam(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            MRAppMaster appMaster = new MRAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime);
            ShutdownHookManager.get().addShutdownHook((Runnable)new MRAppMasterShutdownHook(appMaster), 30);
            JobConf conf = new JobConf((Configuration)new YarnConfiguration());
            conf.addResource(new Path("job.xml"));
            MRWebAppUtil.initialize((Configuration)conf);
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            conf.set("mapreduce.job.user.name", jobUserName);
            MRAppMaster.initAndStartAppMaster(appMaster, conf, jobUserName);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting MRAppMaster", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    public void notifyIsLastAMRetry(boolean isLastAMRetry) {
        if (this.containerAllocator instanceof ContainerAllocatorRouter) {
            LOG.info((Object)("Notify RMCommunicator isAMLastRetry: " + isLastAMRetry));
            ((ContainerAllocatorRouter)this.containerAllocator).setShouldUnregister(isLastAMRetry);
        }
        if (this.jobHistoryEventHandler != null) {
            LOG.info((Object)("Notify JHEH isAMLastRetry: " + isLastAMRetry));
            this.jobHistoryEventHandler.setForcejobCompletion(isLastAMRetry);
        }
    }

    protected static void initAndStartAppMaster(final MRAppMaster appMaster, final JobConf conf, String jobUserName) throws IOException, InterruptedException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        LOG.info((Object)"Executing with tokens:");
        for (Token token : credentials.getAllTokens()) {
            LOG.info((Object)token);
        }
        UserGroupInformation appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        appMasterUgi.addCredentials(credentials);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        conf.getCredentials().addAll(credentials);
        appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                appMaster.init((Configuration)conf);
                appMaster.start();
                if (appMaster.errorHappenedShutDown) {
                    throw new IOException("Was asked to shut down.");
                }
                return null;
            }
        });
    }

    private void createJobClassLoader(Configuration conf) throws IOException {
        this.jobClassLoader = MRApps.createJobClassLoader((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callWithJobClassLoader(Configuration conf, Action<T> action) {
        boolean setJobClassLoader;
        ClassLoader currentClassLoader = conf.getClassLoader();
        boolean bl = setJobClassLoader = this.jobClassLoader != null && currentClassLoader != this.jobClassLoader;
        if (setJobClassLoader) {
            MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)conf);
        }
        try {
            T t = action.call(conf);
            return t;
        }
        finally {
            if (setJobClassLoader) {
                MRApps.setClassLoader((ClassLoader)currentClassLoader, (Configuration)conf);
            }
        }
    }

    <T> T callWithJobClassLoader(Configuration conf, ExceptionAction<T> action) throws IOException {
        boolean setJobClassLoader;
        ClassLoader currentClassLoader = conf.getClassLoader();
        boolean bl = setJobClassLoader = this.jobClassLoader != null && currentClassLoader != this.jobClassLoader;
        if (setJobClassLoader) {
            MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)conf);
        }
        try {
            T t = action.call(conf);
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (YarnRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        finally {
            if (setJobClassLoader) {
                MRApps.setClassLoader((ClassLoader)currentClassLoader, (Configuration)conf);
            }
        }
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        LogManager.shutdown();
    }

    public ClientService getClientService() {
        return this.clientService;
    }

    private static interface ExceptionAction<T> {
        public T call(Configuration var1) throws Exception;
    }

    private static interface Action<T> {
        public T call(Configuration var1);
    }

    static class MRAppMasterShutdownHook
    implements Runnable {
        MRAppMaster appMaster;

        MRAppMasterShutdownHook(MRAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        @Override
        public void run() {
            LOG.info((Object)"MRAppMaster received a signal. Signaling RMCommunicator and JobHistoryEventHandler.");
            if (this.appMaster.containerAllocator instanceof ContainerAllocatorRouter) {
                ((ContainerAllocatorRouter)this.appMaster.containerAllocator).setSignalled(true);
            }
            this.appMaster.notifyIsLastAMRetry(this.appMaster.isLastAMRetry);
            this.appMaster.stop();
        }
    }

    private static class NoopEventHandler
    implements EventHandler<Event> {
        private NoopEventHandler() {
        }

        public void handle(Event event) {
        }
    }

    private class SpeculatorEventDispatcher
    implements EventHandler<SpeculatorEvent> {
        private final Configuration conf;
        private volatile boolean disabled;

        public SpeculatorEventDispatcher(Configuration config) {
            this.conf = config;
        }

        public void handle(final SpeculatorEvent event) {
            if (this.disabled) {
                return;
            }
            TaskId tId = event.getTaskID();
            TaskType tType = null;
            if (tId != null) {
                tType = tId.getTaskType();
            }
            boolean shouldMapSpec = this.conf.getBoolean("mapreduce.map.speculative", false);
            boolean shouldReduceSpec = this.conf.getBoolean("mapreduce.reduce.speculative", false);
            if (shouldMapSpec && (tType == null || tType == TaskType.MAP) || shouldReduceSpec && (tType == null || tType == TaskType.REDUCE)) {
                MRAppMaster.this.callWithJobClassLoader(this.conf, new Action<Void>(){

                    @Override
                    public Void call(Configuration conf) {
                        MRAppMaster.this.speculator.handle((Event)event);
                        return null;
                    }
                });
            }
        }

        public void disableSpeculation() {
            this.disabled = true;
        }
    }

    private class TaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private TaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            Job job = MRAppMaster.this.context.getJob(event.getTaskAttemptID().getTaskId().getJobId());
            Task task = job.getTask(event.getTaskAttemptID().getTaskId());
            TaskAttempt attempt = task.getAttempt(event.getTaskAttemptID());
            ((EventHandler)attempt).handle((Event)event);
        }
    }

    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            Task task = MRAppMaster.this.context.getJob(event.getTaskID().getJobId()).getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    private class JobEventDispatcher
    implements EventHandler<JobEvent> {
        private JobEventDispatcher() {
        }

        public void handle(JobEvent event) {
            ((EventHandler)MRAppMaster.this.context.getJob(event.getJobId())).handle((Event)event);
        }
    }

    public class RunningAppContext
    implements AppContext {
        private final Map<JobId, Job> jobs = new ConcurrentHashMap<JobId, Job>();
        private final Configuration conf;
        private final ClusterInfo clusterInfo = new ClusterInfo();
        private final ClientToAMTokenSecretManager clientToAMTokenSecretManager;

        public RunningAppContext(Configuration config) {
            this.conf = config;
            this.clientToAMTokenSecretManager = new ClientToAMTokenSecretManager(MRAppMaster.this.appAttemptID, null);
        }

        @Override
        public ApplicationAttemptId getApplicationAttemptId() {
            return MRAppMaster.this.appAttemptID;
        }

        @Override
        public ApplicationId getApplicationID() {
            return MRAppMaster.this.appAttemptID.getApplicationId();
        }

        @Override
        public String getApplicationName() {
            return MRAppMaster.this.appName;
        }

        @Override
        public long getStartTime() {
            return MRAppMaster.this.startTime;
        }

        @Override
        public Job getJob(JobId jobID) {
            return this.jobs.get(jobID);
        }

        @Override
        public Map<JobId, Job> getAllJobs() {
            return this.jobs;
        }

        @Override
        public EventHandler getEventHandler() {
            return MRAppMaster.this.dispatcher.getEventHandler();
        }

        @Override
        public CharSequence getUser() {
            return this.conf.get("mapreduce.job.user.name");
        }

        @Override
        public Clock getClock() {
            return MRAppMaster.this.clock;
        }

        @Override
        public ClusterInfo getClusterInfo() {
            return this.clusterInfo;
        }

        @Override
        public Set<String> getBlacklistedNodes() {
            return ((RMContainerRequestor)((Object)MRAppMaster.this.containerAllocator)).getBlacklistedNodes();
        }

        @Override
        public ClientToAMTokenSecretManager getClientToAMTokenSecretManager() {
            return this.clientToAMTokenSecretManager;
        }

        @Override
        public boolean isLastAMRetry() {
            return MRAppMaster.this.isLastAMRetry;
        }

        @Override
        public boolean hasSuccessfullyUnregistered() {
            return MRAppMaster.this.successfullyUnregistered.get();
        }

        public void markSuccessfulUnregistration() {
            MRAppMaster.this.successfullyUnregistered.set(true);
        }

        public void resetIsLastAMRetry() {
            MRAppMaster.this.isLastAMRetry = false;
        }

        @Override
        public String getNMHostname() {
            return MRAppMaster.this.nmHost;
        }
    }

    private final class StagingDirCleaningService
    extends AbstractService {
        StagingDirCleaningService() {
            super(StagingDirCleaningService.class.getName());
        }

        protected void serviceStop() throws Exception {
            try {
                if (MRAppMaster.this.isLastAMRetry) {
                    MRAppMaster.this.cleanupStagingDir();
                } else {
                    LOG.info((Object)"Skipping cleaning up the staging dir. assuming AM will be retried.");
                }
            }
            catch (IOException io) {
                LOG.error((Object)"Failed to cleanup staging dir: ", (Throwable)io);
            }
            super.serviceStop();
        }
    }

    private final class ContainerLauncherRouter
    extends AbstractService
    implements ContainerLauncher {
        private final AppContext context;
        private ContainerLauncher containerLauncher;

        ContainerLauncherRouter(AppContext context) {
            super(ContainerLauncherRouter.class.getName());
            this.context = context;
        }

        protected void serviceStart() throws Exception {
            this.containerLauncher = MRAppMaster.this.job.isUber() ? new LocalContainerLauncher(this.context, (TaskUmbilicalProtocol)MRAppMaster.this.taskAttemptListener) : new ContainerLauncherImpl(this.context);
            ((Service)this.containerLauncher).init(this.getConfig());
            ((Service)this.containerLauncher).start();
            super.serviceStart();
        }

        public void handle(ContainerLauncherEvent event) {
            this.containerLauncher.handle((Event)event);
        }

        protected void serviceStop() throws Exception {
            ServiceOperations.stop((Service)((Service)this.containerLauncher));
            super.serviceStop();
        }
    }

    private final class ContainerAllocatorRouter
    extends AbstractService
    implements ContainerAllocator,
    RMHeartbeatHandler {
        private final ClientService clientService;
        private final AppContext context;
        private ContainerAllocator containerAllocator;

        ContainerAllocatorRouter(ClientService clientService, AppContext context) {
            super(ContainerAllocatorRouter.class.getName());
            this.clientService = clientService;
            this.context = context;
        }

        protected void serviceStart() throws Exception {
            if (MRAppMaster.this.job.isUber()) {
                MRApps.setupDistributedCacheLocal((Configuration)this.getConfig());
                this.containerAllocator = new LocalContainerAllocator(this.clientService, this.context, MRAppMaster.this.nmHost, MRAppMaster.this.nmPort, MRAppMaster.this.nmHttpPort, MRAppMaster.this.containerID);
            } else {
                this.containerAllocator = new RMContainerAllocator(this.clientService, this.context);
            }
            ((Service)this.containerAllocator).init(this.getConfig());
            ((Service)this.containerAllocator).start();
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            ServiceOperations.stop((Service)((Service)this.containerAllocator));
            super.serviceStop();
        }

        public void handle(ContainerAllocatorEvent event) {
            this.containerAllocator.handle((Event)event);
        }

        public void setSignalled(boolean isSignalled) {
            ((RMCommunicator)((Object)this.containerAllocator)).setSignalled(isSignalled);
        }

        public void setShouldUnregister(boolean shouldUnregister) {
            ((RMCommunicator)((Object)this.containerAllocator)).setShouldUnregister(shouldUnregister);
        }

        @Override
        public long getLastHeartbeatTime() {
            return ((RMCommunicator)((Object)this.containerAllocator)).getLastHeartbeatTime();
        }

        @Override
        public void runOnNextHeartbeat(Runnable callback) {
            ((RMCommunicator)((Object)this.containerAllocator)).runOnNextHeartbeat(callback);
        }
    }

    private class JobFinishEventHandler
    implements EventHandler<JobFinishEvent> {
        private JobFinishEventHandler() {
        }

        public void handle(JobFinishEvent event) {
            new Thread(){

                @Override
                public void run() {
                    MRAppMaster.this.shutDownJob();
                    System.exit(0);
                }
            }.start();
        }
    }
}

