/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.exceptions.StreamInUseException;
import org.ojai.json.Events;
import org.ojai.json.impl.JsonDocumentIterator;
import org.ojai.json.impl.JsonDocumentReaderIterable;

@API.Internal
public class JsonDocumentStream
implements DocumentStream {
    private final InputStream inputStream;
    private JsonParser jsonParser;
    private final boolean readStarted;
    private volatile boolean iteratorOpened;
    private final Map<FieldPath, Value.Type> fieldPathTypeMap;
    private final Events.Delegate eventDelegate;

    static DocumentStream newDocumentStream(FileSystem fs, Path path, Map<FieldPath, Value.Type> map, Events.Delegate delegate) throws IllegalArgumentException, IOException {
        FSDataInputStream in = fs.open(path);
        return new JsonDocumentStream((InputStream)in, map, delegate, (InputStream)in){
            final /* synthetic */ InputStream val$in;
            {
                this.val$in = inputStream;
                super(in, fieldPathTypeMap, eventDelegate);
            }

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    try {
                        this.val$in.close();
                    }
                    catch (IOException e) {
                        throw new OjaiException(e);
                    }
                }
            }
        };
    }

    public static DocumentStream newDocumentStream(FileSystem fs, String path, Map<FieldPath, Value.Type> map, Events.Delegate delegate) throws IllegalArgumentException, IOException {
        return JsonDocumentStream.newDocumentStream(fs, new Path(path), map, delegate);
    }

    public JsonDocumentStream(InputStream in, Map<FieldPath, Value.Type> fieldPathTypeMap, Events.Delegate eventDelegate) {
        this.inputStream = in;
        this.readStarted = false;
        this.iteratorOpened = false;
        this.eventDelegate = eventDelegate;
        this.fieldPathTypeMap = fieldPathTypeMap;
        try {
            JsonFactory jFactory = new JsonFactory();
            jFactory.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
            this.jsonParser = jFactory.createParser(this.inputStream);
        }
        catch (IOException e) {
            throw new DecodingException(e);
        }
    }

    public long getInputStreamPosition() {
        return this.jsonParser.getTokenLocation().getByteOffset();
    }

    @Override
    public Iterable<DocumentReader> documentReaders() {
        this.checkStateForIteration();
        this.iteratorOpened = true;
        return new JsonDocumentReaderIterable(this);
    }

    @Override
    public synchronized Iterator<Document> iterator() {
        this.checkStateForIteration();
        return new JsonDocumentIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamTo(DocumentListener listener) {
        Exception failure = null;
        try {
            for (Document doc : this) {
                if (listener.documentArrived(doc)) continue;
                break;
            }
        }
        catch (Exception e) {
            failure = e;
        }
        finally {
            block15: {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (failure != null) break block15;
                    failure = e;
                }
            }
        }
        if (failure == null) {
            listener.eos();
        } else {
            listener.failed(failure);
        }
    }

    @Override
    public void close() {
        try {
            this.jsonParser.close();
        }
        catch (IOException e) {
            throw new OjaiException(e);
        }
    }

    JsonParser getParser() {
        return this.jsonParser;
    }

    Map<FieldPath, Value.Type> getFieldPathTypeMap() {
        return this.fieldPathTypeMap;
    }

    Events.Delegate getEventDelegate() {
        return this.eventDelegate;
    }

    private void checkStateForIteration() {
        if (this.readStarted) {
            throw new StreamInUseException("Can not create iterator after reading from the stream has started.");
        }
        if (this.iteratorOpened) {
            throw new StreamInUseException("An iterator has already been opened on this document stream.");
        }
    }
}

