/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.kerby.util.Utf8;

public final class IOUtil {
    private IOUtil() {
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        in.close();
        return baos.toByteArray();
    }

    public static void readInputStream(InputStream in, byte[] buf) throws IOException {
        int toRead = buf.length;
        int off = 0;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Bad inputStream, premature EOF");
            }
            toRead -= ret;
            off += ret;
        }
        in.close();
    }

    public static String readInput(InputStream in) throws IOException {
        byte[] content = IOUtil.readInputStream(in);
        return Utf8.toString(content);
    }

    public static String readFile(File file) throws IOException {
        long len = 0L;
        if (file.length() >= Integer.MAX_VALUE) {
            throw new IOException("Too large file, unexpected!");
        }
        len = file.length();
        byte[] buf = new byte[(int)len];
        FileInputStream is = new FileInputStream(file);
        IOUtil.readInputStream(is, buf);
        return Utf8.toString(buf);
    }

    public static void writeFile(String content, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        FileChannel fc = outputStream.getChannel();
        ByteBuffer buffer = ByteBuffer.wrap(Utf8.toBytes(content));
        fc.write(buffer);
        outputStream.close();
    }
}

