/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.eventsource;

import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.eventsource.TransferSizeInfo;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventWrapper<T extends Serializable>
implements Serializable {
    private EventIdentifier eventIdentifier;
    private T event;
    private transient TransferSizeInfo transferSizeInfo;
    private static final long serialVersionUID = 6302031645772429174L;

    public EventWrapper() {
        this(null, -1L, null);
    }

    public EventWrapper(SourceIdentifier sourceIdentifier, long localId, T event) {
        this(new EventIdentifier(sourceIdentifier, localId), event);
    }

    public EventWrapper(EventIdentifier eventIdentifier, T event) {
        this.eventIdentifier = eventIdentifier;
        this.event = event;
    }

    public SourceIdentifier getSourceIdentifier() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.getSourceIdentifier();
        }
        return null;
    }

    public void setSourceIdentifier(SourceIdentifier sourceIdentifier) {
        if (this.eventIdentifier == null) {
            this.eventIdentifier = new EventIdentifier();
        }
        this.eventIdentifier.setSourceIdentifier(sourceIdentifier);
    }

    public long getLocalId() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.getLocalId();
        }
        return -1L;
    }

    public void setLocalId(long localId) {
        if (this.eventIdentifier == null) {
            this.eventIdentifier = new EventIdentifier();
        }
        this.eventIdentifier.setLocalId(localId);
    }

    public EventIdentifier getEventIdentifier() {
        return this.eventIdentifier;
    }

    public void setEventIdentifier(EventIdentifier eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
    }

    public TransferSizeInfo getTransferSizeInfo() {
        return this.transferSizeInfo;
    }

    public void setTransferSizeInfo(TransferSizeInfo transferSizeInfo) {
        this.transferSizeInfo = transferSizeInfo;
    }

    public T getEvent() {
        return this.event;
    }

    public void setEvent(T event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventWrapper that = (EventWrapper)o;
        if (this.eventIdentifier != null ? !this.eventIdentifier.equals(that.eventIdentifier) : that.eventIdentifier != null) {
            return false;
        }
        return !(this.event != null ? !this.event.equals(that.event) : that.event != null);
    }

    public int hashCode() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.hashCode();
        }
        return this.event != null ? this.event.hashCode() : 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("eventWrapper[");
        result.append("eventIdentifier=").append(this.eventIdentifier);
        result.append(", event=").append(this.event);
        result.append("]");
        return result.toString();
    }
}

