/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;

public abstract class SimpleDissector
extends Dissector {
    String inputType;
    private HashMap<String, EnumSet<Casts>> outputTypes;
    private HashMap<String, EnumSet<Casts>> outputCasts;

    public SimpleDissector(String inputType, Map<String, EnumSet<Casts>> outputTypes) {
        this.inputType = inputType;
        this.outputTypes = new HashMap<String, EnumSet<Casts>>(outputTypes);
        this.outputCasts = new HashMap(outputTypes.size());
        for (Map.Entry<String, EnumSet<Casts>> type : outputTypes.entrySet()) {
            this.outputCasts.put(type.getKey().split(":", 2)[1], type.getValue());
        }
    }

    @Override
    public String getInputType() {
        return this.inputType;
    }

    @Override
    public void setInputType(String nInputType) {
        this.inputType = nInputType;
    }

    @Override
    public List<String> getPossibleOutput() {
        return new ArrayList<String>(this.outputTypes.keySet());
    }

    @Override
    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = this.extractFieldName(inputname, outputname);
        return this.outputCasts.getOrDefault(name, Casts.NO_CASTS);
    }

    @Override
    protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
        if (newInstance instanceof SimpleDissector) {
            SimpleDissector dissector = (SimpleDissector)newInstance;
            dissector.inputType = this.inputType;
            dissector.outputTypes = this.outputTypes;
            dissector.outputCasts = this.outputCasts;
        }
    }

    @Override
    public final void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(this.getInputType(), inputname);
        Value value = field.getValue();
        if (value == null) {
            return;
        }
        this.dissect(parsable, inputname, value);
    }

    public abstract void dissect(Parsable<?> var1, String var2, Value var3) throws DissectionFailure;
}

