/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.openTSDB.OpenTSDBScanSpec;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePlugin;
import org.apache.drill.exec.store.openTSDB.client.OpenTSDBTypes;
import org.apache.drill.exec.store.openTSDB.client.Schema;
import org.apache.drill.exec.store.openTSDB.dto.ColumnDTO;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillOpenTSDBTable
extends DynamicDrillTable {
    private static final Logger log = LoggerFactory.getLogger(DrillOpenTSDBTable.class);
    private final Schema schema;

    public DrillOpenTSDBTable(String storageEngineName, OpenTSDBStoragePlugin plugin, Schema schema, OpenTSDBScanSpec scanSpec) {
        super((StoragePlugin)plugin, storageEngineName, (Object)scanSpec);
        this.schema = schema;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList names = Lists.newArrayList();
        ArrayList types = Lists.newArrayList();
        this.convertToRelDataType(typeFactory, names, types);
        return typeFactory.createStructType((List)types, (List)names);
    }

    private void convertToRelDataType(RelDataTypeFactory typeFactory, List<String> names, List<RelDataType> types) {
        for (ColumnDTO column : this.schema.getColumns()) {
            names.add(column.getColumnName());
            RelDataType type = this.getSqlTypeFromOpenTSDBType(typeFactory, column.getColumnType());
            type = typeFactory.createTypeWithNullability(type, column.isNullable());
            types.add(type);
        }
    }

    private RelDataType getSqlTypeFromOpenTSDBType(RelDataTypeFactory typeFactory, OpenTSDBTypes type) {
        switch (type) {
            case STRING: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        }
        throw UserException.unsupportedError().message(String.format("%s is unsupported now. Currently supported types is %s, %s, %s", new Object[]{type, OpenTSDBTypes.STRING, OpenTSDBTypes.DOUBLE, OpenTSDBTypes.TIMESTAMP}), new Object[0]).build(log);
    }
}

