/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.jsyslog.message;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Severity {
    EMERG,
    ALERT,
    CRIT,
    ERR,
    WARNING,
    NOTICE,
    INFO,
    DEBUG;


    @Nullable
    public static String getName(int facility) {
        Severity[] values = Severity.values();
        if (0 > facility || facility >= values.length) {
            return null;
        }
        return values[facility].name();
    }

    public static Integer getSeverity(@Nonnull String name) {
        for (Severity facility : Severity.values()) {
            if (!facility.name().equalsIgnoreCase(name)) continue;
            return facility.ordinal();
        }
        return null;
    }
}

