/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ColumnChunkPageReadStore;
import org.apache.parquet.hadoop.DictionaryPageReader;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileReader.class);
    public static String PARQUET_READ_PARALLELISM = "parquet.metadata.read.parallelism";
    private final ParquetMetadataConverter converter;
    private final InputFile file;
    private final SeekableInputStream f;
    private final ParquetReadOptions options;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;
    private ParquetMetadata footer;
    private int currentBlock = 0;
    private ColumnChunkPageReadStore currentRowGroup = null;
    private DictionaryPageReader nextDictionaryReader = null;

    @Deprecated
    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, partFiles, false);
    }

    private static ParquetMetadataConverter.MetadataFilter filter(boolean skipRowGroups) {
        return skipRowGroups ? ParquetMetadataConverter.SKIP_ROW_GROUPS : ParquetMetadataConverter.NO_FILTER;
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(final Configuration configuration, final Collection<FileStatus> partFiles, final boolean skipRowGroups) throws IOException {
        HashSet<Path> parents = new HashSet<Path>();
        for (FileStatus fileStatus : partFiles) {
            parents.add(fileStatus.getPath().getParent());
        }
        ArrayList summaries = new ArrayList();
        for (final Path path : parents) {
            summaries.add(new Callable<Map<Path, Footer>>(){

                @Override
                public Map<Path, Footer> call() throws Exception {
                    ParquetMetadata mergedMetadata = ParquetFileReader.readSummaryMetadata(configuration, path, skipRowGroups);
                    if (mergedMetadata != null) {
                        List<Object> footers;
                        if (skipRowGroups) {
                            footers = new ArrayList();
                            for (FileStatus f : partFiles) {
                                footers.add(new Footer(f.getPath(), mergedMetadata));
                            }
                        } else {
                            footers = ParquetFileReader.footersFromSummaryFile(path, mergedMetadata);
                        }
                        HashMap<Path, Footer> map = new HashMap<Path, Footer>();
                        for (Footer footer : footers) {
                            Footer footer2 = new Footer(new Path(path, footer.getFile().getName()), footer.getParquetMetadata());
                            map.put(footer2.getFile(), footer2);
                        }
                        return map;
                    }
                    return Collections.emptyMap();
                }
            });
        }
        HashMap hashMap = new HashMap();
        try {
            List<Map> footersFromSummaries = ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), summaries);
            for (Map footers : footersFromSummaries) {
                hashMap.putAll(footers);
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error reading summaries", e);
        }
        ArrayList<Footer> result = new ArrayList<Footer>(partFiles.size());
        ArrayList<FileStatus> toRead = new ArrayList<FileStatus>();
        for (FileStatus part : partFiles) {
            Footer f = (Footer)hashMap.get(part.getPath());
            if (f != null) {
                result.add(f);
                continue;
            }
            toRead.add(part);
        }
        if (toRead.size() > 0) {
            LOG.info("reading another {} footers", (Object)toRead.size());
            result.addAll(ParquetFileReader.readAllFootersInParallel(configuration, toRead, skipRowGroups));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> runAllInParallel(int parallelism, List<Callable<T>> toRun) throws ExecutionException {
        LOG.info("Initiating action with parallelism: {}", (Object)parallelism);
        ExecutorService threadPool = Executors.newFixedThreadPool(parallelism);
        try {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
            for (Callable<T> callable : toRun) {
                futures.add(threadPool.submit(callable));
            }
            ArrayList result = new ArrayList(toRun.size());
            for (Future future : futures) {
                try {
                    result.add(future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("The thread was interrupted", e);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, partFiles, false);
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(final Configuration configuration, List<FileStatus> partFiles, final boolean skipRowGroups) throws IOException {
        ArrayList footers = new ArrayList();
        for (final FileStatus currentFile : partFiles) {
            footers.add(new Callable<Footer>(){

                @Override
                public Footer call() throws Exception {
                    try {
                        return new Footer(currentFile.getPath(), ParquetFileReader.readFooter(configuration, currentFile, ParquetFileReader.filter(skipRowGroups)));
                    }
                    catch (IOException e) {
                        throw new IOException("Could not read footer for file " + currentFile, e);
                    }
                }
            });
        }
        try {
            return ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), footers);
        }
        catch (ExecutionException e) {
            throw new IOException("Could not read footer: " + e.getMessage(), e.getCause());
        }
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> statuses = ParquetFileReader.listFiles(configuration, fileStatus);
        return ParquetFileReader.readAllFootersInParallel(configuration, statuses, skipRowGroups);
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, fileStatus, false);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, Path path) throws IOException {
        return ParquetFileReader.readFooters(configuration, ParquetFileReader.status(configuration, path));
    }

    private static FileStatus status(Configuration configuration, Path path) throws IOException {
        return path.getFileSystem(configuration).getFileStatus(path);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus) throws IOException {
        return ParquetFileReader.readFooters(configuration, pathStatus, false);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> files = ParquetFileReader.listFiles(configuration, pathStatus);
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, files, skipRowGroups);
    }

    private static List<FileStatus> listFiles(Configuration conf, FileStatus fileStatus) throws IOException {
        if (fileStatus.isDir()) {
            FileSystem fs = fileStatus.getPath().getFileSystem(conf);
            FileStatus[] list = fs.listStatus(fileStatus.getPath(), (PathFilter)HiddenFileFilter.INSTANCE);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            for (FileStatus sub : list) {
                result.addAll(ParquetFileReader.listFiles(conf, sub));
            }
            return result;
        }
        return Arrays.asList(fileStatus);
    }

    @Deprecated
    public static List<Footer> readSummaryFile(Configuration configuration, FileStatus summaryStatus) throws IOException {
        Path parent = summaryStatus.getPath().getParent();
        ParquetMetadata mergedFooters = ParquetFileReader.readFooter(configuration, summaryStatus, ParquetFileReader.filter(false));
        return ParquetFileReader.footersFromSummaryFile(parent, mergedFooters);
    }

    static ParquetMetadata readSummaryMetadata(Configuration configuration, Path basePath, boolean skipRowGroups) throws IOException {
        Path metadataFile = new Path(basePath, "_metadata");
        Path commonMetaDataFile = new Path(basePath, "_common_metadata");
        FileSystem fileSystem = basePath.getFileSystem(configuration);
        if (skipRowGroups && fileSystem.exists(commonMetaDataFile)) {
            LOG.info("reading summary file: {}", (Object)commonMetaDataFile);
            return ParquetFileReader.readFooter(configuration, commonMetaDataFile, ParquetFileReader.filter(skipRowGroups));
        }
        if (fileSystem.exists(metadataFile)) {
            LOG.info("reading summary file: {}", (Object)metadataFile);
            return ParquetFileReader.readFooter(configuration, metadataFile, ParquetFileReader.filter(skipRowGroups));
        }
        return null;
    }

    static List<Footer> footersFromSummaryFile(Path parent, ParquetMetadata mergedFooters) {
        HashMap<Path, ParquetMetadata> footers = new HashMap<Path, ParquetMetadata>();
        List<BlockMetaData> blocks = mergedFooters.getBlocks();
        for (BlockMetaData block : blocks) {
            String path = block.getPath();
            Path fullPath = new Path(parent, path);
            ParquetMetadata current = (ParquetMetadata)footers.get(fullPath);
            if (current == null) {
                current = new ParquetMetadata(mergedFooters.getFileMetaData(), new ArrayList<BlockMetaData>());
                footers.put(fullPath, current);
            }
            current.getBlocks().add(block);
        }
        ArrayList<Footer> result = new ArrayList<Footer>();
        for (Map.Entry entry : footers.entrySet()) {
            result.add(new Footer((Path)entry.getKey(), (ParquetMetadata)entry.getValue()));
        }
        return result;
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, Path file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    public static ParquetMetadata readFooter(Configuration configuration, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromPath(file, configuration), filter);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromStatus(file, configuration), filter);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(InputFile file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        ParquetReadOptions options = file instanceof HadoopInputFile ? HadoopReadOptions.builder(((HadoopInputFile)file).getConfiguration()).withMetadataFilter(filter).build() : ParquetReadOptions.builder().withMetadataFilter(filter).build();
        try (SeekableInputStream in = file.newStream();){
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter(file, options, in);
            return parquetMetadata;
        }
    }

    private static final ParquetMetadata readFooter(InputFile file, ParquetReadOptions options, SeekableInputStream f) throws IOException {
        ParquetMetadataConverter converter = new ParquetMetadataConverter(options);
        return ParquetFileReader.readFooter(file, options, f, converter);
    }

    private static final ParquetMetadata readFooter(InputFile file, ParquetReadOptions options, SeekableInputStream f, ParquetMetadataConverter converter) throws IOException {
        long fileLen = file.getLength();
        String filePath = file.toString();
        LOG.debug("File length {}", (Object)fileLen);
        int FOOTER_LENGTH_SIZE = 4;
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + FOOTER_LENGTH_SIZE + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException(filePath + " is not a Parquet file (too small length: " + fileLen + ")");
        }
        long footerLengthIndex = fileLen - (long)FOOTER_LENGTH_SIZE - (long)ParquetFileWriter.MAGIC.length;
        LOG.debug("reading footer index at {}", (Object)footerLengthIndex);
        f.seek(footerLengthIndex);
        int footerLength = BytesUtils.readIntLittleEndian((InputStream)f);
        byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
        f.readFully(magic);
        if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
            throw new RuntimeException(filePath + " is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
        }
        long footerIndex = footerLengthIndex - (long)footerLength;
        LOG.debug("read footer length: {}, footer index: {}", (Object)footerLength, (Object)footerIndex);
        if (footerIndex < (long)ParquetFileWriter.MAGIC.length || footerIndex >= footerLengthIndex) {
            throw new RuntimeException("corrupted file: the footer index is not within the file: " + footerIndex);
        }
        f.seek(footerIndex);
        return converter.readParquetMetadata((InputStream)f, options.getMetadataFilter());
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file) throws IOException {
        return new ParquetFileReader(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf).build());
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.open(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf).withMetadataFilter(filter).build());
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        return new ParquetFileReader(conf, file, footer);
    }

    public static ParquetFileReader open(InputFile file) throws IOException {
        return new ParquetFileReader(file, ParquetReadOptions.builder().build());
    }

    public static ParquetFileReader open(InputFile file, ParquetReadOptions options) throws IOException {
        return new ParquetFileReader(file, options);
    }

    @Deprecated
    public ParquetFileReader(Configuration configuration, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this(configuration, null, filePath, blocks, columns);
    }

    @Deprecated
    public ParquetFileReader(Configuration configuration, FileMetaData fileMetaData, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this.converter = new ParquetMetadataConverter(configuration);
        this.file = HadoopInputFile.fromPath(filePath, configuration);
        this.fileMetaData = fileMetaData;
        this.f = this.file.newStream();
        this.options = HadoopReadOptions.builder(configuration).build();
        this.blocks = this.filterRowGroups(blocks);
        for (ColumnDescriptor col : columns) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    @Deprecated
    public ParquetFileReader(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        this(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf).withMetadataFilter(filter).build());
    }

    @Deprecated
    public ParquetFileReader(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        this.converter = new ParquetMetadataConverter(conf);
        this.file = HadoopInputFile.fromPath(file, conf);
        this.f = this.file.newStream();
        this.options = HadoopReadOptions.builder(conf).build();
        this.footer = footer;
        this.fileMetaData = footer.getFileMetaData();
        this.blocks = this.filterRowGroups(footer.getBlocks());
        for (ColumnDescriptor col : footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    public ParquetFileReader(InputFile file, ParquetReadOptions options) throws IOException {
        this.converter = new ParquetMetadataConverter(options);
        this.file = file;
        this.f = file.newStream();
        this.options = options;
        this.footer = ParquetFileReader.readFooter(file, options, this.f, this.converter);
        this.fileMetaData = this.footer.getFileMetaData();
        this.blocks = this.filterRowGroups(this.footer.getBlocks());
        for (ColumnDescriptor col : this.footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    public ParquetMetadata getFooter() {
        if (this.footer == null) {
            try {
                this.footer = ParquetFileReader.readFooter(this.file, this.options, this.f, this.converter);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Unable to read file footer", (Throwable)e);
            }
        }
        return this.footer;
    }

    public FileMetaData getFileMetaData() {
        if (this.fileMetaData != null) {
            return this.fileMetaData;
        }
        return this.getFooter().getFileMetaData();
    }

    public long getRecordCount() {
        long total = 0L;
        for (BlockMetaData block : this.blocks) {
            total += block.getRowCount();
        }
        return total;
    }

    @Deprecated
    public Path getPath() {
        return new Path(this.file.toString());
    }

    public String getFile() {
        return this.file.toString();
    }

    private List<BlockMetaData> filterRowGroups(List<BlockMetaData> blocks) throws IOException {
        FilterCompat.Filter recordFilter;
        ArrayList<RowGroupFilter.FilterLevel> levels = new ArrayList<RowGroupFilter.FilterLevel>();
        if (this.options.useStatsFilter()) {
            levels.add(RowGroupFilter.FilterLevel.STATISTICS);
        }
        if (this.options.useDictionaryFilter()) {
            levels.add(RowGroupFilter.FilterLevel.DICTIONARY);
        }
        if ((recordFilter = this.options.getRecordFilter()) != null) {
            return RowGroupFilter.filterRowGroups(levels, recordFilter, blocks, this);
        }
        return blocks;
    }

    public List<BlockMetaData> getRowGroups() {
        return this.blocks;
    }

    public void setRequestedSchema(MessageType projection) {
        this.paths.clear();
        for (ColumnDescriptor col : projection.getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    public void appendTo(ParquetFileWriter writer) throws IOException {
        writer.appendRowGroups(this.f, this.blocks, true);
    }

    public PageReadStore readNextRowGroup() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        if (block.getRowCount() == 0L) {
            throw new RuntimeException("Illegal row group of 0 rows");
        }
        this.currentRowGroup = new ColumnChunkPageReadStore(block.getRowCount());
        ArrayList<ConsecutiveChunkList> allChunks = new ArrayList<ConsecutiveChunkList>();
        ConsecutiveChunkList currentChunks = null;
        for (ColumnChunkMetaData mc : block.getColumns()) {
            ColumnPath pathKey = mc.getPath();
            BenchmarkCounter.incrementTotalBytes(mc.getTotalSize());
            ColumnDescriptor columnDescriptor = this.paths.get(pathKey);
            if (columnDescriptor == null) continue;
            long startingPos = mc.getStartingPos();
            if (currentChunks == null || currentChunks.endPos() != startingPos) {
                currentChunks = new ConsecutiveChunkList(startingPos);
                allChunks.add(currentChunks);
            }
            currentChunks.addChunk(new ChunkDescriptor(columnDescriptor, mc, startingPos, (int)mc.getTotalSize()));
        }
        for (ConsecutiveChunkList consecutiveChunks : allChunks) {
            List<Chunk> chunks = consecutiveChunks.readAll(this.f);
            for (Chunk chunk : chunks) {
                this.currentRowGroup.addColumn(chunk.descriptor.col, chunk.readAllPages());
            }
        }
        if (this.nextDictionaryReader != null) {
            this.nextDictionaryReader.setRowGroup(this.currentRowGroup);
        }
        this.advanceToNextBlock();
        return this.currentRowGroup;
    }

    public boolean skipNextRowGroup() {
        return this.advanceToNextBlock();
    }

    private boolean advanceToNextBlock() {
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        ++this.currentBlock;
        this.nextDictionaryReader = null;
        return true;
    }

    public DictionaryPageReadStore getNextDictionaryReader() {
        if (this.nextDictionaryReader == null && this.currentBlock < this.blocks.size()) {
            this.nextDictionaryReader = this.getDictionaryReader(this.blocks.get(this.currentBlock));
        }
        return this.nextDictionaryReader;
    }

    public DictionaryPageReader getDictionaryReader(BlockMetaData block) {
        return new DictionaryPageReader(this, block);
    }

    DictionaryPage readDictionary(ColumnChunkMetaData meta) throws IOException {
        PageHeader pageHeader;
        if (!meta.getEncodings().contains(Encoding.PLAIN_DICTIONARY) && !meta.getEncodings().contains(Encoding.RLE_DICTIONARY)) {
            return null;
        }
        if (this.f.getPos() != meta.getStartingPos()) {
            this.f.seek(meta.getStartingPos());
        }
        if (!(pageHeader = Util.readPageHeader((InputStream)this.f)).isSetDictionary_page_header()) {
            return null;
        }
        DictionaryPage compressedPage = this.readCompressedDictionary(pageHeader, this.f);
        CompressionCodecFactory.BytesInputDecompressor decompressor = this.options.getCodecFactory().getDecompressor(meta.getCodec());
        return new DictionaryPage(decompressor.decompress(compressedPage.getBytes(), compressedPage.getUncompressedSize()), compressedPage.getDictionarySize(), compressedPage.getEncoding());
    }

    private DictionaryPage readCompressedDictionary(PageHeader pageHeader, SeekableInputStream fin) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        int uncompressedPageSize = pageHeader.getUncompressed_page_size();
        int compressedPageSize = pageHeader.getCompressed_page_size();
        byte[] dictPageBytes = new byte[compressedPageSize];
        fin.readFully(dictPageBytes);
        BytesInput bin = BytesInput.from((byte[])dictPageBytes);
        return new DictionaryPage(bin, uncompressedPageSize, dictHeader.getNum_values(), this.converter.getEncoding(dictHeader.getEncoding()));
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        finally {
            this.options.getCodecFactory().release();
        }
    }

    private class ConsecutiveChunkList {
        private final long offset;
        private int length;
        private final List<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>();

        ConsecutiveChunkList(long offset) {
            this.offset = offset;
        }

        public void addChunk(ChunkDescriptor descriptor) {
            this.chunks.add(descriptor);
            this.length += descriptor.size;
        }

        public List<Chunk> readAll(SeekableInputStream f) throws IOException {
            ArrayList<Chunk> result = new ArrayList<Chunk>(this.chunks.size());
            f.seek(this.offset);
            int fullAllocations = this.length / ParquetFileReader.this.options.getMaxAllocationSize();
            int lastAllocationSize = this.length % ParquetFileReader.this.options.getMaxAllocationSize();
            int numAllocations = fullAllocations + (lastAllocationSize > 0 ? 1 : 0);
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(numAllocations);
            for (int i = 0; i < fullAllocations; ++i) {
                buffers.add(ParquetFileReader.this.options.getAllocator().allocate(ParquetFileReader.this.options.getMaxAllocationSize()));
            }
            if (lastAllocationSize > 0) {
                buffers.add(ParquetFileReader.this.options.getAllocator().allocate(lastAllocationSize));
            }
            for (ByteBuffer buffer : buffers) {
                f.readFully(buffer);
                buffer.flip();
            }
            BenchmarkCounter.incrementBytesRead(this.length);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap(buffers);
            for (int i = 0; i < this.chunks.size(); ++i) {
                ChunkDescriptor descriptor = this.chunks.get(i);
                if (i < this.chunks.size() - 1) {
                    result.add(new Chunk(descriptor, stream.sliceBuffers((long)descriptor.size)));
                    continue;
                }
                result.add(new WorkaroundChunk(descriptor, stream.sliceBuffers((long)descriptor.size), f));
            }
            return result;
        }

        public long endPos() {
            return this.offset + (long)this.length;
        }
    }

    private static class ChunkDescriptor {
        private final ColumnDescriptor col;
        private final ColumnChunkMetaData metadata;
        private final long fileOffset;
        private final int size;

        private ChunkDescriptor(ColumnDescriptor col, ColumnChunkMetaData metadata, long fileOffset, int size) {
            this.col = col;
            this.metadata = metadata;
            this.fileOffset = fileOffset;
            this.size = size;
        }
    }

    private class WorkaroundChunk
    extends Chunk {
        private final SeekableInputStream f;

        private WorkaroundChunk(ChunkDescriptor descriptor, List<ByteBuffer> buffers, SeekableInputStream f) {
            super(descriptor, buffers);
            this.f = f;
        }

        @Override
        protected PageHeader readPageHeader() throws IOException {
            PageHeader pageHeader;
            this.stream.mark(8192);
            try {
                pageHeader = Util.readPageHeader((InputStream)this.stream);
            }
            catch (IOException e) {
                this.stream.reset();
                LOG.info("completing the column chunk to read the page header");
                pageHeader = Util.readPageHeader((InputStream)new SequenceInputStream((InputStream)this.stream, (InputStream)this.f));
            }
            return pageHeader;
        }

        @Override
        public BytesInput readAsBytesInput(int size) throws IOException {
            int available = this.stream.available();
            if (size > available) {
                int missingBytes = size - available;
                LOG.info("completed the column chunk with {} bytes", (Object)missingBytes);
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                buffers.addAll(this.stream.sliceBuffers((long)available));
                ByteBuffer lastBuffer = ByteBuffer.allocate(missingBytes);
                this.f.readFully(lastBuffer);
                buffers.add(lastBuffer);
                return BytesInput.from(buffers);
            }
            return super.readAsBytesInput(size);
        }
    }

    private class Chunk {
        protected final ChunkDescriptor descriptor;
        protected final ByteBufferInputStream stream;

        public Chunk(ChunkDescriptor descriptor, List<ByteBuffer> buffers) {
            this.descriptor = descriptor;
            this.stream = ByteBufferInputStream.wrap(buffers);
        }

        protected PageHeader readPageHeader() throws IOException {
            return Util.readPageHeader((InputStream)this.stream);
        }

        public ColumnChunkPageReadStore.ColumnChunkPageReader readAllPages() throws IOException {
            ArrayList<DataPage> pagesInChunk = new ArrayList<DataPage>();
            DictionaryPage dictionaryPage = null;
            PrimitiveType type = ParquetFileReader.this.getFileMetaData().getSchema().getType(this.descriptor.col.getPath()).asPrimitiveType();
            long valuesCountReadSoFar = 0L;
            block5: while (valuesCountReadSoFar < this.descriptor.metadata.getValueCount()) {
                PageHeader pageHeader = this.readPageHeader();
                int uncompressedPageSize = pageHeader.getUncompressed_page_size();
                int compressedPageSize = pageHeader.getCompressed_page_size();
                switch (pageHeader.type) {
                    case DICTIONARY_PAGE: {
                        if (dictionaryPage != null) {
                            throw new ParquetDecodingException("more than one dictionary page in column " + this.descriptor.col);
                        }
                        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
                        dictionaryPage = new DictionaryPage(this.readAsBytesInput(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), ParquetFileReader.this.converter.getEncoding(dicHeader.getEncoding()));
                        continue block5;
                    }
                    case DATA_PAGE: {
                        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
                        pagesInChunk.add((DataPage)new DataPageV1(this.readAsBytesInput(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV1.getStatistics(), type), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getRepetition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getDefinition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getEncoding())));
                        valuesCountReadSoFar += (long)dataHeaderV1.getNum_values();
                        continue block5;
                    }
                    case DATA_PAGE_V2: {
                        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
                        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
                        pagesInChunk.add((DataPage)new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.readAsBytesInput(dataHeaderV2.getRepetition_levels_byte_length()), this.readAsBytesInput(dataHeaderV2.getDefinition_levels_byte_length()), ParquetFileReader.this.converter.getEncoding(dataHeaderV2.getEncoding()), this.readAsBytesInput(dataSize), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV2.getStatistics(), type), dataHeaderV2.isIs_compressed()));
                        valuesCountReadSoFar += (long)dataHeaderV2.getNum_values();
                        continue block5;
                    }
                }
                LOG.debug("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compressedPageSize);
                this.stream.skipFully((long)compressedPageSize);
            }
            if (valuesCountReadSoFar != this.descriptor.metadata.getValueCount()) {
                throw new IOException("Expected " + this.descriptor.metadata.getValueCount() + " values in column chunk at " + ParquetFileReader.this.getPath() + " offset " + this.descriptor.metadata.getFirstDataPageOffset() + " but got " + valuesCountReadSoFar + " values instead over " + pagesInChunk.size() + " pages ending at file offset " + (this.descriptor.fileOffset + this.stream.position()));
            }
            CompressionCodecFactory.BytesInputDecompressor decompressor = ParquetFileReader.this.options.getCodecFactory().getDecompressor(this.descriptor.metadata.getCodec());
            return new ColumnChunkPageReadStore.ColumnChunkPageReader(decompressor, pagesInChunk, dictionaryPage);
        }

        public BytesInput readAsBytesInput(int size) throws IOException {
            return BytesInput.from((List)this.stream.sliceBuffers((long)size));
        }
    }
}

