/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.httpdlog.ApacheHttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.NginxHttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpdLogFormatDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpdLogFormatDissector.class);
    public static final String INPUT_TYPE = "HTTPLOGLINE";
    private List<String> registeredLogFormats = new ArrayList<String>(16);
    private List<TokenFormatDissector> dissectors = new ArrayList<TokenFormatDissector>(16);
    private TokenFormatDissector activeDissector = null;
    private boolean enableJettyFix = false;

    public HttpdLogFormatDissector() {
    }

    public HttpdLogFormatDissector(String multiLineLogFormat) {
        this();
        this.addMultipleLogFormats(multiLineLogFormat);
        if (this.enableJettyFix) {
            this.addAdditionalLogFormatsToHandleJettyUseragentProblem();
        }
    }

    private void addAdditionalLogFormatsToHandleJettyUseragentProblem() {
        String patchedLogFormat;
        for (String logFormat : this.getAllLogFormats()) {
            if (!logFormat.contains("\"%{User-Agent}i\"")) continue;
            LOG.info("Creating extra logformat to handle Jetty useragent problem.");
            patchedLogFormat = logFormat.replace("\"%{User-Agent}i\"", "\"%{User-Agent}i\" ");
            this.addLogFormat(patchedLogFormat);
        }
        for (String logFormat : this.getAllLogFormats()) {
            if (!logFormat.contains("%u")) continue;
            LOG.info("Creating extra logformat to handle Jetty userfield problem.");
            patchedLogFormat = logFormat.replace("%u", " %u ");
            this.addLogFormat(patchedLogFormat);
        }
    }

    public HttpdLogFormatDissector enableJettyFix() {
        this.enableJettyFix = true;
        return this;
    }

    public HttpdLogFormatDissector addMultipleLogFormats(String multiLineLogFormat) {
        return this.addLogFormat(Arrays.asList(multiLineLogFormat.split("\\r?\\n")));
    }

    public HttpdLogFormatDissector addLogFormat(List<String> logFormats) {
        for (String logFormat : logFormats) {
            this.addLogFormat(logFormat);
        }
        return this;
    }

    public HttpdLogFormatDissector addLogFormat(String logFormat) {
        if (logFormat == null || logFormat.trim().isEmpty()) {
            return this;
        }
        if (logFormat.toUpperCase().trim().equals("ENABLE JETTY FIX")) {
            return this.enableJettyFix();
        }
        if (this.registeredLogFormats.contains(logFormat)) {
            LOG.info("Skipping duplicate LogFormat: >>{}<<", (Object)logFormat);
            return this;
        }
        this.registeredLogFormats.add(logFormat);
        switch (this.determineMostLikelyLogFormat(logFormat)) {
            case APACHE: {
                LOG.info("Registering APACHE HTTPD LogFormat[{}]= >>{}<<", (Object)this.dissectors.size(), (Object)logFormat);
                this.dissectors.add(new ApacheHttpdLogFormatDissector(logFormat));
                break;
            }
            case NGINX: {
                LOG.info("Registering NGINX LogFormat[{}]= >>{}<<", (Object)this.dissectors.size(), (Object)logFormat);
                this.dissectors.add(new NginxHttpdLogFormatDissector(logFormat));
                break;
            }
            default: {
                LOG.error("Unable to determine if this is an APACHE or a NGINX LogFormat= >>{}<<", (Object)logFormat);
            }
        }
        return this;
    }

    private LogFormatType determineMostLikelyLogFormat(String logFormat) {
        if (ApacheHttpdLogFormatDissector.looksLikeApacheFormat(logFormat)) {
            return LogFormatType.APACHE;
        }
        if (NginxHttpdLogFormatDissector.looksLikeNginxFormat(logFormat)) {
            return LogFormatType.NGINX;
        }
        return LogFormatType.UNKNOWN;
    }

    public boolean initializeFromSettingsParameter(String multiLineLogFormat) {
        this.addMultipleLogFormats(multiLineLogFormat);
        return true;
    }

    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        for (Dissector dissector : this.dissectors) {
            dissector.createAdditionalDissectors(parser);
        }
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        if (this.dissectors.isEmpty()) {
            throw new DissectionFailure("We need one or more logformats before we can dissect.");
        }
        if (this.activeDissector == null) {
            this.activeDissector = this.dissectors.get(0);
            LOG.info("At start we use LogFormat[0]= >>{}<<", (Object)this.activeDissector.getLogFormat());
        }
        try {
            this.activeDissector.dissect(parsable, inputname);
        }
        catch (DissectionFailure df) {
            if (this.dissectors.size() > 1) {
                int index = 0;
                for (TokenFormatDissector dissector : this.dissectors) {
                    try {
                        dissector.dissect(parsable, inputname);
                        LOG.info("Switched to LogFormat[{}]= >>{}<<", (Object)index, (Object)this.activeDissector.getLogFormat());
                        this.activeDissector = dissector;
                        return;
                    }
                    catch (DissectionFailure e) {
                        ++index;
                    }
                }
            }
            throw df;
        }
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        if (this.dissectors.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet result = new HashSet(32);
        for (Dissector dissector : this.dissectors) {
            result.addAll(dissector.getPossibleOutput());
        }
        return new ArrayList<String>(result);
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        if (this.dissectors.isEmpty()) {
            return Casts.NO_CASTS;
        }
        EnumSet<Casts> result = EnumSet.noneOf(Casts.class);
        for (Dissector dissector : this.dissectors) {
            result.addAll(dissector.prepareForDissect(inputname, outputname));
        }
        return result;
    }

    public void prepareForRun() throws InvalidDissectorException {
        if (this.dissectors.isEmpty()) {
            throw new InvalidDissectorException("Cannot run without logformats");
        }
        for (Dissector dissector : this.dissectors) {
            if (!INPUT_TYPE.equals(dissector.getInputType())) {
                throw new InvalidDissectorException("All dissectors controlled by " + ((Object)((Object)this)).getClass().getCanonicalName() + " MUST have \"" + INPUT_TYPE + "\" as their inputtype.");
            }
            dissector.prepareForRun();
        }
    }

    private List<String> getAllLogFormats() {
        ArrayList<String> result = new ArrayList<String>(this.dissectors.size());
        for (Dissector dissector : this.dissectors) {
            if (!(dissector instanceof TokenFormatDissector)) continue;
            result.add(((TokenFormatDissector)dissector).getLogFormat());
        }
        return result;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        if (this.dissectors.isEmpty()) {
            return;
        }
        if (newInstance instanceof HttpdLogFormatDissector) {
            ((HttpdLogFormatDissector)newInstance).addLogFormat(this.getAllLogFormats());
            if (this.enableJettyFix) {
                ((HttpdLogFormatDissector)newInstance).enableJettyFix();
            }
        } else {
            LOG.error("============================== WTF == {}", (Object)newInstance.getClass().getCanonicalName());
        }
    }

    private static enum LogFormatType {
        APACHE,
        NGINX,
        UNKNOWN;

    }
}

