/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String tableName;
    private Map<String, AttributeValue> item;
    private Map<String, ExpectedAttributeValue> expected;
    private String returnValues;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;
    private String conditionalOperator;
    private String conditionExpression;
    private Map<String, String> expressionAttributeNames;
    private Map<String, AttributeValue> expressionAttributeValues;

    public PutItemRequest() {
    }

    public PutItemRequest(String tableName, Map<String, AttributeValue> item) {
        this.setTableName(tableName);
        this.setItem(item);
    }

    public PutItemRequest(String tableName, Map<String, AttributeValue> item, String returnValues) {
        this.setTableName(tableName);
        this.setItem(item);
        this.setReturnValues(returnValues);
    }

    public PutItemRequest(String tableName, Map<String, AttributeValue> item, ReturnValue returnValues) {
        this.setTableName(tableName);
        this.setItem(item);
        this.setReturnValues(returnValues.toString());
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PutItemRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public PutItemRequest withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public PutItemRequest addItemEntry(String key, AttributeValue value) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.item.put(key, value);
        return this;
    }

    public PutItemRequest clearItemEntries() {
        this.item = null;
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> expected) {
        this.expected = expected;
    }

    public PutItemRequest withExpected(Map<String, ExpectedAttributeValue> expected) {
        this.setExpected(expected);
        return this;
    }

    public PutItemRequest addExpectedEntry(String key, ExpectedAttributeValue value) {
        if (null == this.expected) {
            this.expected = new HashMap<String, ExpectedAttributeValue>();
        }
        if (this.expected.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expected.put(key, value);
        return this;
    }

    public PutItemRequest clearExpectedEntries() {
        this.expected = null;
        return this;
    }

    public void setReturnValues(String returnValues) {
        this.returnValues = returnValues;
    }

    @JsonProperty(value="returnValues")
    public String getReturnValues() {
        return this.returnValues;
    }

    public PutItemRequest withReturnValues(String returnValues) {
        this.setReturnValues(returnValues);
        return this;
    }

    @JsonIgnore
    public void setReturnValues(ReturnValue returnValues) {
        this.withReturnValues(returnValues);
    }

    public PutItemRequest withReturnValues(ReturnValue returnValues) {
        this.returnValues = returnValues.toString();
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    @JsonProperty(value="returnConsumedCapacity")
    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public PutItemRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    @JsonIgnore
    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.withReturnConsumedCapacity(returnConsumedCapacity);
    }

    public PutItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics;
    }

    @JsonProperty(value="returnItemCollectionMetrics")
    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public PutItemRequest withReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    @JsonIgnore
    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.withReturnItemCollectionMetrics(returnItemCollectionMetrics);
    }

    public PutItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    @JsonProperty(value="conditionalOperator")
    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public PutItemRequest withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    @JsonIgnore
    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.withConditionalOperator(conditionalOperator);
    }

    public PutItemRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public void setConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public PutItemRequest withConditionExpression(String conditionExpression) {
        this.setConditionExpression(conditionExpression);
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public PutItemRequest withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public PutItemRequest addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public PutItemRequest clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.expressionAttributeValues = expressionAttributeValues;
    }

    public PutItemRequest withExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.setExpressionAttributeValues(expressionAttributeValues);
        return this;
    }

    public PutItemRequest addExpressionAttributeValuesEntry(String key, AttributeValue value) {
        if (null == this.expressionAttributeValues) {
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
        }
        if (this.expressionAttributeValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeValues.put(key, value);
        return this;
    }

    public PutItemRequest clearExpressionAttributeValuesEntries() {
        this.expressionAttributeValues = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getItem() != null) {
            sb.append("Item: ").append(this.getItem()).append(",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: ").append(this.getExpected()).append(",");
        }
        if (this.getReturnValues() != null) {
            sb.append("ReturnValues: ").append(this.getReturnValues()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity()).append(",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.getReturnItemCollectionMetrics()).append(",");
        }
        if (this.getConditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.getConditionalOperator()).append(",");
        }
        if (this.getConditionExpression() != null) {
            sb.append("ConditionExpression: ").append(this.getConditionExpression()).append(",");
        }
        if (this.getExpressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.getExpressionAttributeNames()).append(",");
        }
        if (this.getExpressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.getExpressionAttributeValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        if (other.getItem() != null && !other.getItem().equals(this.getItem())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (other.getExpected() != null && !other.getExpected().equals(this.getExpected())) {
            return false;
        }
        if (other.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        if (other.getReturnValues() != null && !other.getReturnValues().equals(this.getReturnValues())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() != null && !other.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics())) {
            return false;
        }
        if (other.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (other.getConditionalOperator() != null && !other.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (other.getConditionExpression() == null ^ this.getConditionExpression() == null) {
            return false;
        }
        if (other.getConditionExpression() != null && !other.getConditionExpression().equals(this.getConditionExpression())) {
            return false;
        }
        if (other.getExpressionAttributeNames() == null ^ this.getExpressionAttributeNames() == null) {
            return false;
        }
        if (other.getExpressionAttributeNames() != null && !other.getExpressionAttributeNames().equals(this.getExpressionAttributeNames())) {
            return false;
        }
        if (other.getExpressionAttributeValues() == null ^ this.getExpressionAttributeValues() == null) {
            return false;
        }
        return other.getExpressionAttributeValues() == null || other.getExpressionAttributeValues().equals(this.getExpressionAttributeValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : this.getItem().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        hashCode = 31 * hashCode + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.getConditionExpression() == null ? 0 : this.getConditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeNames() == null ? 0 : this.getExpressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeValues() == null ? 0 : this.getExpressionAttributeValues().hashCode());
        return hashCode;
    }

    @Override
    public PutItemRequest clone() {
        return (PutItemRequest)super.clone();
    }
}

