/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directconnect.model.Connection;
import com.amazonaws.services.directconnect.model.LagState;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateLagResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String connectionsBandwidth;
    private Integer numberOfConnections;
    private String lagId;
    private String ownerAccount;
    private String lagName;
    private String lagState;
    private String location;
    private String region;
    private Integer minimumLinks;
    private String awsDevice;
    private SdkInternalList<Connection> connections;
    private Boolean allowsHostedConnections;

    public void setConnectionsBandwidth(String connectionsBandwidth) {
        this.connectionsBandwidth = connectionsBandwidth;
    }

    public String getConnectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public UpdateLagResult withConnectionsBandwidth(String connectionsBandwidth) {
        this.setConnectionsBandwidth(connectionsBandwidth);
        return this;
    }

    public void setNumberOfConnections(Integer numberOfConnections) {
        this.numberOfConnections = numberOfConnections;
    }

    public Integer getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public UpdateLagResult withNumberOfConnections(Integer numberOfConnections) {
        this.setNumberOfConnections(numberOfConnections);
        return this;
    }

    public void setLagId(String lagId) {
        this.lagId = lagId;
    }

    public String getLagId() {
        return this.lagId;
    }

    public UpdateLagResult withLagId(String lagId) {
        this.setLagId(lagId);
        return this;
    }

    public void setOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public UpdateLagResult withOwnerAccount(String ownerAccount) {
        this.setOwnerAccount(ownerAccount);
        return this;
    }

    public void setLagName(String lagName) {
        this.lagName = lagName;
    }

    public String getLagName() {
        return this.lagName;
    }

    public UpdateLagResult withLagName(String lagName) {
        this.setLagName(lagName);
        return this;
    }

    public void setLagState(String lagState) {
        this.lagState = lagState;
    }

    @JsonProperty(value="lagState")
    public String getLagState() {
        return this.lagState;
    }

    public UpdateLagResult withLagState(String lagState) {
        this.setLagState(lagState);
        return this;
    }

    @JsonIgnore
    public void setLagState(LagState lagState) {
        this.withLagState(lagState);
    }

    public UpdateLagResult withLagState(LagState lagState) {
        this.lagState = lagState.toString();
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public UpdateLagResult withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public UpdateLagResult withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setMinimumLinks(Integer minimumLinks) {
        this.minimumLinks = minimumLinks;
    }

    public Integer getMinimumLinks() {
        return this.minimumLinks;
    }

    public UpdateLagResult withMinimumLinks(Integer minimumLinks) {
        this.setMinimumLinks(minimumLinks);
        return this;
    }

    public void setAwsDevice(String awsDevice) {
        this.awsDevice = awsDevice;
    }

    public String getAwsDevice() {
        return this.awsDevice;
    }

    public UpdateLagResult withAwsDevice(String awsDevice) {
        this.setAwsDevice(awsDevice);
        return this;
    }

    public List<Connection> getConnections() {
        if (this.connections == null) {
            this.connections = new SdkInternalList();
        }
        return this.connections;
    }

    public void setConnections(Collection<Connection> connections) {
        if (connections == null) {
            this.connections = null;
            return;
        }
        this.connections = new SdkInternalList<Connection>(connections);
    }

    public UpdateLagResult withConnections(Connection ... connections) {
        if (this.connections == null) {
            this.setConnections(new SdkInternalList<Connection>(connections.length));
        }
        for (Connection ele : connections) {
            this.connections.add(ele);
        }
        return this;
    }

    public UpdateLagResult withConnections(Collection<Connection> connections) {
        this.setConnections(connections);
        return this;
    }

    public void setAllowsHostedConnections(Boolean allowsHostedConnections) {
        this.allowsHostedConnections = allowsHostedConnections;
    }

    public Boolean getAllowsHostedConnections() {
        return this.allowsHostedConnections;
    }

    public UpdateLagResult withAllowsHostedConnections(Boolean allowsHostedConnections) {
        this.setAllowsHostedConnections(allowsHostedConnections);
        return this;
    }

    public Boolean isAllowsHostedConnections() {
        return this.allowsHostedConnections;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectionsBandwidth() != null) {
            sb.append("ConnectionsBandwidth: ").append(this.getConnectionsBandwidth()).append(",");
        }
        if (this.getNumberOfConnections() != null) {
            sb.append("NumberOfConnections: ").append(this.getNumberOfConnections()).append(",");
        }
        if (this.getLagId() != null) {
            sb.append("LagId: ").append(this.getLagId()).append(",");
        }
        if (this.getOwnerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.getOwnerAccount()).append(",");
        }
        if (this.getLagName() != null) {
            sb.append("LagName: ").append(this.getLagName()).append(",");
        }
        if (this.getLagState() != null) {
            sb.append("LagState: ").append(this.getLagState()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getMinimumLinks() != null) {
            sb.append("MinimumLinks: ").append(this.getMinimumLinks()).append(",");
        }
        if (this.getAwsDevice() != null) {
            sb.append("AwsDevice: ").append(this.getAwsDevice()).append(",");
        }
        if (this.getConnections() != null) {
            sb.append("Connections: ").append(this.getConnections()).append(",");
        }
        if (this.getAllowsHostedConnections() != null) {
            sb.append("AllowsHostedConnections: ").append(this.getAllowsHostedConnections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLagResult)) {
            return false;
        }
        UpdateLagResult other = (UpdateLagResult)obj;
        if (other.getConnectionsBandwidth() == null ^ this.getConnectionsBandwidth() == null) {
            return false;
        }
        if (other.getConnectionsBandwidth() != null && !other.getConnectionsBandwidth().equals(this.getConnectionsBandwidth())) {
            return false;
        }
        if (other.getNumberOfConnections() == null ^ this.getNumberOfConnections() == null) {
            return false;
        }
        if (other.getNumberOfConnections() != null && !other.getNumberOfConnections().equals(this.getNumberOfConnections())) {
            return false;
        }
        if (other.getLagId() == null ^ this.getLagId() == null) {
            return false;
        }
        if (other.getLagId() != null && !other.getLagId().equals(this.getLagId())) {
            return false;
        }
        if (other.getOwnerAccount() == null ^ this.getOwnerAccount() == null) {
            return false;
        }
        if (other.getOwnerAccount() != null && !other.getOwnerAccount().equals(this.getOwnerAccount())) {
            return false;
        }
        if (other.getLagName() == null ^ this.getLagName() == null) {
            return false;
        }
        if (other.getLagName() != null && !other.getLagName().equals(this.getLagName())) {
            return false;
        }
        if (other.getLagState() == null ^ this.getLagState() == null) {
            return false;
        }
        if (other.getLagState() != null && !other.getLagState().equals(this.getLagState())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getMinimumLinks() == null ^ this.getMinimumLinks() == null) {
            return false;
        }
        if (other.getMinimumLinks() != null && !other.getMinimumLinks().equals(this.getMinimumLinks())) {
            return false;
        }
        if (other.getAwsDevice() == null ^ this.getAwsDevice() == null) {
            return false;
        }
        if (other.getAwsDevice() != null && !other.getAwsDevice().equals(this.getAwsDevice())) {
            return false;
        }
        if (other.getConnections() == null ^ this.getConnections() == null) {
            return false;
        }
        if (other.getConnections() != null && !other.getConnections().equals(this.getConnections())) {
            return false;
        }
        if (other.getAllowsHostedConnections() == null ^ this.getAllowsHostedConnections() == null) {
            return false;
        }
        return other.getAllowsHostedConnections() == null || other.getAllowsHostedConnections().equals(this.getAllowsHostedConnections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectionsBandwidth() == null ? 0 : this.getConnectionsBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfConnections() == null ? 0 : this.getNumberOfConnections().hashCode());
        hashCode = 31 * hashCode + (this.getLagId() == null ? 0 : this.getLagId().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAccount() == null ? 0 : this.getOwnerAccount().hashCode());
        hashCode = 31 * hashCode + (this.getLagName() == null ? 0 : this.getLagName().hashCode());
        hashCode = 31 * hashCode + (this.getLagState() == null ? 0 : this.getLagState().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getMinimumLinks() == null ? 0 : this.getMinimumLinks().hashCode());
        hashCode = 31 * hashCode + (this.getAwsDevice() == null ? 0 : this.getAwsDevice().hashCode());
        hashCode = 31 * hashCode + (this.getConnections() == null ? 0 : this.getConnections().hashCode());
        hashCode = 31 * hashCode + (this.getAllowsHostedConnections() == null ? 0 : this.getAllowsHostedConnections().hashCode());
        return hashCode;
    }

    public UpdateLagResult clone() {
        try {
            return (UpdateLagResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

