/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.FacetAttributeType;
import com.amazonaws.services.clouddirectory.model.RequiredAttributeBehavior;
import com.amazonaws.services.clouddirectory.model.Rule;
import com.amazonaws.services.clouddirectory.model.TypedAttributeValue;
import com.amazonaws.services.clouddirectory.model.transform.TypedLinkAttributeDefinitionMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TypedLinkAttributeDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private TypedAttributeValue defaultValue;
    private Boolean isImmutable;
    private Map<String, Rule> rules;
    private String requiredBehavior;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TypedLinkAttributeDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public TypedLinkAttributeDefinition withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(FacetAttributeType type) {
        this.withType(type);
    }

    public TypedLinkAttributeDefinition withType(FacetAttributeType type) {
        this.type = type.toString();
        return this;
    }

    public void setDefaultValue(TypedAttributeValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public TypedAttributeValue getDefaultValue() {
        return this.defaultValue;
    }

    public TypedLinkAttributeDefinition withDefaultValue(TypedAttributeValue defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setIsImmutable(Boolean isImmutable) {
        this.isImmutable = isImmutable;
    }

    public Boolean getIsImmutable() {
        return this.isImmutable;
    }

    public TypedLinkAttributeDefinition withIsImmutable(Boolean isImmutable) {
        this.setIsImmutable(isImmutable);
        return this;
    }

    public Boolean isImmutable() {
        return this.isImmutable;
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public void setRules(Map<String, Rule> rules) {
        this.rules = rules;
    }

    public TypedLinkAttributeDefinition withRules(Map<String, Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public TypedLinkAttributeDefinition addRulesEntry(String key, Rule value) {
        if (null == this.rules) {
            this.rules = new HashMap<String, Rule>();
        }
        if (this.rules.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.rules.put(key, value);
        return this;
    }

    public TypedLinkAttributeDefinition clearRulesEntries() {
        this.rules = null;
        return this;
    }

    public void setRequiredBehavior(String requiredBehavior) {
        this.requiredBehavior = requiredBehavior;
    }

    @JsonProperty(value="requiredBehavior")
    public String getRequiredBehavior() {
        return this.requiredBehavior;
    }

    public TypedLinkAttributeDefinition withRequiredBehavior(String requiredBehavior) {
        this.setRequiredBehavior(requiredBehavior);
        return this;
    }

    @JsonIgnore
    public void setRequiredBehavior(RequiredAttributeBehavior requiredBehavior) {
        this.withRequiredBehavior(requiredBehavior);
    }

    public TypedLinkAttributeDefinition withRequiredBehavior(RequiredAttributeBehavior requiredBehavior) {
        this.requiredBehavior = requiredBehavior.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getIsImmutable() != null) {
            sb.append("IsImmutable: ").append(this.getIsImmutable()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getRequiredBehavior() != null) {
            sb.append("RequiredBehavior: ").append(this.getRequiredBehavior());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkAttributeDefinition)) {
            return false;
        }
        TypedLinkAttributeDefinition other = (TypedLinkAttributeDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getIsImmutable() == null ^ this.getIsImmutable() == null) {
            return false;
        }
        if (other.getIsImmutable() != null && !other.getIsImmutable().equals(this.getIsImmutable())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getRequiredBehavior() == null ^ this.getRequiredBehavior() == null) {
            return false;
        }
        return other.getRequiredBehavior() == null || other.getRequiredBehavior().equals(this.getRequiredBehavior());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getIsImmutable() == null ? 0 : this.getIsImmutable().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getRequiredBehavior() == null ? 0 : this.getRequiredBehavior().hashCode());
        return hashCode;
    }

    public TypedLinkAttributeDefinition clone() {
        try {
            return (TypedLinkAttributeDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkAttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

