/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.shaded.com.google.common.base.Objects;
import org.apache.kudu.client.shaded.com.google.common.collect.ComparisonChain;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class RemoteTablet
implements Comparable<RemoteTablet> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTablet.class);
    private final String tableId;
    private final String tabletId;
    @GuardedBy(value="tabletServers")
    private final Map<String, ServerInfo> tabletServers;
    private final AtomicReference<List<LocatedTablet.Replica>> replicas = new AtomicReference(ImmutableList.of());
    private final Partition partition;
    @GuardedBy(value="tabletServers")
    private String leaderUuid;

    RemoteTablet(String tableId, Master.TabletLocationsPB tabletLocations, List<ServerInfo> serverInfos) {
        this.tabletId = tabletLocations.getTabletId().toStringUtf8();
        this.tableId = tableId;
        this.partition = ProtobufHelper.pbToPartition(tabletLocations.getPartition());
        this.tabletServers = new HashMap<String, ServerInfo>(serverInfos.size());
        for (ServerInfo serverInfo : serverInfos) {
            this.tabletServers.put(serverInfo.getUuid(), serverInfo);
        }
        ImmutableList.Builder replicasBuilder = new ImmutableList.Builder();
        for (Master.TabletLocationsPB.ReplicaPB replica : tabletLocations.getReplicasList()) {
            String uuid = replica.getTsInfo().getPermanentUuid().toStringUtf8();
            replicasBuilder.add(new LocatedTablet.Replica(replica));
            if (!replica.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) continue;
            this.leaderUuid = uuid;
        }
        if (this.leaderUuid == null) {
            LOG.warn("No leader provided for tablet {}", (Object)this.getTabletId());
        }
        this.replicas.set((List<LocatedTablet.Replica>)((Object)replicasBuilder.build()));
    }

    public String toString() {
        return this.getTabletId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTabletClient(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid != null && this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
            }
            if (this.tabletServers.remove(uuid) != null) {
                return true;
            }
            LOG.debug("tablet {} already removed ts {}, size left is {}", new Object[]{this.getTabletId(), uuid, this.tabletServers.size()});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demoteLeader(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid == null) {
                LOG.debug("{} couldn't be demoted as the leader for {}, there is no known leader", (Object)uuid, (Object)this.getTabletId());
                return;
            }
            if (this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
                LOG.debug("{} was demoted as the leader for {}", (Object)uuid, (Object)this.getTabletId());
            } else {
                LOG.debug("{} wasn't the leader for {}, current leader is {}", new Object[]{uuid, this.getTabletId(), this.leaderUuid});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLeaderUUID() {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            return this.leaderUuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getClosestUUID() {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            String lastUuid = null;
            for (ServerInfo serverInfo : this.tabletServers.values()) {
                lastUuid = serverInfo.getUuid();
                if (!serverInfo.isLocal()) continue;
                return serverInfo.getUuid();
            }
            return lastUuid;
        }
    }

    String getReplicaSelectedUUID(ReplicaSelection replicaSelection) {
        switch (replicaSelection) {
            case LEADER_ONLY: {
                return this.getLeaderUUID();
            }
            case CLOSEST_REPLICA: {
                return this.getClosestUUID();
            }
        }
        throw new RuntimeException("Unknown replica selection mechanism " + (Object)((Object)replicaSelection));
    }

    List<LocatedTablet.Replica> getReplicas() {
        return this.replicas.get();
    }

    public String getTableId() {
        return this.tableId;
    }

    String getTabletId() {
        return this.tabletId;
    }

    public Partition getPartition() {
        return this.partition;
    }

    byte[] getTabletIdAsBytes() {
        return this.tabletId.getBytes();
    }

    @Override
    public int compareTo(RemoteTablet remoteTablet) {
        if (remoteTablet == null) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.tableId), (Comparable<?>)((Object)remoteTablet.tableId)).compare(this.partition, remoteTablet.partition).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTablet that = (RemoteTablet)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.partition);
    }
}

