/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.LinkedList;
import java.util.List;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import sqlline.Dialect;
import sqlline.SqlLine;

public class SqlLineParser
extends DefaultParser {
    private static final String DEFAULT_QUOTES = "'\"`";
    private final SqlLine sqlLine;

    public SqlLineParser(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
        String quotes = DEFAULT_QUOTES;
        char openQuote = sqlLine.getDialect().getOpenQuote();
        if ('[' != openQuote && '(' != openQuote && DEFAULT_QUOTES.indexOf(openQuote) == -1) {
            quotes = quotes + openQuote;
        }
        this.quoteChars(quotes.toCharArray());
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        try {
            if (!this.sqlLine.getOpts().getUseLineContinuation() || this.sqlLine.isPrompting()) {
                this.eofOnUnclosedQuote(false);
                this.eofOnEscapedNewLine(false);
                return super.parse(line, cursor, context);
            }
            this.eofOnUnclosedQuote(true);
            this.eofOnEscapedNewLine(true);
            LinkedList<String> words = new LinkedList<String>();
            StringBuilder current = new StringBuilder();
            boolean containsNonCommentData = false;
            int wordCursor = -1;
            int wordIndex = -1;
            int quoteStart = -1;
            int oneLineCommentStart = -1;
            int multiLineCommentStart = -1;
            int[] roundBracketsBalance = new int[2];
            int[] squareBracketsBalance = new int[2];
            int rawWordCursor = -1;
            int rawWordLength = -1;
            int rawWordStart = 0;
            int lastNonQuoteCommentIndex = 0;
            boolean isSql = SqlLineParser.isSql(this.sqlLine, line, context);
            for (int i = 0; i < line.length(); ++i) {
                if (i == cursor) {
                    wordIndex = words.size();
                    wordCursor = current.length();
                    rawWordCursor = i - rawWordStart;
                }
                if (oneLineCommentStart == -1 && multiLineCommentStart == -1 && quoteStart < 0 && this.isQuoteChar(line, i)) {
                    quoteStart = i;
                    containsNonCommentData = true;
                    continue;
                }
                char currentChar = line.charAt(i);
                if (quoteStart >= 0) {
                    if (line.charAt(quoteStart) == currentChar && !this.isEscaped(line, i)) {
                        words.add(current.toString());
                        current.setLength(0);
                        quoteStart = -1;
                        if (rawWordCursor < 0 || rawWordLength >= 0) continue;
                        rawWordLength = i - rawWordStart + 1;
                        continue;
                    }
                    if (this.isEscapeChar(line, i)) continue;
                    current.append(currentChar);
                    continue;
                }
                if (oneLineCommentStart == -1 && this.isMultiLineComment(line, i)) {
                    multiLineCommentStart = i;
                    rawWordLength = this.getRawWordLength(words, current, rawWordCursor, rawWordLength, rawWordStart, i);
                    rawWordStart = i + 1;
                    continue;
                }
                if (multiLineCommentStart >= 0) {
                    if (currentChar != '/' || line.charAt(i - 1) != '*') continue;
                    words.add(current.toString());
                    current.setLength(0);
                    multiLineCommentStart = -1;
                    if (rawWordCursor < 0 || rawWordLength >= 0) continue;
                    rawWordLength = i - rawWordStart + 1;
                    continue;
                }
                if (oneLineCommentStart == -1 && this.isOneLineComment(line, i)) {
                    oneLineCommentStart = i;
                    rawWordLength = this.getRawWordLength(words, current, rawWordCursor, rawWordLength, rawWordStart, i);
                    rawWordStart = i + 1;
                    continue;
                }
                if (oneLineCommentStart >= 0) {
                    if (currentChar == '\n') {
                        oneLineCommentStart = -1;
                        rawWordLength = this.getRawWordLength(words, current, rawWordCursor, rawWordLength, rawWordStart, i);
                        rawWordStart = i + 1;
                        continue;
                    }
                    current.append(currentChar);
                    continue;
                }
                this.checkBracketBalance(roundBracketsBalance, currentChar, '(', ')');
                this.checkBracketBalance(squareBracketsBalance, currentChar, '[', ']');
                containsNonCommentData = true;
                if (!Character.isWhitespace(currentChar)) {
                    lastNonQuoteCommentIndex = i;
                }
                if (this.isDelimiter(line, i)) {
                    rawWordLength = this.getRawWordLength(words, current, rawWordCursor, rawWordLength, rawWordStart, i);
                    rawWordStart = i + 1;
                    continue;
                }
                if (this.isEscapeChar(line, i)) continue;
                current.append(currentChar);
            }
            if (current.length() > 0 || cursor == line.length()) {
                words.add(current.toString());
                if (rawWordCursor >= 0 && rawWordLength < 0) {
                    rawWordLength = line.length() - rawWordStart;
                }
            }
            if (cursor == line.length()) {
                wordIndex = words.size() - 1;
                wordCursor = ((String)words.get(words.size() - 1)).length();
                rawWordLength = rawWordCursor = cursor - rawWordStart;
            }
            if (this.isEofOnEscapedNewLine() && this.isEscapeChar(line, line.length() - 1)) {
                throw new EOFError(-1, -1, "Escaped new line", this.getPaddedPrompt("newline"));
            }
            if (context != Parser.ParseContext.COMPLETE) {
                if (this.isEofOnUnclosedQuote() && quoteStart >= 0) {
                    throw new EOFError(-1, -1, "Missing closing quote", this.getPaddedPrompt(this.getQuoteWaitingPattern(line, quoteStart)));
                }
                if (isSql) {
                    int lastNonQuoteCommentIndex1;
                    if (multiLineCommentStart != -1) {
                        throw new EOFError(-1, -1, "Missing end of comment", this.getPaddedPrompt("*/"));
                    }
                    if (roundBracketsBalance[0] != 0 || roundBracketsBalance[1] != 0) {
                        throw new EOFError(-1, -1, "Round brackets balance fails", this.getPaddedPrompt(roundBracketsBalance[0] == 0 ? "extra ')'" : ")"));
                    }
                    if (squareBracketsBalance[0] != 0 || squareBracketsBalance[1] != 0) {
                        throw new EOFError(-1, -1, "Square brackets balance fails", this.getPaddedPrompt(squareBracketsBalance[0] == 0 ? "extra ']'" : "]"));
                    }
                    int n = lastNonQuoteCommentIndex1 = lastNonQuoteCommentIndex == line.length() - 1 && lastNonQuoteCommentIndex - 1 >= 0 ? lastNonQuoteCommentIndex - 1 : lastNonQuoteCommentIndex;
                    if (containsNonCommentData && !this.isLineFinishedWithSemicolon(lastNonQuoteCommentIndex1, line)) {
                        throw new EOFError(-1, -1, "Missing semicolon at the end", this.getPaddedPrompt("semicolon"));
                    }
                }
            }
            String openingQuote = quoteStart >= 0 ? line.substring(quoteStart, quoteStart + 1) : null;
            return new DefaultParser.ArgumentList((DefaultParser)this, line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
        }
        catch (Exception e) {
            if (e instanceof EOFError) {
                throw e;
            }
            this.sqlLine.handleException(e);
            return super.parse(line, cursor, context);
        }
    }

    public String getQuoteWaitingPattern(String line, int quoteStart) {
        switch (line.charAt(quoteStart)) {
            case '\'': {
                return "quote";
            }
            case '\"': {
                return "dquote";
            }
            case '`': {
                return "`";
            }
        }
        return String.valueOf(line.charAt(quoteStart));
    }

    private void checkBracketBalance(int[] balance, char actual, char openBracket, char closeBracket) {
        if (actual == openBracket) {
            balance[0] = balance[0] + 1;
        } else if (actual == closeBracket) {
            if (balance[0] > 0) {
                balance[0] = balance[0] - 1;
            } else {
                balance[1] = balance[1] + 1;
            }
        }
    }

    private int getRawWordLength(List<String> words, StringBuilder current, int rawWordCursor, int rawWordLength, int rawWordStart, int i) {
        if (current.length() > 0) {
            words.add(current.toString());
            current.setLength(0);
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                rawWordLength = i - rawWordStart;
            }
        }
        return rawWordLength;
    }

    static boolean isSql(SqlLine sqlLine, String line, Parser.ParseContext context) {
        String trimmedLine = SqlLineParser.trimLeadingSpacesIfPossible(line, context);
        return !trimmedLine.isEmpty() && !sqlLine.isComment(trimmedLine, false) && (trimmedLine.charAt(0) != '!' || trimmedLine.regionMatches(0, "!sql", 0, "!sql".length()) || trimmedLine.regionMatches(0, "!all", 0, "!all".length()));
    }

    private boolean isLineFinishedWithSemicolon(int lastNonQuoteCommentIndex, CharSequence buffer) {
        String line = buffer.toString();
        boolean lineEmptyOrFinishedWithSemicolon = line.isEmpty();
        boolean requiredSemicolon = false;
        for (int i = lastNonQuoteCommentIndex; i < line.length(); ++i) {
            if (';' == line.charAt(i)) {
                lineEmptyOrFinishedWithSemicolon = true;
                continue;
            }
            if (i < line.length() - 1 && line.regionMatches(i, "/*", 0, "/*".length())) {
                int nextNonCommentedChar = line.indexOf("*/", i + "/*".length());
                if (nextNonCommentedChar > lastNonQuoteCommentIndex) {
                    i = nextNonCommentedChar + "*/".length();
                }
            } else {
                Dialect dialect = this.sqlLine.getDialect();
                for (String oneLineCommentString : dialect.getOneLineComments()) {
                    if (i > buffer.length() - oneLineCommentString.length() || !oneLineCommentString.regionMatches(0, line, i, oneLineCommentString.length())) continue;
                    int nextLine = line.indexOf(10, i + 1);
                    if (nextLine > lastNonQuoteCommentIndex) {
                        i = nextLine;
                        continue;
                    }
                    return !requiredSemicolon || lineEmptyOrFinishedWithSemicolon;
                }
            }
            boolean bl = i == line.length() ? requiredSemicolon : (requiredSemicolon = !lineEmptyOrFinishedWithSemicolon || !Character.isWhitespace(line.charAt(i)));
            if (!requiredSemicolon) continue;
            lineEmptyOrFinishedWithSemicolon = false;
        }
        return !requiredSemicolon || lineEmptyOrFinishedWithSemicolon;
    }

    private boolean isOneLineComment(String buffer, int pos) {
        Dialect dialect = this.sqlLine.getDialect();
        int newLinePos = buffer.indexOf(10);
        if ((newLinePos == -1 || newLinePos > pos) && buffer.substring(0, pos).trim().isEmpty()) {
            for (String oneLineCommentString : dialect.getSqlLineOneLineComments()) {
                if (pos > buffer.length() - oneLineCommentString.length() || !oneLineCommentString.regionMatches(0, buffer, pos, oneLineCommentString.length())) continue;
                return true;
            }
        }
        for (String oneLineCommentString : dialect.getOneLineComments()) {
            if (pos > buffer.length() - oneLineCommentString.length() || !oneLineCommentString.regionMatches(0, buffer, pos, oneLineCommentString.length())) continue;
            return true;
        }
        return false;
    }

    private boolean isMultiLineComment(CharSequence buffer, int pos) {
        return pos < buffer.length() - 1 && buffer.charAt(pos) == '/' && buffer.charAt(pos + 1) == '*';
    }

    public static String trimLeadingSpacesIfPossible(String line, Parser.ParseContext context) {
        int i;
        if (context != Parser.ParseContext.ACCEPT_LINE) {
            return line;
        }
        char[] chars = line.toCharArray();
        for (i = 0; i < chars.length && Character.isWhitespace(chars[i]); ++i) {
        }
        return line.substring(i);
    }

    private String getPaddedPrompt(String waitingPattern) {
        int length = this.sqlLine.getPromptHandler().getPrompt().columnLength();
        StringBuilder prompt = new StringBuilder(length);
        for (int i = 0; i < length - "> ".length() - waitingPattern.length(); ++i) {
            prompt.append(i % 2 == 0 ? (char)'.' : ' ');
        }
        prompt.append(waitingPattern);
        return prompt.toString();
    }
}

