/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import sqlline.SqlLine;

class DatabaseMetaDataWrapper {
    private static final String METHOD_NOT_SUPPORTED = "Method not supported";
    private final SqlLine sqlLine;
    private final DatabaseMetaData metaData;

    DatabaseMetaDataWrapper(SqlLine sqlLine, DatabaseMetaData metaData) {
        this.metaData = metaData;
        this.sqlLine = sqlLine;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.getBooleanOrDefault("allProceduresAreCallable", false, new Object[0]);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.getBooleanOrDefault("allTablesAreSelectable", false, new Object[0]);
    }

    public String getURL() throws SQLException {
        return this.getStringOrDefault("getURL", null);
    }

    public String getUserName() throws SQLException {
        return this.getString("getUserName");
    }

    public boolean isReadOnly() throws SQLException {
        return this.getBooleanOrDefault("isReadOnly", false, new Object[0]);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getBooleanOrDefault("nullsAreSortedHigh", false, new Object[0]);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.getBooleanOrDefault("nullsAreSortedLow", false, new Object[0]);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getBooleanOrDefault("nullsAreSortedAtStart", false, new Object[0]);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getBooleanOrDefault("nullsAreSortedAtEnd", false, new Object[0]);
    }

    public String getDatabaseProductName() throws SQLException {
        return this.getStringOrDefault("getDatabaseProductName", null);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.getString("getDatabaseProductVersion");
    }

    public String getDriverName() throws SQLException {
        return this.getString("getDriverName");
    }

    public String getDriverVersion() throws SQLException {
        return this.getString("getDriverVersion");
    }

    public int getDriverMajorVersion() {
        try {
            return this.getInt("getDriverMajorVersion");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getDriverMinorVersion() {
        try {
            return this.getInt("getDriverMinorVersion");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.getBooleanOrDefault("usesLocalFiles", false, new Object[0]);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getBooleanOrDefault("usesLocalFilePerTable", false, new Object[0]);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("supportsMixedCaseIdentifiers", false, new Object[0]);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesUpperCaseIdentifiers", false, new Object[0]);
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesLowerCaseIdentifiers", false, new Object[0]);
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesMixedCaseIdentifiers", false, new Object[0]);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("supportsMixedCaseQuotedIdentifiers", false, new Object[0]);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesUpperCaseQuotedIdentifiers", false, new Object[0]);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesLowerCaseQuotedIdentifiers", false, new Object[0]);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getBooleanOrDefault("storesMixedCaseQuotedIdentifiers", false, new Object[0]);
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.getStringOrDefault("getIdentifierQuoteString", " ");
    }

    public String getSQLKeywords() throws SQLException {
        return this.getStringOrDefault("getSQLKeywords", "");
    }

    public String getNumericFunctions() throws SQLException {
        return this.getStringOrDefault("getNumericFunctions", "");
    }

    public String getStringFunctions() throws SQLException {
        return this.getStringOrDefault("getStringFunctions", "");
    }

    public String getSystemFunctions() throws SQLException {
        return this.getStringOrDefault("getSystemFunctions", "");
    }

    public String getTimeDateFunctions() throws SQLException {
        return this.getStringOrDefault("getTimeDateFunctions", "");
    }

    public String getSearchStringEscape() throws SQLException {
        return this.getString("getSearchStringEscape");
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.getString("getExtraNameCharacters");
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.getBooleanOrDefault("supportsAlterTableWithAddColumn", false, new Object[0]);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.getBooleanOrDefault("supportsAlterTableWithDropColumn", false, new Object[0]);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.getBooleanOrDefault("supportsColumnAliasing", false, new Object[0]);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getBooleanOrDefault("nullPlusNonNullIsNull", false, new Object[0]);
    }

    public boolean supportsConvert() throws SQLException {
        return this.getBooleanOrDefault("supportsConvert", false, new Object[0]);
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.getBooleanOrDefault("supportsConvert", false, fromType, toType);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getBooleanOrDefault("supportsTableCorrelationNames", false, new Object[0]);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getBooleanOrDefault("supportsDifferentTableCorrelationNames", false, new Object[0]);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getBooleanOrDefault("supportsExpressionsInOrderBy", false, new Object[0]);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getBooleanOrDefault("supportsOrderByUnrelated", false, new Object[0]);
    }

    public boolean supportsGroupBy() throws SQLException {
        return this.getBooleanOrDefault("supportsGroupBy", false, new Object[0]);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getBooleanOrDefault("supportsGroupByUnrelated", false, new Object[0]);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getBooleanOrDefault("supportsGroupByBeyondSelect", false, new Object[0]);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getBooleanOrDefault("supportsLikeEscapeClause", false, new Object[0]);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getBooleanOrDefault("supportsMultipleResultSets", false, new Object[0]);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getBooleanOrDefault("supportsMultipleTransactions", false, new Object[0]);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getBooleanOrDefault("supportsNonNullableColumns", false, new Object[0]);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.getBooleanOrDefault("supportsMinimumSQLGrammar", false, new Object[0]);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.getBooleanOrDefault("supportsCoreSQLGrammar", false, new Object[0]);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getBooleanOrDefault("supportsExtendedSQLGrammar", false, new Object[0]);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.getBooleanOrDefault("supportsANSI92EntryLevelSQL", false, new Object[0]);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.getBooleanOrDefault("supportsANSI92IntermediateSQL", false, new Object[0]);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getBooleanOrDefault("supportsANSI92FullSQL", false, new Object[0]);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getBooleanOrDefault("supportsIntegrityEnhancementFacility", false, new Object[0]);
    }

    public boolean supportsOuterJoins() throws SQLException {
        return this.getBooleanOrDefault("supportsOuterJoins", false, new Object[0]);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getBooleanOrDefault("supportsFullOuterJoins", false, new Object[0]);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getBooleanOrDefault("supportsLimitedOuterJoins", false, new Object[0]);
    }

    public String getSchemaTerm() throws SQLException {
        return this.getString("getSchemaTerm");
    }

    public String getProcedureTerm() throws SQLException {
        return this.getString("getProcedureTerm");
    }

    public String getCatalogTerm() throws SQLException {
        return this.getString("getCatalogTerm");
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.getBooleanOrDefault("isCatalogAtStart", false, new Object[0]);
    }

    public String getCatalogSeparator() throws SQLException {
        return this.getString("getCatalogSeparator");
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.getBooleanOrDefault("supportsSchemasInDataManipulation", false, new Object[0]);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getBooleanOrDefault("supportsSchemasInProcedureCalls", false, new Object[0]);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsSchemasInTableDefinitions", false, new Object[0]);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsSchemasInIndexDefinitions", false, new Object[0]);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsSchemasInPrivilegeDefinitions", false, new Object[0]);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.getBooleanOrDefault("supportsCatalogsInDataManipulation", false, new Object[0]);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.getBooleanOrDefault("supportsCatalogsInProcedureCalls", false, new Object[0]);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsCatalogsInTableDefinitions", false, new Object[0]);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsCatalogsInIndexDefinitions", false, new Object[0]);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getBooleanOrDefault("supportsCatalogsInPrivilegeDefinitions", false, new Object[0]);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return this.getBooleanOrDefault("supportsPositionedDelete", false, new Object[0]);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getBooleanOrDefault("supportsPositionedUpdate", false, new Object[0]);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getBooleanOrDefault("supportsSelectForUpdate", false, new Object[0]);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.getBooleanOrDefault("supportsStoredProcedures", false, new Object[0]);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getBooleanOrDefault("supportsSubqueriesInComparisons", false, new Object[0]);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getBooleanOrDefault("supportsSubqueriesInExists", false, new Object[0]);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getBooleanOrDefault("supportsSubqueriesInIns", false, new Object[0]);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getBooleanOrDefault("supportsSubqueriesInQuantifieds", false, new Object[0]);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getBooleanOrDefault("supportsCorrelatedSubqueries", false, new Object[0]);
    }

    public boolean supportsUnion() throws SQLException {
        return this.getBooleanOrDefault("supportsUnion", false, new Object[0]);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.getBooleanOrDefault("supportsUnionAll", false, new Object[0]);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getBoolean("supportsOpenCursorsAcrossCommit");
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getBoolean("supportsOpenCursorsAcrossRollback");
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getBoolean("supportsOpenStatementsAcrossCommit");
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getBoolean("supportsOpenStatementsAcrossRollback");
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getIntOrDefault("getMaxBinaryLiteralLength", 0);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.getIntOrDefault("getMaxCharLiteralLength", 0);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxColumnNameLength", 0);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getIntOrDefault("getMaxColumnsInGroupBy", 0);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getIntOrDefault("getMaxColumnsInIndex", 0);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getIntOrDefault("getMaxColumnsInOrderBy", 0);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getIntOrDefault("getMaxColumnsInSelect", 0);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getIntOrDefault("getMaxColumnsInTable", 0);
    }

    public int getMaxConnections() throws SQLException {
        return this.getIntOrDefault("getMaxConnections", 0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxCursorNameLength", 0);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.getIntOrDefault("getMaxIndexLength", 0);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxSchemaNameLength", 0);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxProcedureNameLength", 0);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxCatalogNameLength", 0);
    }

    public int getMaxRowSize() throws SQLException {
        return this.getIntOrDefault("getMaxRowSize", 0);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getBooleanOrDefault("doesMaxRowSizeIncludeBlobs", false, new Object[0]);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.getIntOrDefault("getMaxStatementLength", 0);
    }

    public int getMaxStatements() throws SQLException {
        return this.getIntOrDefault("getMaxStatements", 0);
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxTableNameLength", 0);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getIntOrDefault("getMaxTablesInSelect", 0);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getIntOrDefault("getMaxUserNameLength", 0);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getInt("getDefaultTransactionIsolation");
    }

    public boolean supportsTransactions() throws SQLException {
        return this.getBooleanOrDefault("supportsTransactions", false, new Object[0]);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.getBooleanOrDefault("supportsTransactionIsolationLevel", false, level);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getBooleanOrDefault("supportsDataDefinitionAndDataManipulationTransactions", false, new Object[0]);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getBooleanOrDefault("supportsDataManipulationTransactionsOnly", false, new Object[0]);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getBooleanOrDefault("dataDefinitionCausesTransactionCommit", false, new Object[0]);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getBooleanOrDefault("dataDefinitionIgnoredInTransactions", false, new Object[0]);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.getResultSet("getProcedures", catalog, schemaPattern, procedureNamePattern);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.getResultSet("getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.getResultSet("getTables", catalog, schemaPattern, tableNamePattern, types);
    }

    public ResultSet getSchemas() throws SQLException {
        return this.getResultSet("getSchemas", new Object[0]);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.getResultSet("getCatalogs", new Object[0]);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.getResultSet("getTableTypes", new Object[0]);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getResultSet("getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.metaData.getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getResultSet("getTablePrivileges", catalog, schemaPattern, tableNamePattern);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getResultSet("getBestRowIdentifier", catalog, schema, table, scope, nullable);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getResultSet("getVersionColumns", catalog, schema, table);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.getResultSet("getPrimaryKeys", catalog, schema, table);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getResultSet("getImportedKeys", catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getResultSet("getExportedKeys", catalog, schema, table);
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getResultSet("getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.getResultSet("getTypeInfo", new Object[0]);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getResultSet("getIndexInfo", catalog, schema, table, unique, approximate);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return this.getBooleanOrDefault("supportsResultSetType", false, type);
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.getBooleanOrDefault("supportsResultSetConcurrency", false, type, concurrency);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("ownUpdatesAreVisible", false, type);
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("ownDeletesAreVisible", false, type);
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("ownInsertsAreVisible", false, type);
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("othersUpdatesAreVisible", false, type);
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("othersDeletesAreVisible", false, type);
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.getBooleanOrDefault("othersInsertsAreVisible", false, type);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return this.getBooleanOrDefault("updatesAreDetected", false, type);
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return this.getBooleanOrDefault("deletesAreDetected", false, type);
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return this.getBooleanOrDefault("insertsAreDetected", false, type);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return this.getBooleanOrDefault("supportsBatchUpdates", false, new Object[0]);
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.getResultSet("getUDTs", catalog, schemaPattern, typeNamePattern, types);
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.get("getConnection", new Object[0]);
    }

    public boolean supportsSavepoints() throws SQLException {
        return this.getBooleanOrDefault("supportsSavepoints", false, new Object[0]);
    }

    public boolean supportsNamedParameters() throws SQLException {
        return this.getBooleanOrDefault("supportsNamedParameters", false, new Object[0]);
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.getBooleanOrDefault("supportsMultipleOpenResults", false, new Object[0]);
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.getBooleanOrDefault("supportsGetGeneratedKeys", false, new Object[0]);
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getResultSet("getSuperTypes", catalog, schemaPattern, typeNamePattern);
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getResultSet("getSuperTables", catalog, schemaPattern, tableNamePattern);
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getResultSet("getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return this.getBooleanOrDefault("supportsResultSetHoldability", false, holdability);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.getInt("getResultSetHoldability");
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.getInt("getDatabaseMajorVersion");
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.getInt("getDatabaseMinorVersion");
    }

    public int getJDBCMajorVersion() throws SQLException {
        return this.getInt("getJDBCMajorVersion");
    }

    public int getJDBCMinorVersion() throws SQLException {
        return this.getInt("getJDBCMinorVersion");
    }

    public int getSQLStateType() throws SQLException {
        return this.getInt("getSQLStateType");
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return this.getBoolean("locatorsUpdateCopy");
    }

    public boolean supportsStatementPooling() throws SQLException {
        return this.getBooleanOrDefault("supportsStatementPooling", false, new Object[0]);
    }

    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return (RowIdLifetime)((Object)this.get("getRowIdLifetime", new Object[0]));
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getResultSet("getSchemas", catalog, schemaPattern);
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.getBooleanOrDefault("supportsStoredFunctionsUsingCallSyntax", false, new Object[0]);
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.getBooleanOrDefault("autoCommitFailureClosesAllResultSets", false, new Object[0]);
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getResultSet("getClientInfoProperties", new Object[0]);
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getResultSet("getFunctions", catalog, schemaPattern, functionNamePattern);
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getResultSet("getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getResultSet("getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return this.getBooleanOrDefault("generatedKeyAlwaysReturned", false, new Object[0]);
    }

    public long getMaxLogicalLobSize() throws SQLException {
        return this.getIntOrDefault("getMaxLogicalLobSize", 0);
    }

    public boolean supportsRefCursors() throws SQLException {
        return this.getBooleanOrDefault("supportsRefCursors", false, new Object[0]);
    }

    private ResultSet getResultSet(String methodName, Object ... args) throws SQLException {
        return (ResultSet)this.get(methodName, args);
    }

    private boolean getBoolean(String methodName) throws SQLException {
        return (Boolean)this.get(methodName, new Object[0]);
    }

    private boolean getBooleanOrDefault(String methodName, boolean defaultValue, Object ... args) throws SQLException {
        return (Boolean)this.getOrDefault(methodName, defaultValue, args);
    }

    private int getInt(String methodName) throws SQLException {
        return (Integer)this.get(methodName, new Object[0]);
    }

    private int getIntOrDefault(String methodName, int defaultValue) throws SQLException {
        return (Integer)this.getOrDefault(methodName, defaultValue, new Object[0]);
    }

    private String getString(String methodName) throws SQLException {
        return (String)this.get(methodName, new Object[0]);
    }

    private String getStringOrDefault(String methodName, String defaultValue) throws SQLException {
        return (String)this.getOrDefault(methodName, defaultValue, new Object[0]);
    }

    private Object getOrDefault(String methodName, Object defaultValue, Object ... args) throws SQLException {
        if (this.sqlLine.getOpts().getStrictJdbc()) {
            return this.get(methodName, args);
        }
        try {
            return this.sqlLine.getReflector().invoke((Object)this.metaData, methodName, args);
        }
        catch (Exception e) {
            Throwable t;
            Throwable throwable = t = e.getCause() == null ? e : e.getCause();
            if (t instanceof SQLFeatureNotSupportedException || METHOD_NOT_SUPPORTED.equalsIgnoreCase(t.getMessage())) {
                return defaultValue;
            }
            throw t instanceof SQLException ? (SQLException)t : new SQLException(t);
        }
    }

    private Object get(String methodName, Object ... args) throws SQLException {
        try {
            return this.sqlLine.getReflector().invoke((Object)this.metaData, methodName, args);
        }
        catch (Exception e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            throw t instanceof SQLException ? (SQLException)t : new SQLException(t);
        }
    }
}

