/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sqlline.Dialect;
import sqlline.SqlCompleter;

public enum BuiltInDialect implements Dialect
{
    DEFAULT("SQLLineDefaultDialect", '\"', '\"', "--"),
    H2("H2", '\"', '\"', "--", "//"),
    MYSQL("MySQL", '`', '`', "-- ", "--\t", "--\n", "#"),
    PHOENIX("Phoenix", '\"', '\"', "--", "//");

    private final String databaseName;
    private final Set<String> oneLineComments;
    private final Set<String> keywords;
    private final boolean storesUpperCaseIdentifier;
    private final char openQuote;
    private final char closeQuote;

    private BuiltInDialect(String databaseName, char openQuote, char closeQuote, String ... comments) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.oneLineComments = Collections.unmodifiableSet(Stream.of(comments).collect(Collectors.toSet()));
        this.storesUpperCaseIdentifier = false;
        this.keywords = Collections.emptySet();
    }

    @Override
    public boolean containsKeyword(String keyword) {
        return this.keywords.contains(keyword) || DEFAULT_KEYWORD_SET.contains(keyword);
    }

    @Override
    public Set<String> getOneLineComments() {
        return this.oneLineComments;
    }

    @Override
    public char getOpenQuote() {
        return this.openQuote;
    }

    @Override
    public char getCloseQuote() {
        return this.closeQuote;
    }

    @Override
    public boolean isUpper() {
        return this.storesUpperCaseIdentifier;
    }

    static Set<String> initDefaultKeywordSet() {
        try {
            TreeSet<String> defaultKeywordSet = new TreeSet<String>();
            String keywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream("sql-keywords.properties"), StandardCharsets.UTF_8)).readLine();
            keywords = keywords + "," + keywords.toLowerCase(Locale.ROOT);
            StringTokenizer tok = new StringTokenizer(keywords, ",");
            while (tok.hasMoreTokens()) {
                defaultKeywordSet.add(tok.nextToken());
            }
            return Collections.unmodifiableSet(defaultKeywordSet);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    static BuiltInDialect valueOf(String databaseName, boolean ignoreCase) {
        if (databaseName == null) {
            return DEFAULT;
        }
        for (BuiltInDialect dialect : BuiltInDialect.values()) {
            if (dialect == DEFAULT || databaseName.length() < dialect.databaseName.length() || !databaseName.regionMatches(ignoreCase, 0, dialect.databaseName, 0, dialect.databaseName.length())) continue;
            return dialect;
        }
        return DEFAULT;
    }
}

