/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.drill.exec.udfs.DateUtilFunctions;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtils {
    @Test
    public void testDateFromString() {
        LocalDate testDate = LocalDate.of(2022, 3, 14);
        Assert.assertEquals((Object)testDate, (Object)DateUtilFunctions.getDateFromString((String)"2022-03-14"));
        Assert.assertEquals((Object)testDate, (Object)DateUtilFunctions.getDateFromString((String)"3/14/2022"));
        Assert.assertEquals((Object)testDate, (Object)DateUtilFunctions.getDateFromString((String)"14/03/2022", (boolean)true));
        Assert.assertEquals((Object)testDate, (Object)DateUtilFunctions.getDateFromString((String)"2022/3/14"));
        Assert.assertNull((Object)DateUtilFunctions.getDateFromString(null));
        Assert.assertNull((Object)DateUtilFunctions.getDateFromString((String)"1975-13-56"));
        Assert.assertNull((Object)DateUtilFunctions.getDateFromString((String)"1975-1s"));
    }

    @Test
    public void testTimestampFromString() {
        LocalDateTime testNoSecondFragments = LocalDateTime.of(2022, 4, 19, 17, 3, 46);
        LocalDateTime test1Digit = LocalDateTime.of(2022, 4, 19, 17, 3, 46, 1000000);
        LocalDateTime test2Digit = LocalDateTime.of(2022, 4, 19, 17, 3, 46, 13000000);
        LocalDateTime test3Digit = LocalDateTime.of(2022, 4, 19, 17, 3, 46, 342000000);
        Assert.assertEquals((Object)testNoSecondFragments, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19 17:03:46"));
        Assert.assertEquals((Object)testNoSecondFragments, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46"));
        Assert.assertEquals((Object)testNoSecondFragments, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46.000Z"));
        Assert.assertEquals((Object)test1Digit, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46.1Z"));
        Assert.assertEquals((Object)test1Digit, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46.001Z"));
        Assert.assertEquals((Object)test2Digit, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46.13Z"));
        Assert.assertEquals((Object)test2Digit, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19T17:03:46.013Z"));
        Assert.assertEquals((Object)test3Digit, (Object)DateUtilFunctions.getTimestampFromString((String)"2022-04-19 17:03:46.342Z"));
        Assert.assertNull((Object)DateUtilFunctions.getTimestampFromString(null));
        Assert.assertNull((Object)DateUtilFunctions.getTimestampFromString((String)""));
    }
}

