/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestPhoneticFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestPhoneticFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testSoundex() throws Exception {
        String result = this.queryBuilder().sql("select soundex('jaime') as soundex from (values(1))").singletonString();
        Assert.assertEquals((Object)"J500", (Object)result);
    }

    @Test
    public void testCaverphone1() throws Exception {
        String result = this.queryBuilder().sql("SELECT caverphone1('jaime') as caverphone FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"YM1111", (Object)result);
    }

    @Test
    public void testCaverphone2() throws Exception {
        String result = this.queryBuilder().sql("SELECT caverphone2('steve') as caverphone FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"STF1111111", (Object)result);
    }

    @Test
    public void testCologne() throws Exception {
        String result = this.queryBuilder().sql("SELECT cologne_phonetic('steve') AS CP FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"823", (Object)result);
    }

    @Test
    public void testMatchRatingEncoder() throws Exception {
        String result = this.queryBuilder().sql("SELECT match_rating_encoder('Boston') AS MR FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"BSTN", (Object)result);
    }

    @Test
    public void testNYSIIS() throws Exception {
        String result = this.queryBuilder().sql("SELECT nysiis('Boston') AS ny FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"BASTAN", (Object)result);
    }

    @Test
    public void testRefinedSoundex() throws Exception {
        String result = this.queryBuilder().sql("SELECT refined_soundex('Boston') AS rs FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"B103608", (Object)result);
    }

    @Test
    public void testMetaphone() throws Exception {
        String result = this.queryBuilder().sql("SELECT metaphone('Phoenix') AS meta FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"FNKS", (Object)result);
    }

    @Test
    public void testDoubleMetaphone() throws Exception {
        String result = this.queryBuilder().sql("SELECT double_metaphone('Phoenix') AS meta FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"FNKS", (Object)result);
        result = this.queryBuilder().sql("SELECT double_metaphone('') AS meta FROM (VALUES(1))").singletonString();
        Assert.assertEquals((Object)"", (Object)result);
    }
}

