/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.udfs.NearestDateUtils;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestNearestDateFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestNearestDateFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testNearestDate() throws Exception {
        String query = "SELECT nearestDate( TO_TIMESTAMP('2019-02-01 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'YEAR') AS nearest_year, nearestDate( TO_TIMESTAMP('2019-02-01 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'QUARTER') AS nearest_quarter, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'MONTH') AS nearest_month, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'DAY') AS nearest_day, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'WEEK_SUNDAY') AS nearest_week_sunday, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'WEEK_MONDAY') AS nearest_week_monday, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'HOUR') AS nearest_hour, nearestDate( TO_TIMESTAMP('2019-02-15 07:42:00', 'yyyy-MM-dd HH:mm:ss'), 'HALF_HOUR') AS nearest_half_hour, nearestDate( TO_TIMESTAMP('2019-02-15 07:48:00', 'yyyy-MM-dd HH:mm:ss'), 'QUARTER_HOUR') AS nearest_quarter_hour, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'MINUTE') AS nearest_minute, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:22', 'yyyy-MM-dd HH:mm:ss'), 'HALF_MINUTE') AS nearest_30second, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:22', 'yyyy-MM-dd HH:mm:ss'), 'QUARTER_MINUTE') AS nearest_15second, nearestDate( TO_TIMESTAMP('2019-02-15 07:22:31', 'yyyy-MM-dd HH:mm:ss'), 'SECOND') AS nearest_second FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"nearest_year", "nearest_quarter", "nearest_month", "nearest_day", "nearest_week_sunday", "nearest_week_monday", "nearest_hour", "nearest_half_hour", "nearest_quarter_hour", "nearest_minute", "nearest_30second", "nearest_15second", "nearest_second"}).baselineValues(new Object[]{LocalDateTime.of(2019, 1, 1, 0, 0, 0), LocalDateTime.of(2019, 1, 1, 0, 0, 0), LocalDateTime.of(2019, 2, 1, 0, 0, 0), LocalDateTime.of(2019, 2, 15, 0, 0, 0), LocalDateTime.of(2019, 2, 10, 0, 0, 0), LocalDateTime.of(2019, 2, 11, 0, 0, 0), LocalDateTime.of(2019, 2, 15, 7, 0, 0), LocalDateTime.of(2019, 2, 15, 7, 30, 0), LocalDateTime.of(2019, 2, 15, 7, 45, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 15), LocalDateTime.of(2019, 2, 15, 7, 22, 31)}).go();
    }

    @Test
    public void testNearestDateWithTimestamp() throws Exception {
        String query = "SELECT nearestDate( '2019-02-01 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'YEAR') AS nearest_year, nearestDate( '2019-02-01 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'QUARTER') AS nearest_quarter, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'MONTH') AS nearest_month, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'DAY') AS nearest_day, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'WEEK_SUNDAY') AS nearest_week_sunday, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'WEEK_MONDAY') AS nearest_week_monday, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'HOUR') AS nearest_hour, nearestDate( '2019-02-15 07:42:00', 'yyyy-MM-dd HH:mm:ss', 'HALF_HOUR') AS nearest_half_hour, nearestDate( '2019-02-15 07:48:00', 'yyyy-MM-dd HH:mm:ss', 'QUARTER_HOUR') AS nearest_quarter_hour, nearestDate( '2019-02-15 07:22:00', 'yyyy-MM-dd HH:mm:ss', 'MINUTE') AS nearest_minute, nearestDate( '2019-02-15 07:22:22', 'yyyy-MM-dd HH:mm:ss', 'HALF_MINUTE') AS nearest_30second, nearestDate( '2019-02-15 07:22:22', 'yyyy-MM-dd HH:mm:ss', 'QUARTER_MINUTE') AS nearest_15second, nearestDate( '2019-02-15 07:22:31', 'yyyy-MM-dd HH:mm:ss', 'SECOND') AS nearest_second FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"nearest_year", "nearest_quarter", "nearest_month", "nearest_day", "nearest_week_sunday", "nearest_week_monday", "nearest_hour", "nearest_half_hour", "nearest_quarter_hour", "nearest_minute", "nearest_30second", "nearest_15second", "nearest_second"}).baselineValues(new Object[]{LocalDateTime.of(2019, 1, 1, 0, 0, 0), LocalDateTime.of(2019, 1, 1, 0, 0, 0), LocalDateTime.of(2019, 2, 1, 0, 0, 0), LocalDateTime.of(2019, 2, 15, 0, 0, 0), LocalDateTime.of(2019, 2, 10, 0, 0, 0), LocalDateTime.of(2019, 2, 11, 0, 0, 0), LocalDateTime.of(2019, 2, 15, 7, 0, 0), LocalDateTime.of(2019, 2, 15, 7, 30, 0), LocalDateTime.of(2019, 2, 15, 7, 45, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 0), LocalDateTime.of(2019, 2, 15, 7, 22, 15), LocalDateTime.of(2019, 2, 15, 7, 22, 31)}).go();
    }

    @Test
    public void testReadException() throws Exception {
        String query = "SELECT nearestDate( TO_TIMESTAMP('2019-02-01 07:22:00', 'yyyy-MM-dd HH:mm:ss'), 'BAD_DATE') AS nearest_year FROM (VALUES(1))";
        try {
            TestNearestDateFunctions.run((String)query, (Object[])new Object[0]);
            Assert.fail();
        }
        catch (DrillRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("[BAD_DATE] is not a valid time statement. Expecting: " + Arrays.asList(NearestDateUtils.TimeInterval.values())));
        }
    }
}

