/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.drill.MaskingRule;
import org.apache.drill.StringChanger;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StringChangerTest {
    private static final ClassLoader classLoader = StringChangerTest.class.getClassLoader();

    @Test
    public void shouldDoNothingIfAbsentConfig() {
        String missingConfigPath = "src/test/resources/missing-config.json";
        Executable sut = () -> {
            StringChanger stringChanger = new StringChanger("src/test/resources/missing-config.json");
            String expected = "Expected string";
            String result = stringChanger.changeString(expected);
            Assertions.assertEquals((Object)expected, (Object)result);
        };
        Assertions.assertDoesNotThrow((Executable)sut);
    }

    @Test
    public void shouldNotFailOnEmptyFile() {
        String emptyConfigPath = classLoader.getResource("empty-config.json").getFile();
        Executable sut = () -> new StringChanger(emptyConfigPath);
        Assertions.assertDoesNotThrow((Executable)sut);
    }

    @Test
    public void throwExceptionIfFileHasBadJsonFormat() {
        String brokenJsonConfigPath = classLoader.getResource("broken-json-config.json").getFile();
        Executable sut = () -> new StringChanger(brokenJsonConfigPath);
        Class<RuntimeException> expectedException = RuntimeException.class;
        Class<JsonMappingException> expectedCause = JsonMappingException.class;
        Throwable exceptionCause = Assertions.assertThrows(expectedException, (Executable)sut).getCause();
        Assertions.assertEquals(expectedCause, exceptionCause.getClass());
    }

    @Test
    public void shouldApplyAllRules() {
        String noRulesConfigPath = classLoader.getResource("no-rules-config.json").getFile();
        MaskingRule[] ruleMocks = this.createRuleMocks(true);
        try (MockedConstruction objectMapper = Mockito.mockConstruction(ObjectMapper.class, (mock, context) -> Mockito.when((Object)((MaskingRule[])mock.readValue((File)ArgumentMatchers.any(File.class), (Class)ArgumentMatchers.eq(MaskingRule[].class)))).thenReturn((Object)ruleMocks));){
            StringChanger cut = new StringChanger(noRulesConfigPath);
            cut.changeString("Some string");
            for (MaskingRule rule : ruleMocks) {
                ((MaskingRule)Mockito.verify((Object)rule, (VerificationMode)Mockito.times((int)1))).apply(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq(null));
            }
        }
    }

    @Test
    public void shouldNotUseRulesWithNullSearchString() {
        String noRulesConfigPath = classLoader.getResource("no-rules-config.json").getFile();
        MaskingRule[] ruleMocks = this.createRuleMocks(false);
        try (MockedConstruction objectMapper = Mockito.mockConstruction(ObjectMapper.class, (mock, context) -> Mockito.when((Object)((MaskingRule[])mock.readValue((File)ArgumentMatchers.any(File.class), (Class)ArgumentMatchers.eq(MaskingRule[].class)))).thenReturn((Object)ruleMocks));){
            StringChanger cut = new StringChanger(noRulesConfigPath);
            cut.changeString("Some string");
            for (MaskingRule rule : ruleMocks) {
                ((MaskingRule)Mockito.verify((Object)rule, (VerificationMode)Mockito.never())).apply(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
            }
        }
    }

    @Test
    public void shouldDoNothingIfNoRules() {
        String noRulesConfigPath = classLoader.getResource("no-rules-config.json").getFile();
        StringChanger cut = new StringChanger(noRulesConfigPath);
        String stringToChange = "Some amazing message";
        String result = cut.changeString("Some amazing message");
        Assertions.assertEquals((Object)"Some amazing message", (Object)result);
    }

    @Test
    public void shouldApplyUserNameToRule() {
        MaskingRule[] ruleMocks = this.createRuleMocks(true);
        String noRulesConfigPath = classLoader.getResource("no-rules-config.json").getFile();
        String userName = "expectedUserName";
        try (MockedConstruction objectMapper = Mockito.mockConstruction(ObjectMapper.class, (mock, context) -> Mockito.when((Object)((MaskingRule[])mock.readValue((File)ArgumentMatchers.any(File.class), (Class)ArgumentMatchers.eq(MaskingRule[].class)))).thenReturn((Object)ruleMocks));){
            StringChanger cut = new StringChanger(noRulesConfigPath);
            cut.changeString("Some string", "expectedUserName");
            for (MaskingRule rule : ruleMocks) {
                ((MaskingRule)Mockito.verify((Object)rule, (VerificationMode)Mockito.times((int)1))).apply(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"expectedUserName"));
            }
        }
    }

    private MaskingRule[] createRuleMocks(boolean activeRules) {
        MaskingRule[] ruleMocks = new MaskingRule[3];
        for (int count = 0; count < ruleMocks.length; ++count) {
            MaskingRule ruleMock = (MaskingRule)Mockito.mock(MaskingRule.class);
            Mockito.when((Object)ruleMock.apply(ArgumentMatchers.anyString(), (String)Mockito.nullable(String.class))).thenReturn((Object)"stub");
            if (activeRules) {
                Mockito.when((Object)ruleMock.isActive()).thenReturn((Object)true);
            }
            ruleMocks[count] = ruleMock;
        }
        return ruleMocks;
    }
}

