/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.drill.MaskingRule;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public class MaskingRuleTest {
    private static final ClassLoader classLoader = MaskingRuleTest.class.getClassLoader();

    @Test
    public void canBeUsedToDeserializeJsonConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        File jsonConfig = new File(classLoader.getResource("test-config.json").getFile());
        ThrowingSupplier sut = () -> (MaskingRule[])objectMapper.readValue(jsonConfig, MaskingRule[].class);
        MaskingRule[] maskingRules = (MaskingRule[])Assertions.assertDoesNotThrow((ThrowingSupplier)sut);
        Assert.assertTrue((maskingRules.length == 10 ? 1 : 0) != 0);
    }

    @Test
    public void shouldChangeMultilineString() {
        MaskingRule cut = new MaskingRule("password", "secret");
        String stringToChange = "1st line with password\n2nd line with password\n3d line with password";
        String expectedString = "1st line with secret\n2nd line with secret\n3d line with secret";
        String result = cut.apply("1st line with password\n2nd line with password\n3d line with password", null);
        Assert.assertEquals((Object)"1st line with secret\n2nd line with secret\n3d line with secret", (Object)result);
    }

    @Test
    public void doNothingIfSearchStringIsNotFound() {
        String replaceString = "***";
        MaskingRule cut = new MaskingRule("password", "***");
        String stringToChange = "Name Surname";
        String result = cut.apply("Name Surname", null);
        Assert.assertEquals((Object)"Name Surname", (Object)result);
    }

    @Test
    public void shouldWorkWithRegexSearchString() {
        String replaceString = "secret";
        MaskingRule cut = new MaskingRule("[a-zA-Z.]@[a-zA-Z.]", "secret");
        String stringToChange = "User email: name.surname@mail.com";
        String result = cut.apply("User email: name.surname@mail.com", null);
        Assert.assertFalse((boolean)result.contains("password"));
        Assert.assertTrue((boolean)result.contains("secret"));
    }

    @Test
    public void shouldMaskAllSearchOccurrence() {
        String replaceString = "secret";
        MaskingRule cut = new MaskingRule("[pasword]{8}", "secret");
        String stringToChange = "Many password, password, password";
        String result = cut.apply("Many password, password, password", null);
        Assert.assertFalse((boolean)result.contains("password"));
        Assert.assertTrue((boolean)result.contains("secret"));
    }

    @Test
    public void throwExceptionOnInvalidRegexSearchString() {
        String invalidRegex = "[\\]";
        Executable cut = () -> new MaskingRule("[\\]");
        Class<IllegalArgumentException> expectedException = IllegalArgumentException.class;
        Assertions.assertThrows(expectedException, (Executable)cut);
    }

    @Test
    public void shouldRemoveSearchStringOnEmptyReplaceString() {
        String search = "user.email@mail.com";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "");
        String stringToChange = "User email: user.email@mail.com";
        String expectedString = "User email: ";
        String result = cut.apply("User email: user.email@mail.com", null);
        Assert.assertEquals((Object)"User email: ", (Object)result);
    }

    @Test
    public void shouldNotChangeStringOnEmptySearch() {
        String replaceString = "magic";
        MaskingRule cut = new MaskingRule("", "magic");
        String stringToChange = "This string shouldn't be changed";
        String result = cut.apply("This string shouldn't be changed", null);
        Assert.assertEquals((Object)"This string shouldn't be changed", (Object)result);
    }

    @Test
    public void shouldChangeChangeStringForMatchedUser() {
        String search = "user.email@mail.com";
        String replaceString = "***secret email***";
        String userName = "secretUser";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "***secret email***", "secretUser");
        String stringToChange = "User email: user.email@mail.com";
        String expectedString = "User email: ***secret email***";
        String userToMatch = new String("secretUser");
        String result = cut.apply("User email: user.email@mail.com", userToMatch);
        Assert.assertEquals((Object)"User email: ***secret email***", (Object)result);
    }

    @Test
    public void shouldNotChangeChangeStringForUnmatchedUser() {
        String search = "user.email@mail.com";
        String replaceString = "***secret email***";
        String userName = "secretUser";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "***secret email***", "secretUser");
        String stringToChange = "User email: user.email@mail.com";
        String otherUserName = "otherSecretUser";
        String result = cut.apply("User email: user.email@mail.com", "otherSecretUser");
        Assert.assertEquals((Object)"User email: user.email@mail.com", (Object)result);
    }

    @Test
    public void shouldApplyFilterOnIncludeUserWithRegex() {
        String search = "user.email@mail.com";
        String replaceString = "***secret email***";
        String userName = ".*User";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "***secret email***", ".*User");
        String stringToChange = "User email: user.email@mail.com";
        String expectedString = "User email: ***secret email***";
        String userToMatch = new String(".*User");
        String result = cut.apply("User email: user.email@mail.com", userToMatch);
        Assert.assertEquals((Object)"User email: ***secret email***", (Object)result);
    }

    @Test
    public void shouldNotApplyFilterOnExcludedUserWithRegex() {
        String search = "user.email@mail.com";
        String replaceString = "***secret email***";
        String userNamePatternToExclude = "mapr.*";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "***secret email***", null, "mapr.*");
        String stringToChange = "User email: user.email@mail.com";
        String userToTest = "maprUser";
        String result = cut.apply("User email: user.email@mail.com", "maprUser");
        Assert.assertEquals((Object)"User email: user.email@mail.com", (Object)result);
    }

    @Test
    public void shouldNotApplyFilterOnExcludedUserWithRegexDespiteIncludedUser() {
        String search = "user.email@mail.com";
        String replaceString = "***secret email***";
        String userNamePatternToInclude = "maprUser";
        String userNamePatternToExclude = "mapr.*";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "***secret email***", "maprUser", "mapr.*");
        String stringToChange = "User email: user.email@mail.com";
        String userToTest = "maprUser";
        String result = cut.apply("User email: user.email@mail.com", "maprUser");
        Assert.assertEquals((Object)"User email: user.email@mail.com", (Object)result);
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionOnInvalidIncludeUserRegex() {
        String invalidRegex = "**";
        Class<IllegalArgumentException> expectedException = IllegalArgumentException.class;
        Executable sut = () -> new MaskingRule(null, null, "**", null);
        Assertions.assertThrows(expectedException, (Executable)sut);
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionOnInvalidExcludeUserRegex() {
        String invalidRegex = "**";
        Class<IllegalArgumentException> expectedException = IllegalArgumentException.class;
        Executable sut = () -> new MaskingRule(null, null, null, "**");
        Assertions.assertThrows(expectedException, (Executable)sut);
    }
}

