/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

@JsonIgnoreProperties(value={"description"})
public class MaskingRule
implements BiFunction<String, String, String> {
    private Pattern search;
    private String replace;
    private Pattern includeUserPattern;
    private Pattern excludeUserPattern;

    public MaskingRule(String search) {
        this(search, null, null, null);
    }

    public MaskingRule(String search, String replace) {
        this(search, replace, null, null);
    }

    public MaskingRule(String search, String replace, String includeUser) {
        this(search, replace, includeUser, null);
    }

    public MaskingRule(@JsonProperty(value="search") String search, @JsonProperty(value="replace") String replace, @JsonProperty(value="includeUser") String includeUser, @JsonProperty(value="excludeUser") String excludeUser) {
        this.compileSearchPattern(search);
        this.setReplace(replace);
        this.compileIncludeUserPattern(includeUser);
        this.compileExcludeUserPattern(excludeUser);
    }

    @Override
    public String apply(String str, String username) {
        if (this.isActive() && this.userShouldBeMasked(username)) {
            return this.search.matcher(str).replaceAll(this.replace);
        }
        return str;
    }

    private void compileSearchPattern(String search) {
        try {
            if (!Strings.isNullOrEmpty((String)search)) {
                this.search = Pattern.compile(search);
            }
        }
        catch (PatternSyntaxException patternException) {
            throw new IllegalArgumentException("Search string for MaskingRule should be a valid regular expression");
        }
    }

    private boolean userShouldBeMasked(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            return true;
        }
        if (this.excludeUserPattern != null && this.excludeUserPattern.matcher(username).matches()) {
            return false;
        }
        if (this.includeUserPattern != null) {
            return this.includeUserPattern.matcher(username).matches();
        }
        return true;
    }

    private void setReplace(String replace) {
        this.replace = replace == null ? "" : replace;
    }

    private void compileIncludeUserPattern(String includeUser) {
        try {
            if (!Strings.isNullOrEmpty((String)includeUser)) {
                this.includeUserPattern = Pattern.compile(includeUser);
            }
        }
        catch (PatternSyntaxException patternException) {
            throw new IllegalArgumentException("IncludeUser string for MaskingRule should be a valid regular expression");
        }
    }

    private void compileExcludeUserPattern(String excludeUser) {
        try {
            if (!Strings.isNullOrEmpty((String)excludeUser)) {
                this.excludeUserPattern = Pattern.compile(excludeUser);
            }
        }
        catch (PatternSyntaxException patternException) {
            throw new IllegalArgumentException("ExcludeUser string for MaskingRule should be a valid regular expression");
        }
    }

    public boolean isActive() {
        return Objects.nonNull(this.search);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaskingRule that = (MaskingRule)o;
        return Objects.equals(this.search, that.search) && this.replace.equals(that.replace) && Objects.equals(this.includeUserPattern, that.includeUserPattern) && Objects.equals(this.excludeUserPattern, that.excludeUserPattern);
    }

    public int hashCode() {
        return Objects.hash(this.search, this.replace, this.includeUserPattern, this.excludeUserPattern);
    }
}

