/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskingRule
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(MaskingRule.class);
    private static final String DEFAULT_RULE_DESCRIPTION = "Empty rule description";
    private String description;
    private Pattern search;
    private String replace;

    public MaskingRule(String search, String replace) {
        this(search, replace, null);
    }

    public MaskingRule(@JsonProperty(value="search") String search, @JsonProperty(value="replace") String replace, @JsonProperty(value="description") String description) {
        this.setSearch(search);
        this.setReplace(replace);
        this.setDescription(description);
    }

    @Override
    public String apply(String str) {
        if (this.search == null) {
            logger.debug("Masking rule '{}' wasn't applied since search string is empty or null.", (Object)this.description);
            return str;
        }
        return this.search.matcher(str).replaceAll(this.replace);
    }

    private void setSearch(String search) {
        if (Strings.isNullOrEmpty((String)search)) {
            this.search = null;
            return;
        }
        try {
            this.search = Pattern.compile(search);
        }
        catch (PatternSyntaxException patternException) {
            throw new IllegalArgumentException("Search string for MaskingRule should be a valid regular expression");
        }
    }

    private void setReplace(String replace) {
        this.replace = replace == null ? "" : replace;
    }

    private void setDescription(String description) {
        this.description = Strings.isNullOrEmpty((String)description) ? DEFAULT_RULE_DESCRIPTION : description;
    }

    public String getSearch() {
        return this.search == null ? null : this.search.pattern();
    }

    public String getReplace() {
        return this.replace;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaskingRule that = (MaskingRule)o;
        return this.description.equals(that.description) && Objects.equals(this.search, that.search) && this.replace.equals(that.replace);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.search, this.replace);
    }
}

