/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.drill.MaskingRule;
import org.apache.drill.StringChanger;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StringChangerTest {
    @Test
    public void failOnInvalidFilePath() {
        String invalidFilePath = "folder1/.|?,{([";
        Executable sut = () -> new StringChanger("folder1/.|?,{([");
        Assertions.assertThrows(Exception.class, (Executable)sut);
    }

    @Test
    public void failOnMissingFile() {
        Executable sut = () -> new StringChanger("src/test/resources/missing-config.json");
        Class<RuntimeException> expectedException = RuntimeException.class;
        Class<FileNotFoundException> expectedCause = FileNotFoundException.class;
        Throwable exceptionCause = Assertions.assertThrows(expectedException, (Executable)sut).getCause();
        Assertions.assertEquals(expectedCause, exceptionCause.getClass());
    }

    @Test
    public void doNotFailOnEmptyFile() {
        Executable sut = () -> new StringChanger("src/test/resources/empty-config.json");
        Assertions.assertDoesNotThrow((Executable)sut);
    }

    @Test
    public void throwExceptionIfFileHasBadJsonFormat() {
        Executable sut = () -> new StringChanger("src/test/resources/broken-json-config.json");
        Class<RuntimeException> expectedException = RuntimeException.class;
        Class<JsonMappingException> expectedCause = JsonMappingException.class;
        Throwable exceptionCause = Assertions.assertThrows(expectedException, (Executable)sut).getCause();
        Assertions.assertEquals(expectedCause, exceptionCause.getClass());
    }

    @Test
    public void applyAllRules() {
        MaskingRule[] ruleMocks = this.createRuleMocks(true);
        try (MockedConstruction objectMapper = Mockito.mockConstruction(ObjectMapper.class, (mock, context) -> Mockito.when((Object)((MaskingRule[])mock.readValue((File)ArgumentMatchers.any(File.class), (Class)ArgumentMatchers.eq(MaskingRule[].class)))).thenReturn((Object)ruleMocks));){
            StringChanger cut = new StringChanger("src/test/resources/no-rules-config.json");
            cut.changeString("Some string");
            for (MaskingRule rule : ruleMocks) {
                ((MaskingRule)Mockito.verify((Object)rule, (VerificationMode)Mockito.times((int)1))).apply(ArgumentMatchers.anyString());
            }
        }
    }

    @Test
    public void doNotUseRulesWithNullSearchString() {
        MaskingRule[] ruleMocks = this.createRuleMocks(false);
        try (MockedConstruction objectMapper = Mockito.mockConstruction(ObjectMapper.class, (mock, context) -> Mockito.when((Object)((MaskingRule[])mock.readValue((File)ArgumentMatchers.any(File.class), (Class)ArgumentMatchers.eq(MaskingRule[].class)))).thenReturn((Object)ruleMocks));){
            StringChanger cut = new StringChanger("src/test/resources/no-rules-config.json");
            cut.changeString("Some string");
            for (MaskingRule rule : ruleMocks) {
                ((MaskingRule)Mockito.verify((Object)rule, (VerificationMode)Mockito.never())).apply(ArgumentMatchers.anyString());
            }
        }
    }

    private MaskingRule[] createRuleMocks(boolean hasSearchString) {
        MaskingRule[] ruleMocks = new MaskingRule[3];
        for (int count = 0; count < ruleMocks.length; ++count) {
            MaskingRule ruleMock = (MaskingRule)Mockito.mock(MaskingRule.class);
            Mockito.when((Object)ruleMock.apply(ArgumentMatchers.anyString())).thenReturn((Object)"stub");
            if (hasSearchString) {
                Mockito.when((Object)ruleMock.getSearch()).thenReturn((Object)"stub");
            }
            ruleMocks[count] = ruleMock;
        }
        return ruleMocks;
    }

    @Test
    public void doNothingIfNoRules() {
        StringChanger cut = new StringChanger("src/test/resources/no-rules-config.json");
        String stringToChange = "Some amazing message";
        String result = cut.changeString("Some amazing message");
        Assertions.assertEquals((Object)"Some amazing message", (Object)result);
    }
}

