/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.drill.MaskingRule;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public class MaskingRuleTest {
    @Test
    public void canBeUsedToDeserializeJsonConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        File jsonConfig = new File("src/test/resources/test-config.json");
        ThrowingSupplier sut = () -> (MaskingRule[])objectMapper.readValue(jsonConfig, MaskingRule[].class);
        MaskingRule[] maskingRules = (MaskingRule[])Assertions.assertDoesNotThrow((ThrowingSupplier)sut);
        Assert.assertTrue((maskingRules.length == 5 ? 1 : 0) != 0);
    }

    @Test
    public void workForMultilineString() {
        MaskingRule cut = new MaskingRule("password", "secret");
        String stringToChange = "1st line with password\n2nd line with password\n3d line with password";
        String expectedString = "1st line with secret\n2nd line with secret\n3d line with secret";
        String result = cut.apply("1st line with password\n2nd line with password\n3d line with password");
        Assert.assertEquals((Object)"1st line with secret\n2nd line with secret\n3d line with secret", (Object)result);
    }

    @Test
    public void doNothingIfSearchStringIsNotFound() {
        String replaceString = "***";
        MaskingRule cut = new MaskingRule("password", "***");
        String stringToChange = "Name Surname";
        String result = cut.apply("Name Surname");
        Assert.assertEquals((Object)"Name Surname", (Object)result);
    }

    @Test
    public void workWithRegexSearchString() {
        String replaceString = "secret";
        MaskingRule cut = new MaskingRule("[a-zA-Z.]@[a-zA-Z.]", "secret");
        String stringToChange = "User email: name.surname@mail.com";
        String result = cut.apply("User email: name.surname@mail.com");
        Assert.assertFalse((boolean)result.contains("password"));
        Assert.assertTrue((boolean)result.contains("secret"));
    }

    @Test
    public void maskAllSearchOccurrence() {
        String replaceString = "secret";
        MaskingRule cut = new MaskingRule("[pasword]{8}", "secret");
        String stringToChange = "Many password, password, password";
        String result = cut.apply("Many password, password, password");
        Assert.assertFalse((boolean)result.contains("password"));
        Assert.assertTrue((boolean)result.contains("secret"));
    }

    @Test
    public void throwExceptionOnInvalidRegexSearchString() {
        Executable cut = () -> new MaskingRule("[\\]", "something");
        Class<IllegalArgumentException> expectedException = IllegalArgumentException.class;
        Assertions.assertThrows(expectedException, (Executable)cut);
    }

    @Test
    public void removeSearchStringOnEmptyReplaceString() {
        String search = "user.email@mail.com";
        MaskingRule cut = new MaskingRule("user.email@mail.com", "");
        String stringToChange = "User email: user.email@mail.com";
        String expectedString = "User email: ";
        String result = cut.apply("User email: user.email@mail.com");
        Assert.assertEquals((Object)"User email: ", (Object)result);
    }

    @Test
    public void shouldNotChangeStringOnEmptySearch() {
        String replaceString = "magic";
        MaskingRule cut = new MaskingRule("", "magic");
        String stringToChange = "This string shouldn't be changed";
        String result = cut.apply("This string shouldn't be changed");
        Assert.assertEquals((Object)"This string shouldn't be changed", (Object)result);
    }
}

