/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import drill.shaded.hbase.guava.com.google.common.collect.Multimap;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOfflineMetaRebuildOverlap
extends OfflineMetaRebuildTestCore {
    private static final Log LOG = LogFactory.getLog(TestOfflineMetaRebuildOverlap.class);

    @Test(timeout=120000L)
    public void testMetaRebuildOverlapFail() throws Exception {
        byte[] startKey = splits[0];
        byte[] endKey = splits[2];
        this.createRegion(this.conf, this.htbl, startKey, endKey);
        this.wipeOutMeta();
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertFalse((boolean)fsck.rebuildMeta(false));
        Multimap<byte[], HBaseFsck.HbckInfo> problems = fsck.getOverlapGroups(this.table);
        Assert.assertEquals((long)1L, (long)problems.keySet().size());
        Assert.assertEquals((long)3L, (long)problems.size());
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(this.TEST_UTIL);
        LOG.info((Object)"Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(zkw);
        LOG.info((Object)"No more RIT in ZK, now doing final test verification");
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        Object[] htbls = this.getTables(this.TEST_UTIL.getConfiguration());
        LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
        Assert.assertEquals((long)1L, (long)htbls.length);
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
    }
}

