/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.junit.Assert;

public class HbckTestingUtil {
    private static ExecutorService exec = new ScheduledThreadPoolExecutor(10);

    public static HBaseFsck doFsck(Configuration conf, boolean fix) throws Exception {
        return HbckTestingUtil.doFsck(conf, fix, null);
    }

    public static HBaseFsck doFsck(Configuration conf, boolean fix, TableName table) throws Exception {
        return HbckTestingUtil.doFsck(conf, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, table);
    }

    public static HBaseFsck doFsck(Configuration conf, boolean fixAssignments, boolean fixMeta, boolean fixHdfsHoles, boolean fixHdfsOverlaps, boolean fixHdfsOrphans, boolean fixTableOrphans, boolean fixVersionFile, boolean fixReferenceFiles, boolean fixHFileLinks, boolean fixEmptyMetaRegionInfo, boolean fixTableLocks, boolean fixTableZnodes, Boolean fixReplication, TableName table) throws Exception {
        HBaseFsck fsck = new HBaseFsck(conf, exec);
        fsck.setDisplayFullReport();
        fsck.setTimeLag(0L);
        fsck.setFixAssignments(fixAssignments);
        fsck.setFixMeta(fixMeta);
        fsck.setFixHdfsHoles(fixHdfsHoles);
        fsck.setFixHdfsOverlaps(fixHdfsOverlaps);
        fsck.setFixHdfsOrphans(fixHdfsOrphans);
        fsck.setFixTableOrphans(fixTableOrphans);
        fsck.setFixVersionFile(fixVersionFile);
        fsck.setFixReferenceFiles(fixReferenceFiles);
        fsck.setFixHFileLinks(fixHFileLinks);
        fsck.setFixEmptyMetaCells(fixEmptyMetaRegionInfo);
        fsck.setFixTableLocks(fixTableLocks);
        fsck.setFixReplication(fixReplication);
        fsck.setFixTableZNodes(fixTableZnodes);
        fsck.connect();
        if (table != null) {
            fsck.includeTable(table);
        }
        fsck.onlineHbck();
        fsck.close();
        return fsck;
    }

    public static HBaseFsck doHFileQuarantine(Configuration conf, TableName table) throws Exception {
        String[] args = new String[]{"-sidelineCorruptHFiles", "-ignorePreCheckPermission", table.getNameAsString()};
        HBaseFsck hbck = new HBaseFsck(conf, exec);
        hbck.exec(exec, args);
        return hbck;
    }

    public static HBaseFsck checkRegionBoundaries(Configuration conf) throws Exception {
        HBaseFsck hbck = new HBaseFsck(conf, exec);
        hbck.connect();
        hbck.checkRegionBoundaries();
        hbck.close();
        return hbck;
    }

    public static boolean inconsistencyFound(HBaseFsck fsck) throws Exception {
        ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> errs = fsck.getErrors().getErrorList();
        return errs != null && !errs.isEmpty();
    }

    public static void assertNoErrors(HBaseFsck fsck) throws Exception {
        ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> errs = fsck.getErrors().getErrorList();
        Assert.assertEquals(new ArrayList(), errs);
    }

    public static void assertErrors(HBaseFsck fsck, HBaseFsck.ErrorReporter.ERROR_CODE[] expectedErrors) {
        ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> errs = fsck.getErrors().getErrorList();
        Collections.sort(errs);
        ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> expErrs = Lists.newArrayList(expectedErrors);
        Collections.sort(expErrs);
        Assert.assertEquals(expErrs, errs);
    }
}

