/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.regionserver.throttle.PressureAwareThroughputController;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class PressureAwareCompactionThroughputController
extends PressureAwareThroughputController {
    private static final Log LOG = LogFactory.getLog(PressureAwareCompactionThroughputController.class);
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND = "hbase.hstore.compaction.throughput.higher.bound";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND = 0x1400000L;
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND = "hbase.hstore.compaction.throughput.lower.bound";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND = 0xA00000L;
    public static final String HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK = "hbase.hstore.compaction.throughput.offpeak";
    private static final long DEFAULT_HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK = Long.MAX_VALUE;
    public static final String HBASE_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD = "hbase.hstore.compaction.throughput.tune.period";
    private static final int DEFAULT_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD = 60000;
    private static final String HBASE_HSTORE_COMPACTION_THROUGHPUT_CONTROL_CHECK_INTERVAL = "hbase.hstore.compaction.throughput.control.check.interval";
    private long maxThroughputOffpeak;

    @Override
    public void setup(final RegionServerServices server) {
        server.getChoreService().scheduleChore(new ScheduledChore("CompactionThroughputTuner", this, this.tuningPeriod){

            @Override
            protected void chore() {
                PressureAwareCompactionThroughputController.this.tune(server.getCompactionPressure());
            }
        });
    }

    private void tune(double compactionPressure) {
        double maxThroughputToSet = compactionPressure > 1.0 ? Double.MAX_VALUE : (this.offPeakHours.isOffPeakHour() ? (double)this.maxThroughputOffpeak : (double)this.maxThroughputLowerBound + (double)(this.maxThroughputUpperBound - this.maxThroughputLowerBound) * compactionPressure);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("compactionPressure is " + compactionPressure + ", tune compaction throughput to " + this.throughputDesc(maxThroughputToSet)));
        }
        this.setMaxThroughput(maxThroughputToSet);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.maxThroughputUpperBound = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_HIGHER_BOUND, 0x1400000L);
        this.maxThroughputLowerBound = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_LOWER_BOUND, 0xA00000L);
        this.maxThroughputOffpeak = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_THROUGHPUT_OFFPEAK, Long.MAX_VALUE);
        this.offPeakHours = OffPeakHours.getInstance(conf);
        this.controlPerSize = conf.getLong(HBASE_HSTORE_COMPACTION_THROUGHPUT_CONTROL_CHECK_INTERVAL, this.maxThroughputLowerBound);
        this.setMaxThroughput(this.maxThroughputLowerBound);
        this.tuningPeriod = this.getConf().getInt(HBASE_HSTORE_COMPACTION_THROUGHPUT_TUNE_PERIOD, 60000);
        LOG.info((Object)("Compaction throughput configurations, higher bound: " + this.throughputDesc(this.maxThroughputUpperBound) + ", lower bound " + this.throughputDesc(this.maxThroughputLowerBound) + ", off peak: " + this.throughputDesc(this.maxThroughputOffpeak) + ", tuning period: " + this.tuningPeriod + " ms"));
    }

    public String toString() {
        return "DefaultCompactionThroughputController [maxThroughput=" + this.throughputDesc(this.getMaxThroughput()) + ", activeCompactions=" + this.activeOperations.size() + "]";
    }
}

