/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTimeRangeTracker {
    private static final int NUM_KEYS = 10000000;
    static final int NUM_OF_THREADS = 20;

    @Test
    public void testExtreme() {
        TimeRange tr = new TimeRange();
        Assert.assertTrue((boolean)tr.includesTimeRange(new TimeRange()));
        TimeRangeTracker trt = new TimeRangeTracker();
        Assert.assertFalse((boolean)trt.includesTimeRange(new TimeRange()));
        trt.includeTimestamp(1L);
        trt.includeTimestamp(10L);
        Assert.assertTrue((boolean)trt.includesTimeRange(new TimeRange()));
    }

    @Test
    public void testTimeRangeInitialized() {
        TimeRangeTracker src = new TimeRangeTracker();
        TimeRange tr = new TimeRange(System.currentTimeMillis());
        Assert.assertFalse((boolean)src.includesTimeRange(tr));
    }

    @Test
    public void testTimeRangeTrackerNullIsSameAsTimeRangeNull() throws IOException {
        TimeRangeTracker src = new TimeRangeTracker(1L, 2L);
        byte[] bytes = Writables.getBytes((Writable)src);
        TimeRange tgt = TimeRangeTracker.getTimeRange(bytes);
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testSerialization() throws IOException {
        TimeRangeTracker src = new TimeRangeTracker(1L, 2L);
        TimeRangeTracker tgt = new TimeRangeTracker();
        Writables.copyWritable(src, (Writable)tgt);
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testAlwaysDecrementingSetsMaximum() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(3L);
        trr.includeTimestamp(2L);
        trr.includeTimestamp(1L);
        Assert.assertTrue((trr.getMin() != Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMax() != -1L ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleInRange() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(0L);
        trr.includeTimestamp(2L);
        Assert.assertTrue((boolean)trr.includesTimeRange(new TimeRange(1L)));
    }

    @Test
    public void testArriveAtRightAnswer() throws InterruptedException {
        int i;
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 10;
        int calls = 1000000;
        Thread[] threads = new Thread[10];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    boolean even;
                    int offset = Integer.parseInt(this.getName());
                    boolean bl = even = offset % 2 == 0;
                    if (even) {
                        for (int i = offset * 1000000; i < 1000000; ++i) {
                            trr.includeTimestamp(i);
                        }
                    } else {
                        int base = offset * 1000000;
                        for (int i = base + 1000000; i >= base; --i) {
                            trr.includeTimestamp(i);
                        }
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((trr.getMax() == 10000000L ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMin() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRangeConstruction() throws IOException {
        TimeRange defaultRange = new TimeRange();
        Assert.assertEquals((long)0L, (long)defaultRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)defaultRange.getMax());
        Assert.assertTrue((boolean)defaultRange.isAllTime());
        TimeRange oneArgRange = new TimeRange(0L);
        Assert.assertEquals((long)0L, (long)oneArgRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)oneArgRange.getMax());
        Assert.assertTrue((boolean)oneArgRange.isAllTime());
        TimeRange oneArgRange2 = new TimeRange(1L);
        Assert.assertEquals((long)1L, (long)oneArgRange2.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)oneArgRange2.getMax());
        Assert.assertFalse((boolean)oneArgRange2.isAllTime());
        TimeRange twoArgRange = new TimeRange(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)twoArgRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)twoArgRange.getMax());
        Assert.assertTrue((boolean)twoArgRange.isAllTime());
        TimeRange twoArgRange2 = new TimeRange(0L, 0x7FFFFFFFFFFFFFFEL);
        Assert.assertEquals((long)0L, (long)twoArgRange2.getMin());
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)twoArgRange2.getMax());
        Assert.assertFalse((boolean)twoArgRange2.isAllTime());
        TimeRange twoArgRange3 = new TimeRange(1L, Long.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)twoArgRange3.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)twoArgRange3.getMax());
        Assert.assertFalse((boolean)twoArgRange3.isAllTime());
    }

    @Test
    public void testConcurrentIncludeTimestampCorrectness() {
        RandomTestData[] testData = new RandomTestData[20];
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (int i = 0; i < 20; ++i) {
            testData[i] = new RandomTestData();
            if (testData[i].getMin() < min) {
                min = testData[i].getMin();
            }
            if (testData[i].getMax() <= max) continue;
            max = testData[i].getMax();
        }
        TimeRangeTracker trt = new TimeRangeTracker();
        Thread[] t = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            t[i] = new Thread(new TrtUpdateRunnable(trt, testData[i]));
            t[i].start();
        }
        for (Thread thread : t) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertTrue((min == trt.getMin() ? 1 : 0) != 0);
        Assert.assertTrue((max == trt.getMax() ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        long start = System.currentTimeMillis();
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 5;
        int calls = 0x8000000;
        Thread[] threads = new Thread[5];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    for (int i = 0; i < 0x8000000; ++i) {
                        trr.includeTimestamp(i);
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        System.out.println(trr.getMin() + " " + trr.getMax() + " " + (System.currentTimeMillis() - start));
    }

    class TrtUpdateRunnable
    implements Runnable {
        private TimeRangeTracker trt;
        private RandomTestData data;

        public TrtUpdateRunnable(TimeRangeTracker trt, RandomTestData data) {
            this.trt = trt;
            this.data = data;
        }

        @Override
        public void run() {
            for (long key : this.data.keys) {
                this.trt.includeTimestamp(key);
            }
        }
    }

    class RandomTestData {
        private long[] keys = new long[10000000];
        private long min = Long.MAX_VALUE;
        private long max = 0L;

        public RandomTestData() {
            if (ThreadLocalRandom.current().nextInt(20) % 2 == 0) {
                for (int i = 0; i < 10000000; ++i) {
                    this.keys[i] = (long)i + ThreadLocalRandom.current().nextLong(20L);
                    if (this.keys[i] < this.min) {
                        this.min = this.keys[i];
                    }
                    if (this.keys[i] <= this.max) continue;
                    this.max = this.keys[i];
                }
            } else {
                for (int i = 9999999; i >= 0; --i) {
                    this.keys[i] = (long)i + ThreadLocalRandom.current().nextLong(20L);
                    if (this.keys[i] < this.min) {
                        this.min = this.keys[i];
                    }
                    if (this.keys[i] <= this.max) continue;
                    this.max = this.keys[i];
                }
            }
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.min;
        }
    }
}

