/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestStore {
    private static final Log LOG = LogFactory.getLog(TestStore.class);
    @Rule
    public TestName name = new TestName();
    HStore store;
    byte[] table = Bytes.toBytes("table");
    byte[] family = Bytes.toBytes("family");
    byte[] row = Bytes.toBytes("row");
    byte[] row2 = Bytes.toBytes("row2");
    byte[] qf1 = Bytes.toBytes("qf1");
    byte[] qf2 = Bytes.toBytes("qf2");
    byte[] qf3 = Bytes.toBytes("qf3");
    byte[] qf4 = Bytes.toBytes("qf4");
    byte[] qf5 = Bytes.toBytes("qf5");
    byte[] qf6 = Bytes.toBytes("qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<Cell> expected = new ArrayList<Cell>();
    List<Cell> result = new ArrayList<Cell>();
    long id = System.currentTimeMillis();
    Get get = new Get(this.row);
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = this.TEST_UTIL.getDataTestDir("TestStore").toString();
    private static final int BLOCKSIZE_SMALL = 8192;

    @Before
    public void setUp() throws IOException {
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add(new KeyValue(this.row, this.family, next, 1L, (byte[])null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        this.init(methodName, this.TEST_UTIL.getConfiguration());
    }

    private void init(String methodName, Configuration conf) throws IOException {
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMaxVersions(4);
        this.init(methodName, conf, hcd);
    }

    private void init(String methodName, Configuration conf, HColumnDescriptor hcd) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(this.table));
        this.init(methodName, conf, htd, hcd);
    }

    private Store init(String methodName, Configuration conf, HTableDescriptor htd, HColumnDescriptor hcd) throws IOException {
        return this.init(methodName, conf, htd, hcd, null);
    }

    private Store init(String methodName, Configuration conf, HTableDescriptor htd, HColumnDescriptor hcd, MyStoreHook hook) throws IOException {
        Path basedir = new Path(this.DIR + methodName);
        Path tableDir = FSUtils.getTableDir(basedir, htd.getTableName());
        Path logdir = new Path(basedir, DefaultWALProvider.getWALDirectoryName(methodName));
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        if (htd.hasFamily(hcd.getName())) {
            htd.modifyFamily(hcd);
        } else {
            htd.addFamily(hcd);
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir(walConf, basedir);
        WALFactory wals = new WALFactory(walConf, null, methodName);
        HRegion region = new HRegion(tableDir, wals.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace()), fs, conf, info, htd, null);
        this.store = hook == null ? new HStore(region, hcd, conf) : new MyStore(region, hcd, conf, hook);
        return this.store;
    }

    @Test
    public void testFlushSizeAccounting() throws Exception {
        LOG.info((Object)("Setting up a faulty file system that cannot write in " + this.name.getMethodName()));
        final Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting(conf, this.name.getMethodName(), new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                FaultyFileSystem ffs = (FaultyFileSystem)fs;
                TestStore.this.init(TestStore.this.name.getMethodName(), conf);
                long size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)size);
                LOG.info((Object)"Adding some data");
                long kvSize = TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf1, 1L, (byte[])null));
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                try {
                    LOG.info((Object)"Flushing");
                    TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf2, 2L, (byte[])null));
                Assert.assertEquals((long)kvSize, (long)size);
                ffs.fault.set(false);
                TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)size);
                return null;
            }
        });
    }

    @Test
    public void testCreateWriter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setCompressionType(Compression.Algorithm.GZ);
        hcd.setDataBlockEncoding(DataBlockEncoding.DIFF);
        this.init(this.name.getMethodName(), conf, hcd);
        StoreFile.Writer writer = this.store.createWriterInTmp(4L, hcd.getCompression(), false, true, false);
        Path path = writer.getPath();
        writer.append(new KeyValue(this.row, this.family, this.qf1, Bytes.toBytes(1)));
        writer.append(new KeyValue(this.row, this.family, this.qf2, Bytes.toBytes(2)));
        writer.append(new KeyValue(this.row2, this.family, this.qf1, Bytes.toBytes(3)));
        writer.append(new KeyValue(this.row2, this.family, this.qf2, Bytes.toBytes(4)));
        writer.close();
        HFile.Reader reader = HFile.createReader(fs, path, new CacheConfig(conf), conf);
        Assert.assertEquals((Object)((Object)hcd.getCompressionType()), (Object)((Object)reader.getCompressionAlgorithm()));
        Assert.assertEquals((Object)((Object)hcd.getDataBlockEncoding()), (Object)((Object)reader.getDataBlockEncoding()));
        reader.close();
    }

    @Test
    public void testDeleteExpiredStoreFiles() throws Exception {
        this.testDeleteExpiredStoreFiles(0);
        this.testDeleteExpiredStoreFiles(1);
    }

    public void testDeleteExpiredStoreFiles(int minVersions) throws Exception {
        long ts;
        int i;
        int storeFileNum = 4;
        int ttl = 4;
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge(edge);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.delete.expired.storefile", true);
        conf.setInt("hbase.hstore.compaction.min", 5);
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMinVersions(minVersions);
        hcd.setTimeToLive(ttl);
        this.init(this.name.getMethodName() + "-" + minVersions, conf, hcd);
        long storeTtl = this.store.getScanInfo().getTtl();
        long sleepTime = storeTtl / (long)storeFileNum;
        for (i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            long timeStamp = EnvironmentEdgeManager.currentTime();
            this.store.add(new KeyValue(this.row, this.family, this.qf1, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, timeStamp, (byte[])null));
            this.flush(i);
            edge.incrementTime(sleepTime);
        }
        Assert.assertEquals((long)storeFileNum, (long)this.store.getStorefiles().size());
        for (i = 1; i <= storeFileNum - 1; ++i) {
            Assert.assertNull((Object)this.store.requestCompaction());
            Collection<StoreFile> sfs = this.store.getStorefiles();
            if (minVersions == 0) {
                Assert.assertEquals((long)(storeFileNum - i), (long)sfs.size());
                for (StoreFile sf : sfs) {
                    Assert.assertTrue((sf.getReader().getMaxTimestamp() >= edge.currentTime() - storeTtl ? 1 : 0) != 0);
                }
            } else {
                Assert.assertEquals((long)storeFileNum, (long)sfs.size());
            }
            edge.incrementTime(sleepTime);
        }
        Assert.assertNull((Object)this.store.requestCompaction());
        Collection<StoreFile> sfs = this.store.getStorefiles();
        if (minVersions == 0) {
            Assert.assertEquals((long)1L, (long)sfs.size());
        }
        Assert.assertTrue(((ts = sfs.iterator().next().getReader().getMaxTimestamp()) < edge.currentTime() - storeTtl ? 1 : 0) != 0);
        for (StoreFile sf : sfs) {
            sf.closeReader(true);
        }
    }

    @Test
    public void testRollback() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.name.getMethodName(), conf);
        Cell cell = CellUtil.createCell(this.row, this.family, this.qf1);
        int len = KeyValueUtil.length(cell);
        int offset = 77;
        byte[] buf = new byte[offset + len];
        KeyValueUtil.appendToByteArray(cell, buf, offset);
        KeyValue newKv = new KeyValue(buf, offset, len);
        newKv.setSequenceId(cell.getSequenceId());
        List<Cell> testCells = Arrays.asList(cell, cell, newKv);
        for (Cell c : testCells) {
            long sizeBeforeRollback = this.store.heapSize();
            this.store.add(cell);
            this.store.rollback(cell);
            long sizeAeforeRollback = this.store.heapSize();
            Assert.assertEquals((long)sizeBeforeRollback, (long)sizeAeforeRollback);
        }
    }

    @Test
    public void testLowestModificationTime() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.name.getMethodName(), conf);
        int storeFileNum = 4;
        for (int i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            this.store.add(new KeyValue(this.row, this.family, this.qf1, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, (long)i, (byte[])null));
            this.flush(i);
        }
        long lowestTimeStampFromManager = StoreUtils.getLowestTimestamp(this.store.getStorefiles());
        long lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
        this.store.compact(this.store.requestCompaction(), NoLimitThroughputController.INSTANCE);
        lowestTimeStampFromManager = StoreUtils.getLowestTimestamp(this.store.getStorefiles());
        lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
    }

    private static long getLowestTimeStampFromFS(FileSystem fs, Collection<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        if (candidates.isEmpty()) {
            return minTs;
        }
        Path[] p = new Path[candidates.size()];
        int i = 0;
        for (StoreFile sf : candidates) {
            p[i] = sf.getPath();
            ++i;
        }
        FileStatus[] stats = fs.listStatus(p);
        if (stats == null || stats.length == 0) {
            return minTs;
        }
        for (FileStatus s : stats) {
            minTs = Math.min(minTs, s.getModificationTime());
        }
        return minTs;
    }

    @Test
    public void testEmptyStoreFile() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        StoreFile f = this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(meta).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        this.store.close();
        this.store = new HStore(this.store.getHRegion(), this.store.getFamily(), c);
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Assert.assertEquals((long)1L, (long)this.result.size());
    }

    @Test
    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        this.assertCheck();
    }

    @Test
    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.flush(3);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    @Test
    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)storeFilessize, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)0L, (long)((DefaultMemStore)this.store.memstore).activeSection.getCellSkipListSet().sizeForTests());
    }

    private void assertCheck() {
        Assert.assertEquals((long)this.expected.size(), (long)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    @Test
    public void testIncrementColumnValue_ICVDuringFlush() throws IOException, InterruptedException {
        this.init(this.name.getMethodName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(oldValue)));
        this.store.snapshot();
        this.store.add(new KeyValue(this.row, this.family, this.qf2, System.currentTimeMillis(), Bytes.toBytes(oldValue)));
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        Assert.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)1L, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)2L, (long)((DefaultMemStore)this.store.memstore).activeSection.getCellSkipListSet().sizeForTests());
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        long ts1 = ((Cell)results.get(0)).getTimestamp();
        long ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(0))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(1))));
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
    }

    @Test
    public void testICV_negMemstoreSize() throws IOException {
        this.init(this.name.getMethodName());
        long time = 100L;
        ManualEnvironmentEdge ee = new ManualEnvironmentEdge();
        ee.setValue(time);
        EnvironmentEdgeManagerTestHelper.injectEdge(ee);
        long newValue = 3L;
        long size = 0L;
        size += this.store.add(new KeyValue(Bytes.toBytes("200909091000"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes("200909091200"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes("200909091300"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes("200909091400"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes("200909091500"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes(newValue)));
        for (int i = 0; i < 10000; ++i) {
            long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
            long ret2 = this.store.updateColumnValue(this.row2, this.family, this.qf1, newValue);
            if (ret != 0L) {
                System.out.println("ret: " + ret);
            }
            if (ret2 != 0L) {
                System.out.println("ret2: " + ret2);
            }
            Assert.assertTrue((String)("ret: " + ret), (ret >= 0L ? 1 : 0) != 0);
            size += ret;
            Assert.assertTrue((String)("ret2: " + ret2), (ret2 >= 0L ? 1 : 0) != 0);
            size += ret2;
            if (i % 1000 != 0) continue;
            ee.setValue(++time);
        }
        long computedSize = 0L;
        for (Cell cell : ((DefaultMemStore)this.store.memstore).activeSection.getCellSkipListSet()) {
            long kvsize = DefaultMemStore.heapSizeChange(cell, true);
            computedSize += kvsize;
        }
        Assert.assertEquals((long)computedSize, (long)size);
    }

    @Test
    public void testIncrementColumnValue_SnapshotFlushCombo() throws Exception {
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge(mee);
        this.init(this.name.getMethodName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, EnvironmentEdgeManager.currentTime(), Bytes.toBytes(oldValue)));
        this.store.snapshot();
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        Assert.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)1L, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)1L, (long)((DefaultMemStore)this.store.memstore).activeSection.getCellSkipListSet().sizeForTests());
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        long ts1 = ((Cell)results.get(0)).getTimestamp();
        long ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(0))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(1))));
        mee.setValue(2L);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        ts1 = ((Cell)results.get(0)).getTimestamp();
        ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(0))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong(CellUtil.cloneValue((Cell)results.get(1))));
    }

    @Test
    public void testHandleErrorsInFlush() throws Exception {
        LOG.info((Object)"Setting up a faulty file system that cannot write");
        final Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting(conf, "testhandleerrorsinflush", new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                TestStore.this.init(TestStore.this.name.getMethodName(), conf);
                LOG.info((Object)"Adding some data");
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf1, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf2, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf3, 1L, (byte[])null));
                LOG.info((Object)"Before flush, we should have no files");
                Collection<StoreFileInfo> files = TestStore.this.store.getRegionFileSystem().getStoreFiles(TestStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                try {
                    LOG.info((Object)"Flushing");
                    TestStore.this.flush(1);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                LOG.info((Object)"After failed flush, we should still have no files!");
                files = TestStore.this.store.getRegionFileSystem().getStoreFiles(TestStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                TestStore.this.store.getHRegion().getWAL().close();
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    private static void flushStore(HStore store, long id) throws IOException {
        StoreFlushContext storeFlushCtx = store.createFlushContext(id);
        storeFlushCtx.prepare();
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    List<Cell> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes(i);
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        int numRows = 1;
        long[] timestamps1 = new long[]{1L, 5L, 10L, 20L};
        long[] timestamps2 = new long[]{30L, 80L};
        this.init(this.name.getMethodName());
        List<Cell> kvList1 = this.getKeyValueSet(timestamps1, numRows, this.qf1, this.family);
        for (Cell cell : kvList1) {
            this.store.add(KeyValueUtil.ensureKeyValue(cell));
        }
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        List<Cell> kvList2 = this.getKeyValueSet(timestamps2, numRows, this.qf1, this.family);
        for (Cell kv : kvList2) {
            this.store.add(KeyValueUtil.ensureKeyValue(kv));
        }
        Get get = new Get(Bytes.toBytes(1));
        get.addColumn(this.family, this.qf1);
        get.setTimeRange(0L, 15L);
        List<Cell> list = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(40L, 90L);
        List<Cell> list2 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(10L, 45L);
        List<Cell> list3 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list3.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(80L, 145L);
        List<Cell> list4 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list4.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(1L, 2L);
        List<Cell> list5 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list5.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(90L, 200L);
        List<Cell> list6 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list6.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitWithEmptyColFam() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().forceSplit(null);
        Assert.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().clearSplit();
    }

    @Test
    public void testStoreUsesConfigurationFromHcdAndHtd() throws Exception {
        String CONFIG_KEY = "hbase.regionserver.thread.compaction.throttle";
        long anyValue = 10L;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.thread.compaction.throttle", anyValue);
        this.init(this.name.getMethodName() + "-xml", conf);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(this.table));
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        htd.setConfiguration("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue));
        this.init(this.name.getMethodName() + "-htd", conf, htd, hcd);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        hcd.setConfiguration("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue));
        this.init(this.name.getMethodName() + "-hcd", conf, htd, hcd);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
    }

    @Test
    public void testStoreUsesSearchEngineOverride() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        this.init(this.name.getMethodName(), conf);
        Assert.assertEquals((Object)DummyStoreEngine.lastCreatedCompactor, (Object)this.store.storeEngine.getCompactor());
    }

    private void addStoreFile() throws IOException {
        StoreFile f = this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = this.store.getMaxSequenceId();
        Configuration c = this.TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext fileContext = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(fileContext).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        LOG.info((Object)("Added store file:" + w.getPath()));
    }

    private void archiveStoreFile(int index) throws IOException {
        Collection<StoreFile> files = this.store.getStorefiles();
        StoreFile sf = null;
        Iterator<StoreFile> it = files.iterator();
        for (int i = 0; i <= index; ++i) {
            sf = it.next();
        }
        this.store.getRegionFileSystem().removeStoreFiles(this.store.getColumnFamilyName(), Lists.newArrayList(sf));
    }

    private void closeCompactedFile(int index) throws IOException {
        Collection<StoreFile> files = this.store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        StoreFile sf = null;
        Iterator<StoreFile> it = files.iterator();
        for (int i = 0; i <= index; ++i) {
            sf = it.next();
        }
        sf.closeReader(true);
        this.store.getStoreEngine().getStoreFileManager().removeCompactedFiles(Lists.newArrayList(sf));
    }

    @Test
    public void testRefreshStoreFiles() throws Exception {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.flush(1);
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        this.addStoreFile();
        this.addStoreFile();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.closeCompactedFile(0);
        this.archiveStoreFile(0);
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.archiveStoreFile(1);
        this.archiveStoreFile(2);
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
    }

    @Test
    public void testRefreshStoreFilesNotChanged() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.flush(1);
        this.addStoreFile();
        HStore spiedStore = (HStore)Mockito.spy((Object)this.store);
        spiedStore.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        ((HStore)Mockito.verify((Object)spiedStore, (VerificationMode)Mockito.times((int)1))).replaceStoreFiles((Collection)Matchers.any(Collection.class), (Collection)Matchers.any(Collection.class));
        spiedStore.refreshStoreFiles();
        ((HStore)Mockito.verify((Object)spiedStore, (VerificationMode)Mockito.times((int)0))).replaceStoreFiles(null, null);
    }

    private Cell createCell(byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        return this.createCell(this.row, qualifier, ts, sequenceId, value);
    }

    private Cell createCell(byte[] row, byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        Cell c = CellUtil.createCell(row, this.family, qualifier, ts, KeyValue.Type.Put.getCode(), value);
        CellUtil.setSequenceId(c, sequenceId);
        return c;
    }

    @Test
    public void testScanWithDoubleFlush() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        MyStore myStore = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){

            @Override
            public void getScanners(final MyStore store) throws IOException {
                final long tmpId = TestStore.this.id++;
                ExecutorService s = Executors.newSingleThreadExecutor();
                s.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TestStore.flushStore(store, tmpId);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
                s.shutdown();
                try {
                    s.awaitTermination(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        byte[] oldValue = Bytes.toBytes("oldValue");
        byte[] currentValue = Bytes.toBytes("currentValue");
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        myStore.add(this.createCell(this.qf1, ts, seqId, oldValue));
        myStore.add(this.createCell(this.qf2, ts, seqId, oldValue));
        myStore.add(this.createCell(this.qf3, ts, seqId, oldValue));
        long snapshotId = this.id++;
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(snapshotId);
        storeFlushCtx.prepare();
        myStore.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, currentValue));
        myStore.add(this.createCell(this.qf2, ts + 1L, seqId + 1L, currentValue));
        myStore.add(this.createCell(this.qf3, ts + 1L, seqId + 1L, currentValue));
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)((Object)myStore.getScanner(new Scan(new Get(this.row)), quals, seqId + 1L));){
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
            ArrayList<Cell> results = new ArrayList<Cell>();
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue(c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary(currentValue) + ", actual:" + Bytes.toStringBinary(actualValue)), (boolean)Bytes.equals(actualValue, currentValue));
            }
        }
    }

    @Test
    public void testFlushBeforeCompletingScanWoFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 2) {
                    try {
                        TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
                return Filter.ReturnCode.INCLUDE;
            }
        });
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 2) {
                    try {
                        TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
                if (timeToGoNextRow.get()) {
                    timeToGoNextRow.set(false);
                    return Filter.ReturnCode.NEXT_ROW;
                }
                return Filter.ReturnCode.INCLUDE;
            }
        });
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilterHint() throws IOException, InterruptedException {
        final AtomicBoolean timeToGetHint = new AtomicBoolean(false);
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 2) {
                    try {
                        TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                        timeToGetHint.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
                if (timeToGetHint.get()) {
                    timeToGetHint.set(false);
                    return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                }
                return Filter.ReturnCode.INCLUDE;
            }

            @Override
            public Cell getNextCellHint(Cell currentCell) throws IOException {
                return currentCell;
            }
        });
    }

    private void testFlushBeforeCompletingScan(MyListHook hook, Filter filter) throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMaxVersions(1);
        byte[] r0 = Bytes.toBytes("row0");
        byte[] r1 = Bytes.toBytes("row1");
        byte[] r2 = Bytes.toBytes("row2");
        byte[] value0 = Bytes.toBytes("value0");
        byte[] value1 = Bytes.toBytes("value1");
        byte[] value2 = Bytes.toBytes("value2");
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.init(this.name.getMethodName(), conf, new HTableDescriptor(TableName.valueOf(this.table)), hcd, new MyStoreHook(){

            @Override
            public long getSmallestReadPoint(HStore store) {
                return 103L;
            }
        });
        this.store.add(this.createCell(r0, this.qf1, ts, 100L, value0));
        this.store.add(this.createCell(r0, this.qf2, ts, 100L, value0));
        this.store.add(this.createCell(r0, this.qf3, ts, 100L, value0));
        this.store.add(this.createCell(r1, this.qf1, ts + 1L, 101L, value1));
        this.store.add(this.createCell(r1, this.qf2, ts + 1L, 101L, value1));
        this.store.add(this.createCell(r1, this.qf3, ts + 1L, 101L, value1));
        this.store.add(this.createCell(r2, this.qf1, ts + 2L, 102L, value2));
        this.store.add(this.createCell(r2, this.qf2, ts + 2L, 102L, value2));
        this.store.add(this.createCell(r2, this.qf3, ts + 2L, 102L, value2));
        this.store.add(this.createCell(r1, this.qf1, ts + 3L, 103L, value1));
        this.store.add(this.createCell(r1, this.qf2, ts + 3L, 103L, value1));
        this.store.add(this.createCell(r1, this.qf3, ts + 3L, 103L, value1));
        MyList<Cell> myList = new MyList<Cell>(hook);
        Scan scan = new Scan().withStartRow(r1).setFilter(filter);
        try (InternalScanner scanner = (InternalScanner)((Object)this.store.getScanner(scan, null, 103L));){
            scanner.next(myList);
            Assert.assertEquals((long)3L, (long)myList.size());
            for (Cell c : myList) {
                byte[] actualValue = CellUtil.cloneValue(c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary(value1) + ", actual:" + Bytes.toStringBinary(actualValue)), (boolean)Bytes.equals(actualValue, value1));
            }
            ArrayList<Cell> normalList = new ArrayList<Cell>(3);
            scanner.next(normalList);
            Assert.assertEquals((long)3L, (long)normalList.size());
            for (Cell c : normalList) {
                byte[] actualValue = CellUtil.cloneValue(c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary(value2) + ", actual:" + Bytes.toStringBinary(actualValue)), (boolean)Bytes.equals(actualValue, value2));
            }
        }
    }

    @Test
    public void testReclaimChunkWhenScaning() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 1.0f);
        this.init("testReclaimChunkWhenScaning", conf);
        final long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        byte[] value = Bytes.toBytes("value");
        this.store.add(this.createCell(this.qf1, ts, 100L, value));
        this.store.add(this.createCell(this.qf2, ts, 100L, value));
        this.store.add(this.createCell(this.qf3, ts, 100L, value));
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)((Object)this.store.getScanner(new Scan(new Get(this.row)), quals, 100L));){
            MyList<Cell> results = new MyList<Cell>(new MyListHook(){

                @Override
                public void hook(int size) {
                    switch (size) {
                        case 1: {
                            try {
                                TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                                break;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        case 2: {
                            try {
                                byte[] newValue = Bytes.toBytes("newValue");
                                TestStore.this.store.add(TestStore.this.createCell(TestStore.this.qf1, ts + 1L, 101L, newValue));
                                TestStore.this.store.add(TestStore.this.createCell(TestStore.this.qf2, ts + 1L, 101L, newValue));
                                TestStore.this.store.add(TestStore.this.createCell(TestStore.this.qf3, ts + 1L, 101L, newValue));
                                break;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            });
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue(c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary(value) + ", actual:" + Bytes.toStringBinary(actualValue)), (boolean)Bytes.equals(actualValue, value));
            }
        }
    }

    private MyStore initMyStore(String methodName, Configuration conf, MyStoreHook hook) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(this.table));
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMaxVersions(5);
        return (MyStore)this.init(methodName, conf, htd, hcd, hook);
    }

    private static class MyList<T>
    implements List<T> {
        private final List<T> delegatee = new ArrayList<T>();
        private final MyListHook hookAtAdd;

        MyList(MyListHook hookAtAdd) {
            this.hookAtAdd = hookAtAdd;
        }

        @Override
        public int size() {
            return this.delegatee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegatee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegatee.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegatee.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegatee.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegatee.toArray(a);
        }

        @Override
        public boolean add(T e) {
            this.hookAtAdd.hook(this.size());
            return this.delegatee.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegatee.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegatee.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.delegatee.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return this.delegatee.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegatee.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegatee.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegatee.clear();
        }

        @Override
        public T get(int index) {
            return this.delegatee.get(index);
        }

        @Override
        public T set(int index, T element) {
            return this.delegatee.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            this.delegatee.add(index, element);
        }

        @Override
        public T remove(int index) {
            return this.delegatee.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegatee.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegatee.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.delegatee.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.delegatee.listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.delegatee.subList(fromIndex, toIndex);
        }
    }

    static interface MyListHook {
        public void hook(int var1);
    }

    private abstract class MyStoreHook {
        private MyStoreHook() {
        }

        void getScanners(MyStore store) throws IOException {
        }

        long getSmallestReadPoint(HStore store) {
            return store.getHRegion().getSmallestReadPoint();
        }
    }

    private static class MyStore
    extends HStore {
        private final MyStoreHook hook;

        MyStore(HRegion region, HColumnDescriptor family, Configuration confParam, MyStoreHook hook) throws IOException {
            super(region, family, confParam);
            this.hook = hook;
        }

        @Override
        public List<KeyValueScanner> getScanners(List<StoreFile> files, boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
            this.hook.getScanners(this);
            return super.getScanners(files, cacheBlocks, isGet, usePread, isCompaction, matcher, startRow, stopRow, readPt, includeMemstoreScanner);
        }

        @Override
        public long getSmallestReadPoint() {
            return this.hook.getSmallestReadPoint(this);
        }
    }

    public static class DummyStoreEngine
    extends DefaultStoreEngine {
        public static DefaultCompactor lastCreatedCompactor = null;

        @Override
        protected void createComponents(Configuration conf, Store store, KeyValue.KVComparator comparator) throws IOException {
            super.createComponents(conf, store, comparator);
            lastCreatedCompactor = (DefaultCompactor)this.compactor;
        }
    }

    static class FaultyOutputStream
    extends FSDataOutputStream {
        volatile long faultPos = Long.MAX_VALUE;
        private final AtomicBoolean fault;

        public FaultyOutputStream(FSDataOutputStream out, long faultPos, AtomicBoolean fault) throws IOException {
            super((OutputStream)out, null);
            this.faultPos = faultPos;
            this.fault = fault;
        }

        public void write(byte[] buf, int offset, int length) throws IOException {
            System.err.println("faulty stream write at pos " + this.getPos());
            this.injectFault();
            super.write(buf, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.fault.get() && this.getPos() >= this.faultPos) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyOutputStream>> outStreams = new ArrayList<SoftReference<FaultyOutputStream>>();
        private long faultPos = 200L;
        AtomicBoolean fault = new AtomicBoolean(true);

        public FaultyFileSystem() {
            super((FileSystem)new LocalFileSystem());
            System.err.println("Creating faulty!");
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return new FaultyOutputStream(super.create(p), this.faultPos, this.fault);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new FaultyOutputStream(super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.faultPos, this.fault);
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        }
    }
}

