/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsRegionSourceImpl {
    @Test
    public void testCompareToHashCodeEquals() throws Exception {
        MetricsRegionServerSourceFactory fact = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsRegionSource one = fact.createRegion(new RegionWrapperStub("TEST"));
        MetricsRegionSource oneClone = fact.createRegion(new RegionWrapperStub("TEST"));
        MetricsRegionSource two = fact.createRegion(new RegionWrapperStub("TWO"));
        Assert.assertEquals((long)0L, (long)one.compareTo(oneClone));
        Assert.assertEquals((long)one.hashCode(), (long)oneClone.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertTrue((one.compareTo(two) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(one) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(one) != one.compareTo(two) ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(two) == 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testNoGetRegionServerMetricsSourceImpl() throws Exception {
        CompatibilitySingletonFactory.getInstance(MetricsRegionSource.class);
    }

    static class RegionWrapperStub
    implements MetricsRegionWrapper {
        private String regionName;

        public RegionWrapperStub(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public String getTableName() {
            return null;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        @Override
        public String getRegionName() {
            return this.regionName;
        }

        @Override
        public long getNumStores() {
            return 0L;
        }

        @Override
        public long getNumStoreFiles() {
            return 0L;
        }

        @Override
        public long getMemstoreSize() {
            return 0L;
        }

        @Override
        public long getStoreFileSize() {
            return 0L;
        }

        @Override
        public long getReadRequestCount() {
            return 0L;
        }

        @Override
        public long getMaxStoreFileAge() {
            return 0L;
        }

        @Override
        public long getMinStoreFileAge() {
            return 0L;
        }

        @Override
        public long getAvgStoreFileAge() {
            return 0L;
        }

        @Override
        public long getNumReferenceFiles() {
            return 0L;
        }

        @Override
        public long getWriteRequestCount() {
            return 0L;
        }

        @Override
        public long getNumFilesCompacted() {
            return 0L;
        }

        @Override
        public long getNumBytesCompacted() {
            return 0L;
        }

        @Override
        public long getLastMajorCompactionAge() {
            return 0L;
        }

        @Override
        public long getNumCompactionsCompleted() {
            return 0L;
        }

        @Override
        public long getNumCompactionsFailed() {
            return 0L;
        }

        @Override
        public int getRegionHashCode() {
            return this.regionName.hashCode();
        }

        @Override
        public int getReplicaId() {
            return 0;
        }

        @Override
        public long getNumCompactionsQueued() {
            return 0L;
        }

        @Override
        public long getNumFlushesQueued() {
            return 0L;
        }

        @Override
        public long getMaxCompactionQueueSize() {
            return 0L;
        }

        @Override
        public long getMaxFlushQueueSize() {
            return 0L;
        }
    }
}

