/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.FailedArchiveException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MockStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCompactionArchiveIOException {
    private static final String ERROR_FILE = "fffffffffffffffffdeadbeef";
    public HBaseTestingUtility testUtil;
    private Path testDir;

    @Before
    public void setup() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.testUtil.startMiniDFSCluster(1);
        this.testDir = this.testUtil.getDataTestDirOnTestFS();
        FSUtils.setRootDir(this.testUtil.getConfiguration(), this.testDir);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.cleanupTestDir();
        this.testUtil.shutdownMiniDFSCluster();
    }

    @Test
    public void testRemoveCompactedFilesWithException() throws Exception {
        byte[] fam = Bytes.toBytes("f");
        byte[] col = Bytes.toBytes("c");
        byte[] val = Bytes.toBytes("val");
        TableName tableName = TableName.valueOf(this.getClass().getSimpleName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(fam));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        HRegion region = this.initHRegion(htd, info);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        regions.add(region);
        Mockito.when(rss.getOnlineRegions()).thenReturn(regions);
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, rss, false);
        int batchSize = 10;
        int fileCount = 10;
        for (int f = 0; f < fileCount; ++f) {
            int start;
            for (int i = start = f * batchSize; i < start + batchSize; ++i) {
                Put p = new Put(Bytes.toBytes("row" + i));
                p.addColumn(fam, col, val);
                region.put(p);
            }
            region.flush(true);
        }
        HStore store = (HStore)region.getStore(fam);
        Assert.assertEquals((long)fileCount, (long)store.getStorefilesCount());
        Collection<StoreFile> storefiles = store.getStorefiles();
        for (StoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        StoreFileManager fileManager = store.getStoreEngine().getStoreFileManager();
        Collection<StoreFile> initialCompactedFiles = fileManager.getCompactedfiles();
        Assert.assertTrue((initialCompactedFiles == null || initialCompactedFiles.isEmpty() ? 1 : 0) != 0);
        region.compact(true);
        Collection<StoreFile> compactedFilesPreClean = fileManager.getCompactedfiles();
        Assert.assertNotNull(compactedFilesPreClean);
        Assert.assertTrue((compactedFilesPreClean.size() > 0 ? 1 : 0) != 0);
        HRegionFileSystem regionFS = region.getRegionFileSystem();
        Path errFile = regionFS.getStoreFilePath(Bytes.toString(fam), ERROR_FILE);
        FSDataOutputStream out = regionFS.getFileSystem().create(errFile);
        out.writeInt(1);
        out.close();
        MockStoreFile errStoreFile = new MockStoreFile(this.testUtil, errFile, 1L, 0L, false, 1L);
        fileManager.addCompactionResults(ImmutableList.of(errStoreFile), ImmutableList.of());
        cleaner.chore();
        Collection<StoreFile> compactedFilesPostClean = fileManager.getCompactedfiles();
        Assert.assertEquals((long)1L, (long)compactedFilesPostClean.size());
        for (StoreFile origFile : compactedFilesPreClean) {
            Assert.assertFalse((boolean)compactedFilesPostClean.contains(origFile));
        }
        try {
            region.close();
        }
        catch (FailedArchiveException e) {
            Assert.assertEquals((long)1L, (long)e.getFailedFiles().size());
            Assert.assertEquals((Object)ERROR_FILE, (Object)e.getFailedFiles().iterator().next().getName());
        }
    }

    private HRegion initHRegion(HTableDescriptor htd, HRegionInfo info) throws IOException {
        Configuration conf = this.testUtil.getConfiguration();
        Path tableDir = FSUtils.getTableDir(this.testDir, htd.getTableName());
        Path regionDir = new Path(tableDir, info.getEncodedName());
        Path storeDir = new Path(regionDir, htd.getColumnFamilies()[0].getNameAsString());
        FileSystem errFS = (FileSystem)Mockito.spy((Object)this.testUtil.getTestFileSystem());
        ((FileSystem)Mockito.doThrow((Throwable)new IOException("Error for test")).when((Object)errFS)).rename((Path)Matchers.eq((Object)new Path(storeDir, ERROR_FILE)), (Path)Matchers.any(Path.class));
        HRegionFileSystem fs = new HRegionFileSystem(conf, errFS, tableDir, info);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir(walConf, tableDir);
        WALFactory wals = new WALFactory(walConf, null, "log_" + info.getEncodedName());
        HRegion region = new HRegion(fs, wals.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace()), conf, htd, null);
        region.initialize();
        return region;
    }
}

