/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;

@InterfaceAudience.Private
public class MetricsRegion {
    private final MetricsRegionSource source;
    private MetricsRegionWrapper regionWrapper;

    public MetricsRegion(MetricsRegionWrapper wrapper) {
        this.source = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createRegion(wrapper);
        this.regionWrapper = wrapper;
    }

    public void close() {
        this.source.close();
    }

    public void updatePut() {
        this.source.updatePut();
    }

    public void updateDelete() {
        this.source.updateDelete();
    }

    public void updateGet(long t) {
        this.source.updateGet(t);
    }

    public void updateScanTime(long t) {
        this.source.updateScanTime(t);
    }

    public void updateAppend() {
        this.source.updateAppend();
    }

    public void updateIncrement() {
        this.source.updateIncrement();
    }

    MetricsRegionSource getSource() {
        return this.source;
    }

    public MetricsRegionWrapper getRegionWrapper() {
        return this.regionWrapper;
    }
}

