/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure.flush;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MasterFlushTableProcedureManager
extends MasterProcedureManager {
    public static final String FLUSH_TABLE_PROCEDURE_SIGNATURE = "flush-table-proc";
    private static final String FLUSH_TIMEOUT_MILLIS_KEY = "hbase.flush.master.timeoutMillis";
    private static final int FLUSH_TIMEOUT_MILLIS_DEFAULT = 60000;
    private static final String FLUSH_WAKE_MILLIS_KEY = "hbase.flush.master.wakeMillis";
    private static final int FLUSH_WAKE_MILLIS_DEFAULT = 500;
    private static final String FLUSH_PROC_POOL_THREADS_KEY = "hbase.flush.procedure.master.threads";
    private static final int FLUSH_PROC_POOL_THREADS_DEFAULT = 1;
    private static final Log LOG = LogFactory.getLog(MasterFlushTableProcedureManager.class);
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private Map<TableName, Procedure> procMap = new HashMap<TableName, Procedure>();
    private boolean stopped;

    @Override
    public void stop(String why) {
        LOG.info((Object)("stop: " + why));
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(FLUSH_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = conf.getLong(FLUSH_TIMEOUT_MILLIS_KEY, 60000L);
        int threads = conf.getInt(FLUSH_PROC_POOL_THREADS_KEY, 1);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, threads);
        ZKProcedureCoordinatorRpcs comms = new ZKProcedureCoordinatorRpcs(master.getZooKeeper(), this.getProcedureSignature(), name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
    }

    @Override
    public String getProcedureSignature() {
        return FLUSH_TABLE_PROCEDURE_SIGNATURE;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        TableName tableName = TableName.valueOf(desc.getInstance());
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTableFlush(tableName);
        }
        List<Pair<HRegionInfo, ServerName>> regionsAndLocations = TableName.META_TABLE_NAME.equals(tableName) ? new MetaTableLocator().getMetaRegionsAndLocations(this.master.getZooKeeper()) : MetaTableAccessor.getTableRegionsAndLocations(this.master.getZooKeeper(), this.master.getConnection(), tableName, false);
        HashSet<String> regionServers = new HashSet<String>(regionsAndLocations.size());
        for (Pair<HRegionInfo, ServerName> region : regionsAndLocations) {
            HRegionInfo hri;
            if (region == null || region.getFirst() == null || region.getSecond() == null || (hri = region.getFirst()).isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
            regionServers.add(region.getSecond().toString());
        }
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getInstance());
        Procedure proc = this.coordinator.startProcedure(monitor, desc.getInstance(), new byte[0], Lists.newArrayList(regionServers));
        monitor.rethrowException();
        if (proc == null) {
            String msg = "Failed to submit distributed procedure " + desc.getSignature() + " for '" + desc.getInstance() + "'. Another flush procedure is running?";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.procMap.put(tableName, proc);
        try {
            proc.waitForCompleted();
            LOG.info((Object)("Done waiting - exec procedure " + desc.getSignature() + " for '" + desc.getInstance() + "'"));
            LOG.info((Object)"Master flush table procedure is successful!");
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for flush table procdure to finish", e);
            monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            ForeignException ee = new ForeignException("Exception while waiting for flush table procdure to finish", e);
            monitor.receive(ee);
        }
        monitor.rethrowException();
    }

    @Override
    public synchronized boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        TableName tableName = TableName.valueOf(desc.getInstance());
        Procedure proc = this.procMap.get(tableName);
        if (proc == null) {
            return false;
        }
        return proc.isCompleted();
    }
}

