/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class CreateNamespaceProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.CreateNamespaceState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(CreateNamespaceProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private NamespaceDescriptor nsDescriptor;
    private Boolean traceEnabled;

    public CreateNamespaceProcedure() {
        this.traceEnabled = null;
    }

    public CreateNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) {
        this.nsDescriptor = nsDescriptor;
        this.traceEnabled = null;
        this.setOwner(env.getRequestUser().getUGI().getShortUserName());
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CreateNamespaceState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + (Object)((Object)state)));
        }
        try {
            switch (state) {
                case CREATE_NAMESPACE_PREPARE: {
                    this.prepareCreate(env);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_CREATE_DIRECTORY);
                    break;
                }
                case CREATE_NAMESPACE_CREATE_DIRECTORY: {
                    CreateNamespaceProcedure.createDirectory(env, this.nsDescriptor);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_INSERT_INTO_NS_TABLE);
                    break;
                }
                case CREATE_NAMESPACE_INSERT_INTO_NS_TABLE: {
                    CreateNamespaceProcedure.insertIntoNSTable(env, this.nsDescriptor);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_UPDATE_ZK);
                    break;
                }
                case CREATE_NAMESPACE_UPDATE_ZK: {
                    CreateNamespaceProcedure.updateZKNamespaceManager(env, this.nsDescriptor);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_SET_NAMESPACE_QUOTA);
                    break;
                }
                case CREATE_NAMESPACE_SET_NAMESPACE_QUOTA: {
                    CreateNamespaceProcedure.setNamespaceQuota(env, this.nsDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + (Object)((Object)state));
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to create the namespace" + this.nsDescriptor.getName() + " (in state=" + (Object)((Object)state) + ")"), (Throwable)e);
            this.setFailure("master-create-namespace", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CreateNamespaceState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + (Object)((Object)state)));
        }
        try {
            switch (state) {
                case CREATE_NAMESPACE_SET_NAMESPACE_QUOTA: {
                    this.rollbackSetNamespaceQuota(env);
                    break;
                }
                case CREATE_NAMESPACE_UPDATE_ZK: {
                    this.rollbackZKNamespaceManagerChange(env);
                    break;
                }
                case CREATE_NAMESPACE_INSERT_INTO_NS_TABLE: {
                    this.rollbackInsertIntoNSTable(env);
                    break;
                }
                case CREATE_NAMESPACE_CREATE_DIRECTORY: {
                    this.rollbackCreateDirectory(env);
                    break;
                }
                case CREATE_NAMESPACE_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + (Object)((Object)state));
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step " + (Object)((Object)state) + " for creating the namespace " + this.nsDescriptor.getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected MasterProcedureProtos.CreateNamespaceState getState(int stateId) {
        return MasterProcedureProtos.CreateNamespaceState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.CreateNamespaceState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.CreateNamespaceState getInitialState() {
        return MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_PREPARE;
    }

    @Override
    protected void setNextState(MasterProcedureProtos.CreateNamespaceState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("create-namespace", "abort requested");
        } else {
            super.setNextState(state);
        }
    }

    @Override
    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    @Override
    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.CreateNamespaceStateData.Builder createNamespaceMsg = MasterProcedureProtos.CreateNamespaceStateData.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(this.nsDescriptor));
        createNamespaceMsg.build().writeDelimitedTo(stream);
    }

    @Override
    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.CreateNamespaceStateData createNamespaceMsg = MasterProcedureProtos.CreateNamespaceStateData.parseDelimitedFrom(stream);
        this.nsDescriptor = ProtobufUtil.toNamespaceDescriptor(createNamespaceMsg.getNamespaceDescriptor());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (Namespace=");
        sb.append(this.nsDescriptor.getName());
        sb.append(")");
    }

    private boolean isBootstrapNamespace() {
        return this.nsDescriptor.equals(NamespaceDescriptor.DEFAULT_NAMESPACE) || this.nsDescriptor.equals(NamespaceDescriptor.SYSTEM_NAMESPACE);
    }

    @Override
    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.getMasterServices().isInitialized() && !this.isBootstrapNamespace() && env.waitInitialized(this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireNamespaceExclusiveLock(this, this.getNamespaceName());
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseNamespaceExclusiveLock(this, this.getNamespaceName());
    }

    @Override
    public TableName getTableName() {
        return TableName.NAMESPACE_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private String getNamespaceName() {
        return this.nsDescriptor.getName();
    }

    private void prepareCreate(MasterProcedureEnv env) throws IOException {
        if (CreateNamespaceProcedure.getTableNamespaceManager(env).doesNamespaceExist(this.nsDescriptor.getName())) {
            throw new NamespaceExistException(this.nsDescriptor.getName());
        }
        CreateNamespaceProcedure.getTableNamespaceManager(env).validateTableAndRegionCount(this.nsDescriptor);
    }

    protected static void createDirectory(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path namespaceDir = FSUtils.getNamespaceDir(mfs.getRootDir(), nsDescriptor.getName());
        LOG.info((Object)("Creating directory: " + namespaceDir));
        mfs.getFileSystem().mkdirs(namespaceDir);
    }

    private void rollbackCreateDirectory(MasterProcedureEnv env) throws IOException {
        try {
            DeleteNamespaceProcedure.deleteDirectory(env, this.nsDescriptor.getName());
        }
        catch (Exception e) {
            LOG.debug((Object)("Rollback of createDirectory throws exception: " + e));
        }
    }

    protected static void insertIntoNSTable(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) throws IOException {
        CreateNamespaceProcedure.getTableNamespaceManager(env).insertIntoNSTable(nsDescriptor);
    }

    private void rollbackInsertIntoNSTable(MasterProcedureEnv env) throws IOException {
        try {
            DeleteNamespaceProcedure.deleteFromNSTable(env, this.nsDescriptor.getName());
        }
        catch (Exception e) {
            LOG.debug((Object)("Rollback of insertIntoNSTable throws exception: " + e));
        }
    }

    protected static void updateZKNamespaceManager(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) throws IOException {
        CreateNamespaceProcedure.getTableNamespaceManager(env).updateZKNamespaceManager(nsDescriptor);
    }

    private void rollbackZKNamespaceManagerChange(MasterProcedureEnv env) throws IOException {
        try {
            DeleteNamespaceProcedure.removeFromZKNamespaceManager(env, this.nsDescriptor.getName());
        }
        catch (Exception e) {
            LOG.debug((Object)("Rollback of updateZKNamespaceManager throws exception: " + e));
        }
    }

    protected static void setNamespaceQuota(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) throws IOException {
        if (env.getMasterServices().isInitialized()) {
            env.getMasterServices().getMasterQuotaManager().setNamespaceQuota(nsDescriptor);
        }
    }

    private void rollbackSetNamespaceQuota(MasterProcedureEnv env) throws IOException {
        try {
            DeleteNamespaceProcedure.removeNamespaceQuota(env, this.nsDescriptor.getName());
        }
        catch (Exception e) {
            LOG.debug((Object)("Rollback of setNamespaceQuota throws exception: " + e));
        }
    }

    private static TableNamespaceManager getTableNamespaceManager(MasterProcedureEnv env) {
        return env.getMasterServices().getTableNamespaceManager();
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    @Override
    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return !this.isBootstrapNamespace();
    }
}

